/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.content;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.verapdf.wcag.algorithms.entities.content.TextBlock;
import org.verapdf.wcag.algorithms.entities.content.TextInfoChunk;
import org.verapdf.wcag.algorithms.entities.content.TextLine;

public class TextColumn
extends TextInfoChunk {
    private final List<TextBlock> textBlocks = new ArrayList<TextBlock>();

    public TextColumn() {
    }

    public TextColumn(TextLine line) {
        super(line.getBoundingBox(), line.getFontSize(), line.getBaseLine());
        this.textBlocks.add(new TextBlock(line));
    }

    public TextColumn(TextColumn column) {
        super(column.getBoundingBox(), column.getFontSize(), column.getBaseLine());
        this.textBlocks.addAll(column.getBlocks());
    }

    public List<TextBlock> getBlocks() {
        return this.textBlocks;
    }

    public int getBlocksNumber() {
        return this.textBlocks.size();
    }

    public TextBlock getFirstTextBlock() {
        if (!this.textBlocks.isEmpty()) {
            return this.textBlocks.get(0);
        }
        return null;
    }

    public TextBlock getLastTextBlock() {
        if (!this.textBlocks.isEmpty()) {
            return this.textBlocks.get(this.textBlocks.size() - 1);
        }
        return null;
    }

    public void setLastTextBlock(TextBlock block) {
        if (!this.textBlocks.isEmpty()) {
            this.textBlocks.set(this.textBlocks.size() - 1, block);
        } else {
            this.textBlocks.add(block);
        }
    }

    public TextBlock getSecondTextBlock() {
        if (this.textBlocks.size() > 1) {
            return this.textBlocks.get(1);
        }
        return null;
    }

    public TextBlock getPenultTextBlock() {
        if (this.textBlocks.size() > 1) {
            return this.textBlocks.get(this.textBlocks.size() - 2);
        }
        return null;
    }

    public List<TextLine> getLines() {
        ArrayList<TextLine> textLines = new ArrayList<TextLine>();
        for (TextBlock textBlock : this.textBlocks) {
            textLines.addAll(textBlock.getLines());
        }
        return textLines;
    }

    public TextLine getFirstLine() {
        if (this.textBlocks.isEmpty()) {
            return null;
        }
        return this.textBlocks.get(0).getFirstLine();
    }

    public TextLine getLastLine() {
        if (this.textBlocks.isEmpty()) {
            return null;
        }
        return this.textBlocks.get(this.textBlocks.size() - 1).getLastLine();
    }

    public void setLastLine(TextLine lastLine) {
        if (!this.textBlocks.isEmpty()) {
            this.textBlocks.get(this.textBlocks.size() - 1).setLastLine(lastLine);
        } else {
            this.textBlocks.add(new TextBlock(lastLine));
        }
    }

    public void setFirstLine(TextLine firstLine) {
        if (!this.textBlocks.isEmpty()) {
            this.textBlocks.get(0).setFirstLine(firstLine);
        } else {
            this.textBlocks.add(new TextBlock(firstLine));
        }
    }

    public TextLine getSecondLine() {
        if (!this.textBlocks.isEmpty()) {
            TextBlock firstBlock = this.getFirstTextBlock();
            if (firstBlock.getLinesNumber() > 1) {
                return firstBlock.getSecondLine();
            }
            if (this.textBlocks.size() > 1) {
                return this.getSecondTextBlock().getFirstLine();
            }
        }
        return null;
    }

    public TextLine getPenultLine() {
        if (!this.textBlocks.isEmpty()) {
            TextBlock lastBlock = this.getLastTextBlock();
            if (lastBlock.getLines().size() > 1) {
                return lastBlock.getPenultLine();
            }
            if (this.textBlocks.size() > 1) {
                return this.getPenultTextBlock().getLastLine();
            }
        }
        return null;
    }

    public void add(TextLine line) {
        this.textBlocks.add(new TextBlock(line));
        super.add(line);
    }

    public int getLinesNumber() {
        return this.textBlocks.stream().mapToInt(TextBlock::getLinesNumber).sum();
    }

    public void add(TextColumn column) {
        this.textBlocks.addAll(column.getBlocks());
        super.add(column);
    }

    public boolean isEmpty() {
        return this.textBlocks.isEmpty() || this.textBlocks.stream().allMatch(TextBlock::isEmpty);
    }

    public boolean hasOnlyOneBlock() {
        return this.textBlocks.size() == 1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("");
        for (TextBlock textBlock : this.textBlocks) {
            stringBuilder.append(textBlock);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof TextColumn)) {
            return false;
        }
        TextColumn that = (TextColumn)o;
        return this.textBlocks.equals(that.textBlocks);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.textBlocks);
    }
}

