/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.lists.ListInterval;
import org.verapdf.wcag.algorithms.entities.lists.info.ListItemTextInfo;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection.ListLabelsDetectionAlgorithm;

public class ArabicNumbersListLabelsDetectionAlgorithm
extends ListLabelsDetectionAlgorithm {
    public static final String ARABIC_NUMBER_REGEX = "\\d+";

    @Override
    public boolean isListLabels(List<String> labels, int commonStartLength, int commonEndLength) {
        if (!labels.get(0).substring(commonStartLength, labels.get(0).length() - commonEndLength).matches(this.getRegex())) {
            return false;
        }
        int startLength = this.getNotRegexStartLength(labels.get(0), commonStartLength);
        int endLength = this.getNotRegexEndLength(labels.get(0), commonEndLength);
        String substring = labels.get(0).substring(startLength, labels.get(0).length() - endLength);
        Integer number = this.getNumberFromString(substring);
        if (number == null) {
            return false;
        }
        int numberOfStartZeros = ArabicNumbersListLabelsDetectionAlgorithm.getNumberOfStartZeros(substring);
        boolean haveSameStartZeros = false;
        for (int i = 1; i < labels.size(); ++i) {
            Integer nextNumber;
            String nextSubstring = labels.get(i).substring(startLength, labels.get(i).length() - endLength);
            int nextNumberOfStartsZeros = ArabicNumbersListLabelsDetectionAlgorithm.getNumberOfStartZeros(nextSubstring);
            if (numberOfStartZeros != nextNumberOfStartsZeros && (numberOfStartZeros - 1 != nextNumberOfStartsZeros || substring.length() - 1 == nextSubstring.length() || haveSameStartZeros)) {
                return false;
            }
            if (substring.length() + 1 == nextSubstring.length()) {
                haveSameStartZeros = true;
            }
            if ((nextNumber = this.getNumberFromString(nextSubstring)) == null || !nextNumber.equals(number = Integer.valueOf(number + 1))) {
                return false;
            }
            numberOfStartZeros = nextNumberOfStartsZeros;
            substring = nextSubstring;
        }
        return true;
    }

    @Override
    public Set<ListInterval> getItemsIntervals(List<ListItemTextInfo> itemsInfo) {
        HashSet<ListInterval> listIntervals = new HashSet<ListInterval>();
        ListInterval interval = new ListInterval();
        ArabicNumberInformation arabicNumberInformation = new ArabicNumberInformation();
        for (int i = 0; i < itemsInfo.size(); ++i) {
            if (arabicNumberInformation.number != null) {
                ArabicNumberInformation arabicNumberInformation2 = arabicNumberInformation;
                Integer n = arabicNumberInformation2.number;
                Integer n2 = arabicNumberInformation2.number = arabicNumberInformation2.number + 1;
                if (!arabicNumberInformation.checkItem(itemsInfo.get(i).getListItem())) {
                    if (SemanticType.LIST.equals((Object)itemsInfo.get(i).getSemanticType())) {
                        arabicNumberInformation2 = arabicNumberInformation;
                        n = arabicNumberInformation2.number;
                        n2 = arabicNumberInformation2.number = arabicNumberInformation2.number - 1;
                        interval.getListsIndexes().add(itemsInfo.get(i).getIndex());
                        continue;
                    }
                    if (interval.getNumberOfListItems() > 1) {
                        --i;
                        listIntervals.add(interval);
                    }
                    --i;
                    arabicNumberInformation.number = null;
                    continue;
                }
                interval.getListItemsInfos().add(itemsInfo.get(i));
                continue;
            }
            if (i == itemsInfo.size() - 1) continue;
            arabicNumberInformation = new ArabicNumberInformation(itemsInfo.get(i).getListItem(), itemsInfo.get(i + 1).getListItem(), i);
            interval = new ListInterval();
            interval.getListItemsInfos().add(itemsInfo.get(i));
        }
        if (arabicNumberInformation.number != null && interval.getNumberOfListItems() > 1) {
            listIntervals.add(interval);
        }
        return listIntervals;
    }

    @Override
    protected String getRegex() {
        return ARABIC_NUMBER_REGEX;
    }

    @Override
    protected String getStringFromNumber(Integer number) {
        return number.toString();
    }

    @Override
    protected Integer getNumberFromString(String string) {
        return ArabicNumbersListLabelsDetectionAlgorithm.getIntegerFromString(string);
    }

    public static Integer getIntegerFromString(String string) {
        try {
            return Integer.parseUnsignedInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static int getNumberOfStartZeros(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '0') continue;
            return i;
        }
        return s.length();
    }

    class ArabicNumberInformation {
        private Integer number;
        private final String prefix;
        private final int start;
        private int numberOfStartZeros;
        private int arabicNumberStartLength;
        private boolean haveSameStartZeros;

        ArabicNumberInformation() {
            this.number = null;
            this.prefix = null;
            this.start = 0;
            this.numberOfStartZeros = 0;
            this.arabicNumberStartLength = 0;
            this.haveSameStartZeros = true;
        }

        ArabicNumberInformation(String item, String nextItem, int i) {
            int commonLength = ListLabelsDetectionAlgorithm.getCommonStartLength(item, nextItem);
            this.start = ArabicNumbersListLabelsDetectionAlgorithm.this.getNotRegexStartLength(item, commonLength);
            String substring = item.substring(this.start);
            this.arabicNumberStartLength = ArabicNumbersListLabelsDetectionAlgorithm.this.getRegexStartLength(substring);
            substring = substring.substring(0, this.arabicNumberStartLength);
            this.number = ArabicNumbersListLabelsDetectionAlgorithm.this.getNumberFromString(substring);
            this.numberOfStartZeros = ArabicNumbersListLabelsDetectionAlgorithm.getNumberOfStartZeros(substring);
            this.haveSameStartZeros = false;
            this.prefix = item.substring(0, this.start);
        }

        private boolean checkItem(String item) {
            if (!item.startsWith(this.prefix)) {
                return false;
            }
            String nextSubstring = item.substring(this.start);
            int nextNumberOfStartsZeros = ArabicNumbersListLabelsDetectionAlgorithm.getNumberOfStartZeros(nextSubstring);
            int nextArabicNumberStartLength = ArabicNumbersListLabelsDetectionAlgorithm.this.getRegexStartLength(nextSubstring);
            if (this.numberOfStartZeros != nextNumberOfStartsZeros && (this.numberOfStartZeros - 1 != nextNumberOfStartsZeros || this.arabicNumberStartLength - 1 == nextArabicNumberStartLength || this.haveSameStartZeros)) {
                return false;
            }
            String s = ArabicNumbersListLabelsDetectionAlgorithm.this.getStringFromNumber(this.number);
            if ((this.numberOfStartZeros == nextNumberOfStartsZeros || this.numberOfStartZeros - 1 == nextNumberOfStartsZeros) && !nextSubstring.startsWith(s, nextNumberOfStartsZeros) || s.length() + nextNumberOfStartsZeros != nextArabicNumberStartLength) {
                return false;
            }
            if (this.arabicNumberStartLength + 1 == nextArabicNumberStartLength) {
                this.haveSameStartZeros = true;
                this.arabicNumberStartLength = nextArabicNumberStartLength;
            }
            this.numberOfStartZeros = nextNumberOfStartsZeros;
            return true;
        }
    }
}

