/*
 * This file is part of veraPDF wcag algorithms, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF wcag algorithms is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF wcag algorithms as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF wcag algorithms as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.wcag.algorithms.entities;

import org.verapdf.wcag.algorithms.entities.content.IChunk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Document implements IDocument {

	private final ITree tree;
	private final List<IPage> pages;

	public Document(ITree tree) {
		this.tree = tree;
		pages = new LinkedList<>();
	}

	@Override
	public ITree getTree(){
		return tree;
	}

	@Override
	public List<IChunk> getArtifacts(Integer pageNumber) {
		if (pageNumber < pages.size()) {
			return pages.get(pageNumber).getArtifacts();
		}
		return Collections.emptyList();
	}

	@Override
	public List<IPage> getPages() {
		return pages;
	}

	@Override
	public int getNumberOfPages() {
		return pages.size();
	}

	@Override
	public IPage getPage(Integer pageNumber) {
		if (pageNumber < pages.size()) {
			return pages.get(pageNumber);
		}
		return null;
	}

	@Override
	public List<IChunk> getArtifacts() {
		List<IChunk> artifacts = new ArrayList<>();
		for (IPage page : pages) {
			artifacts.addAll(page.getArtifacts());
		}
		return artifacts;
	}

}
