/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities;

import java.util.Iterator;
import org.verapdf.wcag.algorithms.entities.INode;

public class DFSTreeNodeIterator
implements Iterator<INode> {
    private final INode root;
    private int childIndex;
    private DFSTreeNodeIterator innerCurrentIterator;

    public DFSTreeNodeIterator(INode root) {
        this.root = root;
        this.childIndex = -1;
        this.nextInnerIterator();
    }

    @Override
    public boolean hasNext() {
        return this.innerCurrentIterator != null;
    }

    @Override
    public INode next() {
        if (this.innerCurrentIterator == null) {
            return null;
        }
        if (!this.innerCurrentIterator.hasNext()) {
            this.nextInnerIterator();
            if (!this.innerCurrentIterator.hasNext()) {
                this.innerCurrentIterator = null;
                return this.root;
            }
        }
        return this.innerCurrentIterator.next();
    }

    private void nextInnerIterator() {
        if (this.root == null) {
            return;
        }
        ++this.childIndex;
        this.innerCurrentIterator = this.childIndex < this.root.getChildren().size() ? new DFSTreeNodeIterator(this.root.getChildren().get(this.childIndex)) : new DFSTreeNodeIterator(null);
    }
}

