/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.consumers;

import com.github.jaiimageio.jpeg2000.impl.J2KImageReaderSpi;
import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.imageio.spi.IIORegistry;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.jbig2.JBIG2ImageReaderSpi;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.ITree;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextColumn;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.WCAGConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TextChunkUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.WCAGProgressStatus;

public class ContrastRatioConsumer
extends WCAGConsumer
implements Consumer<INode>,
Closeable {
    private final Map<Integer, BufferedImage> renderedPages = new HashMap<Integer, BufferedImage>();
    private final Map<Integer, Float> renderDpiForPages = new HashMap<Integer, Float>();
    private static final Logger logger = Logger.getLogger(ContrastRatioConsumer.class.getCanonicalName());
    private static final int RENDER_DPI = 144;
    public static final int PDF_DPI = 72;
    private static final double LUMINOSITY_DIFFERENCE = 0.001;
    private long processedTextChunks = 0L;
    private final Long textChunksNumber;
    private PDDocument document;
    private final String fileName = StaticContainers.getFileName();
    private final String password;
    private final Float imagePixelSize;
    private final boolean enableAntialias;

    public ContrastRatioConsumer() throws IOException {
        this("", false, null);
    }

    public ContrastRatioConsumer(String sourcePdfPath) throws IOException {
        this(sourcePdfPath, "", false, null);
    }

    public ContrastRatioConsumer(String sourcePdfPath, String password, boolean enableAntialias, Float imagePixelSize) throws IOException {
        this(password, enableAntialias, imagePixelSize);
        this.document = Loader.loadPDF((RandomAccessRead)new RandomAccessReadBuffer((InputStream)new FileInputStream(sourcePdfPath)));
    }

    public ContrastRatioConsumer(String password, boolean enableAntialias, Float imagePixelSize) {
        this.textChunksNumber = StaticContainers.getTextChunksNumber();
        IIORegistry registry = IIORegistry.getDefaultInstance();
        registry.registerServiceProvider(new J2KImageReaderSpi());
        registry.registerServiceProvider(new JBIG2ImageReaderSpi());
        this.password = password;
        this.processedTextChunks = 0L;
        this.imagePixelSize = imagePixelSize;
        this.enableAntialias = enableAntialias;
    }

    @Override
    public boolean run() {
        if (this.fileName == null) {
            return false;
        }
        if (!this.startStep()) {
            return true;
        }
        try {
            this.document = Loader.loadPDF((RandomAccessRead)new RandomAccessReadBuffer((InputStream)new FileInputStream(this.fileName)), (String)this.password);
            this.calculateContrast(StaticContainers.getDocument().getTree());
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.warning(e.getMessage());
        }
        return false;
    }

    public void calculateContrast(ITree tree) {
        for (INode node : tree) {
            this.accept(node);
            if (!StaticContainers.getWCAGValidationInfo().getAbortProcessing().booleanValue()) continue;
            break;
        }
    }

    @Override
    public void accept(INode node) {
        if (node.getChildren().isEmpty() && node instanceof SemanticTextNode) {
            this.calculateContrastRatio((SemanticTextNode)node);
            ++this.processedTextChunks;
        }
    }

    public double getContrastRatio(double first, double second) {
        double l1 = Math.max(first, second);
        double l2 = Math.min(first, second);
        return (l1 + 0.05) / (l2 + 0.05);
    }

    public BufferedImage getRenderPage(int pageNumber) {
        BufferedImage renderedPage = this.renderedPages.get(pageNumber);
        if (renderedPage == null) {
            try {
                renderedPage = this.renderPage(this.document, pageNumber);
                this.renderedPages.clear();
                this.renderedPages.put(pageNumber, renderedPage);
            }
            catch (IOException | IllegalArgumentException e) {
                e.printStackTrace();
                logger.warning(e.getMessage());
            }
        }
        return renderedPage;
    }

    public void calculateContrastRatio(TextChunk textChunk) {
        BufferedImage renderedPage = this.getRenderPage(textChunk.getPageNumber());
        if (renderedPage != null) {
            this.calculateContrastRation(textChunk, renderedPage);
        }
    }

    private void calculateContrastRatio(SemanticTextNode node) {
        BufferedImage renderedPage = this.getRenderPage(node.getPageNumber());
        if (renderedPage != null) {
            for (TextColumn column : node.getColumns()) {
                for (TextLine textLine : column.getLines()) {
                    for (TextChunk textChunk : textLine.getTextChunks()) {
                        this.calculateContrastRation(textChunk, renderedPage);
                    }
                }
            }
        }
    }

    public double getDpiScalingForPage(int pageNumber) {
        return (this.isUseConstantRenderDpi() ? 144.0 : (double)this.renderDpiForPages.get(pageNumber).floatValue()) / 72.0;
    }

    public boolean isUseConstantRenderDpi() {
        return this.imagePixelSize == null;
    }

    public void calculateContrastRation(TextChunk textChunk, BufferedImage renderedPage) {
        if (textChunk.getValue() != null && TextChunkUtils.isWhiteSpaceChunk(textChunk)) {
            return;
        }
        BoundingBox bBox = textChunk.getBoundingBox();
        double dpiScaling = this.getDpiScalingForPage(bBox.getPageNumber());
        int renderedPageWidth = renderedPage.getRaster().getWidth();
        int renderedPageHeight = renderedPage.getRaster().getHeight();
        BoundingBox pageBBox = new BoundingBox(textChunk.getPageNumber(), 0.0, 0.0, renderedPageWidth, renderedPageHeight);
        BoundingBox scaledBBox = new BoundingBox(textChunk.getPageNumber(), bBox.getLeftX() * dpiScaling, bBox.getBottomY() * dpiScaling, bBox.getRightX() * dpiScaling, bBox.getTopY() * dpiScaling);
        boolean isOverlappingBox = scaledBBox.overlaps(pageBBox);
        if (isOverlappingBox) {
            scaledBBox = scaledBBox.cross(pageBBox);
        } else if (!pageBBox.contains(scaledBBox)) {
            return;
        }
        int x = (int)Math.round(scaledBBox.getLeftX());
        int y = (int)Math.round(scaledBBox.getTopY());
        int width = this.getIntegerBBoxValueForProcessing(scaledBBox.getWidth(), 1.0);
        int height = this.getIntegerBBoxValueForProcessing(scaledBBox.getHeight(), 1.0);
        if (width <= 1 || height <= 1) {
            return;
        }
        try {
            BufferedImage targetBim = renderedPage.getSubimage(x, renderedPage.getHeight() - y, width, height);
            double contrastRatio = this.getContrastRatio(targetBim, textChunk);
            textChunk.setContrastRatio(contrastRatio);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public BufferedImage getPageSubImage(BoundingBox bBox) {
        int pageNumber = bBox.getPageNumber();
        BufferedImage renderedPage = this.getRenderPage(pageNumber);
        double dpiScaling = this.getDpiScalingForPage(bBox.getPageNumber());
        int renderedPageWidth = renderedPage.getRaster().getWidth();
        int renderedPageHeight = renderedPage.getRaster().getHeight();
        BoundingBox pageBBox = new BoundingBox(pageNumber, 0.0, 0.0, renderedPageWidth, renderedPageHeight);
        BoundingBox scaledBBox = new BoundingBox(pageNumber, bBox.getLeftX() * dpiScaling, bBox.getBottomY() * dpiScaling, bBox.getRightX() * dpiScaling, bBox.getTopY() * dpiScaling);
        boolean isOverlappingBox = scaledBBox.overlaps(pageBBox);
        if (!isOverlappingBox) {
            return null;
        }
        scaledBBox = scaledBBox.cross(pageBBox);
        int x = (int)Math.round(scaledBBox.getLeftX());
        int y = (int)Math.round(scaledBBox.getTopY());
        int width = this.getIntegerBBoxValueForProcessing(scaledBBox.getWidth(), 1.0);
        int height = this.getIntegerBBoxValueForProcessing(scaledBBox.getHeight(), 1.0);
        return renderedPage.getSubimage(x, renderedPage.getHeight() - y, width, height);
    }

    private double[] convertCmykToRgb(double[] cmykColorComponentArray) {
        double[] result = new double[3];
        if (cmykColorComponentArray.length == 4) {
            double black = 1.0 - cmykColorComponentArray[3];
            for (int i = 0; i < 3; ++i) {
                result[i] = (1.0 - cmykColorComponentArray[i]) * black;
            }
        }
        return result;
    }

    private Color getTextColorFromComponentArray(double[] colorComponentArray) {
        Color res = null;
        if (colorComponentArray != null) {
            if (colorComponentArray.length == 1) {
                int grayscaleValue = this.convertDoubleColorValueToRgbInteger(colorComponentArray[0]);
                res = new Color(grayscaleValue, grayscaleValue, grayscaleValue);
            } else if (colorComponentArray.length == 3) {
                res = this.makeRgbColorFromDoubleValues(colorComponentArray);
            } else if (colorComponentArray.length == 4) {
                double[] convertedRgbColor = this.convertCmykToRgb(colorComponentArray);
                res = this.makeRgbColorFromDoubleValues(convertedRgbColor);
            }
        }
        return res;
    }

    private Color makeRgbColorFromDoubleValues(double[] colorComponentArray) {
        assert (colorComponentArray.length == 3);
        return new Color(this.convertDoubleColorValueToRgbInteger(colorComponentArray[0]), this.convertDoubleColorValueToRgbInteger(colorComponentArray[1]), this.convertDoubleColorValueToRgbInteger(colorComponentArray[2]));
    }

    private int convertDoubleColorValueToRgbInteger(double value) {
        int result = (int)Math.floor(value * 256.0);
        if (result > 255) {
            result = 255;
        } else if (result < 0) {
            result = 0;
        }
        return result;
    }

    private int getIntegerBBoxValueForProcessing(double initialValue, double dpiScaling) {
        int result = (int)Math.round(initialValue * dpiScaling);
        if (result <= 0) {
            result = 1;
            logger.warning("The resulting target buffered image width is <= 0. Fall back to " + result);
        }
        return result;
    }

    private BufferedImage renderPage(PDDocument document, Integer pageNumber) throws IOException {
        RenderingHints renderingHints = new RenderingHints(null);
        renderingHints.put(RenderingHints.KEY_ANTIALIASING, this.enableAntialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        PDFRenderer pdfRenderer = new PDFRenderer(document);
        pdfRenderer.setRenderingHints(renderingHints);
        return pdfRenderer.renderImageWithDPI(pageNumber.intValue(), this.getDPI(document, pageNumber), ImageType.RGB);
    }

    public float getDPI(PDDocument document, Integer pageNumber) {
        if (this.isUseConstantRenderDpi()) {
            return 144.0f;
        }
        PDPage page = document.getPage(pageNumber.intValue());
        PDRectangle cropBox = page.getCropBox();
        float renderDpiForPage = 72.0f * this.imagePixelSize.floatValue() / Math.max(cropBox.getWidth(), cropBox.getHeight());
        this.renderDpiForPages.put(pageNumber, Float.valueOf(renderDpiForPage));
        return renderDpiForPage;
    }

    private double getContrastRatio(BufferedImage image, TextChunk textChunk) {
        double[] contrastColors;
        double[] textChunkOriginalColor = textChunk.getFontColor();
        Color textColor = this.getTextColorFromComponentArray(textChunkOriginalColor);
        double textLuminosity = 0.0;
        double approximatedTextLuminosity = 0.0;
        if (textColor != null) {
            approximatedTextLuminosity = textLuminosity = this.relativeLuminosity(textColor);
            double diff = 1.0;
            Map<Color, DataPoint> imageColorMap = this.getImageColorMap(image);
            textChunk.setBackgroundColor(this.checkForBackgroundColor(imageColorMap, textColor));
            ArrayList<DataPoint> dpFullArray = new ArrayList<DataPoint>(new TreeSet<DataPoint>(imageColorMap.values()));
            for (DataPoint dp : dpFullArray) {
                double luminosity = dp.getValue();
                double currentDifference = Math.abs(luminosity - textLuminosity);
                if (!(currentDifference <= diff)) continue;
                approximatedTextLuminosity = luminosity;
                diff = currentDifference;
            }
        }
        if (Math.abs(approximatedTextLuminosity - (contrastColors = this.get2MostPresentElements(this.getLuminosityPresenceList(image)))[0]) <= 0.001) {
            if (contrastColors[1] == -1.0) {
                if (textColor != null && Math.abs(contrastColors[0] - textLuminosity) > 0.001) {
                    contrastColors[1] = textLuminosity;
                } else {
                    return 1.0;
                }
            }
            return this.getContrastRatio(approximatedTextLuminosity, contrastColors[1]);
        }
        if (Math.abs(approximatedTextLuminosity - contrastColors[1]) <= 0.001 || textColor != null) {
            return this.getContrastRatio(approximatedTextLuminosity, contrastColors[0]);
        }
        return this.getContrastRatio(contrastColors[0], contrastColors[1]);
    }

    private double[] checkForBackgroundColor(Map<Color, DataPoint> imageColorMap, Color textColor) {
        Color backgroundColor = this.getBackgroundColor(imageColorMap, textColor);
        if (backgroundColor != null) {
            float[] components = backgroundColor.getColorComponents(null);
            return IntStream.range(0, components.length).mapToDouble(i -> components[i]).toArray();
        }
        return null;
    }

    private double getContrastRatio(BufferedImage image) {
        double[] contrastColors = this.get2MostPresentElements(this.getLuminosityPresenceList(image));
        return this.getContrastRatio(contrastColors[0], contrastColors[1]);
    }

    private double relativeLuminosity(Color color) {
        double normalizedRed = this.normalizeColorComponent(color.getRed());
        double normalizeGreen = this.normalizeColorComponent(color.getGreen());
        double normalizeBlue = this.normalizeColorComponent(color.getBlue());
        return 0.2126 * normalizedRed + 0.7152 * normalizeGreen + 0.0722 * normalizeBlue;
    }

    private double normalizeColorComponent(int colorComponent) {
        double doubleColorComponent = (double)colorComponent / 255.0;
        return doubleColorComponent < 0.03928 ? doubleColorComponent / 12.92 : Math.pow((doubleColorComponent + 0.055) / 1.055, 2.4);
    }

    private Map<Color, DataPoint> getImageColorMap(BufferedImage bim) {
        int width = bim.getWidth();
        int height = bim.getHeight();
        HashMap<Color, DataPoint> colorMap = new HashMap<Color, DataPoint>();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int rgb = bim.getRGB(i, j);
                int alpha = rgb >> 24 & 0xFF;
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                Color color = new Color(red, green, blue);
                if (colorMap.containsKey(color)) {
                    ((DataPoint)colorMap.get(color)).totalOccurrence++;
                    continue;
                }
                double relativeLuminosity = this.relativeLuminosity(color);
                colorMap.put(color, new DataPoint(relativeLuminosity));
            }
        }
        return colorMap;
    }

    private List<DataPoint> getLuminosityPresenceList(BufferedImage bim) {
        return new ArrayList<DataPoint>(new TreeSet<DataPoint>(this.getImageColorMap(bim).values()));
    }

    private Color getBackgroundColor(Map<Color, DataPoint> colorMap, Color textColor) {
        if (colorMap.size() == 1) {
            Map.Entry<Color, DataPoint> entry = colorMap.entrySet().iterator().next();
            if (!textColor.equals(entry.getKey())) {
                return entry.getKey();
            }
            return null;
        }
        List sortedOccurrences = colorMap.values().stream().map(DataPoint::getTotalOccurrence).sorted().collect(Collectors.toList());
        int firstFrequency = (Integer)sortedOccurrences.get(sortedOccurrences.size() - 1);
        int secondFrequency = (Integer)sortedOccurrences.get(sortedOccurrences.size() - 2);
        Color firstColor = null;
        Color secondColor = null;
        for (Map.Entry<Color, DataPoint> entry : colorMap.entrySet()) {
            if (firstColor == null && entry.getValue().getTotalOccurrence() == firstFrequency) {
                firstColor = entry.getKey();
            }
            if (secondColor != null || entry.getValue().getTotalOccurrence() != secondFrequency) continue;
            secondColor = entry.getKey();
        }
        if (firstColor != null && !NodeUtils.hasSimilarBackgroundColor(textColor, firstColor)) {
            return firstColor;
        }
        if (secondColor != null && !NodeUtils.hasSimilarBackgroundColor(textColor, secondColor)) {
            return secondColor;
        }
        return null;
    }

    private List<DataPoint> findLocalMaximums(List<DataPoint> source) {
        ArrayList<DataPoint> localMaximums = new ArrayList<DataPoint>();
        boolean isPreviousLessThanCurrent = true;
        for (int i = 0; i < source.size() - 1; ++i) {
            boolean isNextLessThanCurrent;
            boolean bl = isNextLessThanCurrent = source.get(i).totalOccurrence > source.get(i + 1).totalOccurrence;
            if (isNextLessThanCurrent && isPreviousLessThanCurrent) {
                localMaximums.add(source.get(i));
            }
            isPreviousLessThanCurrent = !isNextLessThanCurrent;
        }
        if (isPreviousLessThanCurrent) {
            localMaximums.add(source.get(source.size() - 1));
        }
        return localMaximums;
    }

    private double[] get2MostPresentElements(List<DataPoint> source) {
        double absoluteMaxPresent = -1.0;
        double secondMaxPresent = -1.0;
        int max = 0;
        int secondMax = 0;
        for (DataPoint dataPoint : source) {
            if (dataPoint.totalOccurrence >= max) {
                secondMaxPresent = absoluteMaxPresent;
                secondMax = max;
                absoluteMaxPresent = dataPoint.value;
                max = dataPoint.totalOccurrence;
                continue;
            }
            if (dataPoint.totalOccurrence < secondMax) continue;
            secondMax = dataPoint.totalOccurrence;
            secondMaxPresent = dataPoint.value;
        }
        return new double[]{absoluteMaxPresent, secondMaxPresent};
    }

    @Override
    public Double getPercent() {
        return 100.0 * (double)this.processedTextChunks / (double)this.textChunksNumber.longValue();
    }

    @Override
    public void close() throws IOException {
        if (this.document != null) {
            this.document.close();
        }
    }

    public Float getImagePixelSize() {
        return this.imagePixelSize;
    }

    @Override
    public WCAGProgressStatus getWCAGProgressStatus() {
        return WCAGProgressStatus.CONTRAST_DETECTION;
    }

    static class DataPoint
    implements Comparable<DataPoint> {
        private double value;
        private int totalOccurrence;

        public DataPoint() {
        }

        public DataPoint(double value) {
            this.value = value;
            this.totalOccurrence = 1;
        }

        public double getValue() {
            return this.value;
        }

        public int getTotalOccurrence() {
            return this.totalOccurrence;
        }

        public void setTotalOccurrence(int totalOccurrence) {
            this.totalOccurrence = totalOccurrence;
        }

        @Override
        public int compareTo(DataPoint o) {
            return Double.compare(this.value, o.value);
        }
    }
}

