/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.consumers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.NodeInfo;
import org.verapdf.wcag.algorithms.entities.SemanticCaption;
import org.verapdf.wcag.algorithms.entities.SemanticFigure;
import org.verapdf.wcag.algorithms.entities.SemanticList;
import org.verapdf.wcag.algorithms.entities.SemanticParagraph;
import org.verapdf.wcag.algorithms.entities.SemanticSpan;
import org.verapdf.wcag.algorithms.entities.SemanticTable;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.ImageChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextColumn;
import org.verapdf.wcag.algorithms.entities.content.TextInfoChunk;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.lists.ListElement;
import org.verapdf.wcag.algorithms.entities.lists.ListItem;
import org.verapdf.wcag.algorithms.entities.lists.PDFList;
import org.verapdf.wcag.algorithms.entities.tables.Table;
import org.verapdf.wcag.algorithms.entities.tables.TableCell;
import org.verapdf.wcag.algorithms.entities.tables.TableRow;
import org.verapdf.wcag.algorithms.entities.tables.TableToken;
import org.verapdf.wcag.algorithms.entities.tables.TableTokenRow;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorder;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.ListDetectionConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.WCAGConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.containers.StaticContainers;
import org.verapdf.wcag.algorithms.semanticalgorithms.tables.TableCluster;
import org.verapdf.wcag.algorithms.semanticalgorithms.tables.TableRecognitionArea;
import org.verapdf.wcag.algorithms.semanticalgorithms.tables.TableRecognizer;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.CaptionUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.HeadingUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ListUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TableUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TextChunkUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.WCAGProgressStatus;

public class ClusterTableConsumer
extends WCAGConsumer {
    private static final Logger LOGGER = Logger.getLogger(ClusterTableConsumer.class.getCanonicalName());
    private TableRecognitionArea recognitionArea;
    private final List<Table> tables = new ArrayList<Table>();
    private final List<PDFList> lists = new ArrayList<PDFList>();

    public ClusterTableConsumer() {
        this.init();
    }

    @Override
    public boolean run() {
        if (!StaticContainers.isHuman().booleanValue()) {
            return false;
        }
        if (!this.startStep()) {
            return true;
        }
        this.findTables(StaticContainers.getDocument().getTree().getRoot());
        return false;
    }

    private void init() {
        this.recognitionArea = new TableRecognitionArea();
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public List<PDFList> getLists() {
        return this.lists;
    }

    public void findTables(INode root) {
        this.acceptChildren(root);
        if (this.recognitionArea.isValid()) {
            ArrayList<INode> restNodes = new ArrayList<INode>(this.recognize());
            this.init();
            restNodes.add(root);
            for (INode restNode : restNodes) {
                this.accept(restNode);
            }
        }
        this.updateTreeWithRecognizedTables(root);
        this.updateTreeWithRecognizedLists(root);
    }

    private void acceptChildren(INode node) {
        INode accumulatedNode;
        if (node.getSemanticType() == SemanticType.TABLE) {
            INode accumulatedNode2 = StaticContainers.getAccumulatedNodeMapper().get(node);
            if (accumulatedNode2 instanceof SemanticTable) {
                TableToken token = new TableToken(((SemanticTable)accumulatedNode2).getTableBorder());
                this.accept(token, node);
            }
            return;
        }
        if (node.getSemanticType() == SemanticType.PARAGRAPH) {
            accumulatedNode = StaticContainers.getAccumulatedNodeMapper().get(node);
            if (accumulatedNode instanceof SemanticParagraph) {
                SemanticParagraph paragraph = (SemanticParagraph)accumulatedNode;
                if (paragraph.isEmpty() || paragraph.isSpaceNode()) {
                    return;
                }
                if (paragraph.getColumnsNumber() == 1 && paragraph.getLinesNumber() != 1) {
                    TableCluster cluster = new TableCluster(paragraph, node);
                    this.accept(cluster, node);
                    return;
                }
            }
        } else if (node.getSemanticType() == SemanticType.LIST) {
            SemanticList list;
            accumulatedNode = StaticContainers.getAccumulatedNodeMapper().get(node);
            if (accumulatedNode instanceof SemanticList && (list = (SemanticList)accumulatedNode).getNumberOfListColumns() == 1 && node.getChildren().size() == list.getNumberOfListItemsAndLists() && list.getNumberOfListItems() > 1) {
                TableCluster cluster = new TableCluster((SemanticTextNode)accumulatedNode, node);
                this.accept(cluster, node);
                return;
            }
        } else if (node.getSemanticType() == SemanticType.TABLE_OF_CONTENT || node.getSemanticType() == SemanticType.TABLE_OF_CONTENT_ITEM) {
            return;
        }
        for (INode child : node.getChildren()) {
            this.acceptChildren(child);
            this.accept(child);
        }
    }

    private void accept(INode node) {
        block4: {
            block5: {
                if (!node.getChildren().isEmpty()) break block4;
                if (!(node instanceof SemanticTextNode)) break block5;
                SemanticTextNode textNode = (SemanticTextNode)node;
                for (TextColumn column : textNode.getColumns()) {
                    for (TextLine line : column.getLines()) {
                        for (TextChunk chunk : line.getTextChunks()) {
                            if (TextChunkUtils.isWhiteSpaceChunk(chunk)) continue;
                            TableToken token = new TableToken(chunk, node);
                            this.accept(token, node);
                        }
                    }
                }
                break block4;
            }
            if (!(node instanceof SemanticFigure)) break block4;
            SemanticFigure imageNode = (SemanticFigure)node;
            for (ImageChunk imageChunk : imageNode.getImages()) {
                TableToken token = new TableToken(imageChunk, (INode)imageNode);
                this.accept(token, node);
            }
        }
    }

    private void findTableBorder() {
        TableBorder tableBorder = StaticContainers.getTableBordersCollection().getTableBorder(this.recognitionArea.getBoundingBox());
        if (tableBorder != null) {
            this.recognitionArea.setTableBorder(tableBorder);
        }
    }

    private void accept(TextInfoChunk token, INode node) {
        if (this.recognitionArea.addTokenToRecognitionArea(token) && this.recognitionArea.getTableBorder() == null) {
            this.findTableBorder();
        }
        if (this.recognitionArea.isComplete()) {
            ArrayList<INode> restNodes = new ArrayList<INode>();
            if (this.recognitionArea.isValid()) {
                restNodes.addAll(this.recognize());
            }
            this.init();
            restNodes.add(node);
            for (INode restNode : restNodes) {
                this.acceptChildren(restNode);
                this.accept(restNode);
            }
        }
    }

    private List<INode> recognize() {
        TableRecognizer recognizer = new TableRecognizer(this.recognitionArea);
        recognizer.recognize();
        Table recognizedTable = recognizer.getTable();
        if (recognizedTable != null) {
            if (recognizedTable.getTableBorder() == null && ListUtils.isList(recognizedTable)) {
                if (!HeadingUtils.isHeadings(recognizedTable)) {
                    PDFList list = new PDFList(recognizedTable);
                    this.lists.add(list);
                }
            } else if (this.checkTable(recognizedTable)) {
                this.tables.add(recognizedTable);
            }
            return recognizedTable.getRestNodes();
        }
        return new ArrayList<INode>();
    }

    private boolean checkTable(Table recognizedTable) {
        for (int rowNumber = 0; rowNumber < recognizedTable.getNumberOfRows(); ++rowNumber) {
            if (recognizedTable.getRows().get(rowNumber).getNumberOfCellsWithContent() >= 2) continue;
            return false;
        }
        return ClusterTableConsumer.checkTableCellsLeftAndRight(recognizedTable) && ClusterTableConsumer.checkTableCellsTopsAndBottom(recognizedTable);
    }

    private static boolean checkTableCellsTopsAndBottom(Table recognizedTable) {
        Double previousMinBottom = null;
        Double previousMinTop = null;
        for (int rowNumber = 0; rowNumber < recognizedTable.getNumberOfRows(); ++rowNumber) {
            TableRow row = recognizedTable.getRows().get(rowNumber);
            Double maxBottom = null;
            Double minBottom = null;
            Double maxTop = null;
            Double minTop = null;
            for (int colNumber = 0; colNumber < row.getCells().size(); ++colNumber) {
                TableCell cell = row.getCells().get(colNumber);
                if (cell.getContent().isEmpty()) continue;
                BoundingBox cellBoundingBox = cell.getBoundingBox();
                if (maxBottom == null || cellBoundingBox.getBottomY() > maxBottom) {
                    maxBottom = cellBoundingBox.getBottomY();
                }
                if (minBottom == null || cellBoundingBox.getBottomY() < minBottom) {
                    minBottom = cellBoundingBox.getBottomY();
                }
                if (maxTop == null || cellBoundingBox.getTopY() > maxTop) {
                    maxTop = cellBoundingBox.getTopY();
                }
                if (minTop != null && !(cellBoundingBox.getTopY() < minTop)) continue;
                minTop = cellBoundingBox.getTopY();
            }
            if (previousMinBottom != null && maxBottom != null && previousMinBottom < maxBottom) {
                return false;
            }
            if (previousMinTop != null && minTop != null && previousMinTop < minTop) {
                return false;
            }
            if (minBottom != null) {
                previousMinBottom = minBottom;
            }
            if (minTop == null) continue;
            previousMinTop = minTop;
        }
        return true;
    }

    private static boolean checkTableCellsLeftAndRight(Table recognizedTable) {
        Double previousMaxRight = null;
        Double previousMaxLeft = null;
        for (int colNumber = 0; colNumber < recognizedTable.getNumberOfColumns(); ++colNumber) {
            Double maxLeft = null;
            Double minLeft = null;
            Double maxRight = null;
            Double minRight = null;
            for (int rowNumber = 0; rowNumber < recognizedTable.getNumberOfRows(); ++rowNumber) {
                TableCell cell;
                List<TableCell> cells = recognizedTable.getRows().get(rowNumber).getCells();
                if (cells.size() <= colNumber || (cell = cells.get(colNumber)).getContent().isEmpty()) continue;
                BoundingBox cellBoundingBox = cell.getBoundingBox();
                if (maxRight == null || cellBoundingBox.getRightX() > maxRight) {
                    maxRight = cellBoundingBox.getRightX();
                }
                if (minRight == null || cellBoundingBox.getRightX() < minRight) {
                    minRight = cellBoundingBox.getRightX();
                }
                if (maxLeft == null || cellBoundingBox.getLeftX() > maxLeft) {
                    maxLeft = cellBoundingBox.getLeftX();
                }
                if (minLeft != null && !(cellBoundingBox.getLeftX() < minLeft)) continue;
                minLeft = cellBoundingBox.getLeftX();
            }
            if (previousMaxRight != null && minRight != null && previousMaxRight > minRight) {
                return false;
            }
            if (previousMaxLeft != null && minLeft != null && previousMaxLeft > minLeft) {
                return false;
            }
            if (maxRight != null) {
                previousMaxRight = maxRight;
            }
            if (maxLeft == null) continue;
            previousMaxLeft = maxLeft;
        }
        return true;
    }

    private void updateTreeWithRecognizedTables(INode root) {
        this.initTreeNodeInfo(root);
        ArrayList<INode> tableRoots = new ArrayList<INode>(this.tables.size());
        for (Table table : this.tables) {
            tableRoots.add(this.updateTreeWithRecognizedTable(table, root));
        }
        Integer firstTablePartIndex = null;
        for (int i = 0; i < this.tables.size(); ++i) {
            Table table = this.tables.get(i);
            INode tableRoot = (INode)tableRoots.get(i);
            if (tableRoot == null) {
                firstTablePartIndex = null;
                continue;
            }
            if (firstTablePartIndex != null) {
                if (this.tables.get(i - 1).getPageNumber() + 1 != table.getPageNumber()) {
                    firstTablePartIndex = null;
                } else if (tableRoots.get(i - 1) != tableRoot) {
                    firstTablePartIndex = null;
                } else {
                    if (!ClusterTableConsumer.isNodeInsideTable(tableRoot, table.getId(), table.getBoundingBox(), SemanticType.TABLE)) {
                        firstTablePartIndex = null;
                        continue;
                    }
                    if (tableRoot.getLastPageNumber() == null || table.getPageNumber().equals(tableRoot.getLastPageNumber())) {
                        this.updateTableNode(table, tableRoot);
                        for (int index = firstTablePartIndex.intValue(); index < i; ++index) {
                            StaticContainers.getIdMapper().put(this.tables.get(index).getId(), table.getId());
                            this.tables.get(index).setId(table.getId());
                        }
                    }
                }
            }
            if (firstTablePartIndex != null || tableRoot.getPageNumber() != null && !table.getPageNumber().equals(tableRoot.getPageNumber())) continue;
            if (tableRoot.getPageNumber() != null && tableRoot.getLastPageNumber() > table.getPageNumber()) {
                if (!ClusterTableConsumer.isNodeInsideTable(tableRoot, table.getId(), table.getBoundingBox(), SemanticType.TABLE)) continue;
                firstTablePartIndex = i;
                continue;
            }
            if (!ClusterTableConsumer.isNodeInsideTable(tableRoot, table.getId(), table.getBoundingBox(), SemanticType.TABLE)) continue;
            this.updateTableNode(table, tableRoot);
        }
    }

    private void updateTableNode(Table table, INode tableRoot) {
        if (table.getBodyNode() != null) {
            this.updateNode(table.getBodyNode(), table.getId(), SemanticType.TABLE_BODY, table.getTableBorder() != null, table.getBoundingBox());
        }
        if (this.updateNode(tableRoot, table.getId(), SemanticType.TABLE, table.getTableBorder() != null, table.getBoundingBox())) {
            ClusterTableConsumer.detectTableCaptions(table.getBoundingBox(), tableRoot);
        }
    }

    public static void detectTableCaptions(BoundingBox tableBoundingBox, INode tableRoot) {
        INode captionNode;
        double captionProbability;
        double nextCaptionProbability;
        INode previousNode = tableRoot.getPreviousNeighbor();
        INode nextNode = tableRoot.getNextNeighbor();
        double previousCaptionProbability = CaptionUtils.tableCaptionProbability(previousNode, tableBoundingBox);
        if (previousCaptionProbability > (nextCaptionProbability = CaptionUtils.tableCaptionProbability(nextNode, tableBoundingBox))) {
            captionProbability = previousCaptionProbability;
            captionNode = previousNode;
        } else {
            captionProbability = nextCaptionProbability;
            captionNode = nextNode;
        }
        if (captionProbability >= 0.75) {
            StaticContainers.getAccumulatedNodeMapper().updateNode(captionNode, new SemanticCaption((SemanticTextNode)StaticContainers.getAccumulatedNodeMapper().get(captionNode)), captionProbability * captionNode.getCorrectSemanticScore(), SemanticType.CAPTION);
        }
    }

    private INode updateTreeWithRecognizedTable(Table table, INode root) {
        HashMap rowNodes = new HashMap();
        rowNodes.put(SemanticType.TABLE_HEADERS, new HashSet());
        rowNodes.put(SemanticType.TABLE_BODY, new HashSet());
        for (int i = 0; i < table.getRows().size(); ++i) {
            TableRow row = table.getRows().get(i);
            INode rowNode = this.updateTreeWithRecognizedTableRow(table, row, i == 0 ? null : table.getRows().get(i - 1));
            if (rowNode == null) continue;
            this.updateNode(rowNode, table.getId(), SemanticType.TABLE_ROW, table.getTableBorder() != null, table.getBoundingBox());
            SemanticType semanticType = row.getSemanticType();
            Set nodes = (Set)rowNodes.get((Object)semanticType);
            if (nodes == null) continue;
            nodes.add(rowNode);
        }
        Set headersNodes = (Set)rowNodes.get((Object)SemanticType.TABLE_HEADERS);
        if (headersNodes.size() == 1 && headersNodes.equals(rowNodes.get((Object)SemanticType.TABLE_BODY))) {
            return (INode)headersNodes.iterator().next();
        }
        HashSet<INode> localRoots = new HashSet<INode>();
        for (Map.Entry entry : rowNodes.entrySet()) {
            SemanticType type = (SemanticType)((Object)entry.getKey());
            Set rows = (Set)entry.getValue();
            INode localRoot = ClusterTableConsumer.findLocalRoot(rows);
            if (localRoot == null) continue;
            if (type == SemanticType.TABLE_BODY && !Objects.equals(localRoot.getPageNumber(), localRoot.getLastPageNumber())) {
                table.setBodyNode(localRoot);
            } else {
                this.updateNode(localRoot, table.getId(), type, table.getTableBorder() != null, table.getBoundingBox());
            }
            localRoots.add(localRoot);
        }
        if (localRoots.isEmpty()) {
            return null;
        }
        if (localRoots.size() == 1) {
            return (INode)localRoots.iterator().next();
        }
        ArrayList localRootsList = new ArrayList(localRoots);
        if (((INode)localRootsList.get((int)0)).getNodeInfo().depth < ((INode)localRootsList.get((int)1)).getNodeInfo().depth && this.isAncestorFor((INode)localRootsList.get(0), (INode)localRootsList.get(1))) {
            return (INode)localRootsList.get(0);
        }
        if (((INode)localRootsList.get((int)1)).getNodeInfo().depth < ((INode)localRootsList.get((int)0)).getNodeInfo().depth && this.isAncestorFor((INode)localRootsList.get(1), (INode)localRootsList.get(0))) {
            return (INode)localRootsList.get(1);
        }
        return ClusterTableConsumer.findLocalRoot(localRoots);
    }

    private INode updateTreeWithRecognizedTableRow(Table table, TableRow row, TableRow previousRow) {
        Long id = table.getId();
        HashMap<INode, Integer> cellNodes = new HashMap<INode, Integer>();
        for (int i = 0; i < row.getCells().size(); ++i) {
            INode cellNode = ClusterTableConsumer.getTableCellNode(row.getCells().get(i));
            if (cellNode == null) continue;
            cellNodes.put(cellNode, i);
        }
        INode rowNode = ClusterTableConsumer.findLocalRoot(cellNodes.keySet());
        if (row.getNumberOfCellsWithContent() == 1 && rowNode.getParent() != null && rowNode.getParent().getInitialSemanticType() == SemanticType.TABLE_ROW) {
            rowNode = rowNode.getParent();
        }
        for (Map.Entry entry : cellNodes.entrySet()) {
            Integer colNumber;
            INode cellNode = (INode)entry.getKey();
            while (cellNode.getParent() != null && cellNode.getParent() != rowNode && !ClusterTableConsumer.hasOtherChildrenWithContents(cellNode.getParent(), cellNode)) {
                cellNode = cellNode.getParent();
            }
            SemanticType cellType = this.isHeaderCell(cellNode, colNumber, (colNumber = (Integer)entry.getValue()) == 0 ? null : row.getCells().get(colNumber - 1), previousRow) ? SemanticType.TABLE_HEADER : SemanticType.TABLE_CELL;
            if (!this.updateNode(cellNode, id, cellType, table.getTableBorder() != null, table.getBoundingBox())) continue;
            row.getCells().get(colNumber).setSemanticType(cellType);
        }
        return rowNode;
    }

    private boolean isHeaderCell(INode cellNode, Integer columnNumber, TableCell previousCell, TableRow previousRow) {
        if (cellNode.getInitialSemanticType() != SemanticType.TABLE_HEADER) {
            return false;
        }
        if (previousCell == null || previousRow == null || previousCell.getSemanticType() == SemanticType.TABLE_HEADER) {
            return true;
        }
        return columnNumber < previousRow.getCells().size() && previousRow.getCells().get(columnNumber).getSemanticType() == SemanticType.TABLE_HEADER;
    }

    public static INode getTableCellNode(TableCell cell) {
        HashSet<INode> tableLeafNodes = new HashSet<INode>();
        for (TableTokenRow tokenRow : cell.getContent()) {
            for (TextChunk chunk : tokenRow.getTextChunks()) {
                TableToken token;
                if (!(chunk instanceof TableToken) || (token = (TableToken)chunk).getNode() == null) continue;
                if (token.getNode().getChildren().isEmpty()) {
                    tableLeafNodes.add(token.getNode());
                    continue;
                }
                tableLeafNodes.addAll(token.getNode().getChildren());
            }
        }
        return ClusterTableConsumer.findLocalRoot(tableLeafNodes);
    }

    private void updateTreeWithRecognizedLists(INode root) {
        this.initTreeNodeInfo(root);
        for (PDFList list : this.lists) {
            INode listRoot = this.updateTreeWithRecognizedList(list);
            if (listRoot == null) continue;
            this.updateNode(listRoot, list.getRecognizedStructureId(), SemanticType.LIST, false, list.getBoundingBox());
        }
    }

    private INode updateTreeWithRecognizedList(PDFList list) {
        HashSet<INode> nodes = new HashSet<INode>();
        boolean hasTaggedListItems = true;
        for (int index = 0; index < list.getNumberOfListItems(); ++index) {
            ListItem item = list.getListItems().get(index);
            INode itemNode = this.updateTreeWithRecognizedListItem(item, list);
            if (itemNode == null) continue;
            this.updateNode(itemNode, list.getRecognizedStructureId(), SemanticType.LIST_ITEM, false, list.getBoundingBox());
            nodes.add(itemNode);
            if (ListDetectionConsumer.isTwoListItemsOnTwoPages(itemNode)) {
                ListItem newItem;
                if (itemNode.getPageNumber() < item.getPageNumber()) {
                    newItem = new ListItem(itemNode.getBoundingBox().getBoundingBox(itemNode.getPageNumber()), list.getRecognizedStructureId());
                    list.add(index, newItem);
                } else {
                    newItem = new ListItem(itemNode.getBoundingBox().getBoundingBox(itemNode.getPageNumber() + 1), list.getRecognizedStructureId());
                    list.add(index + 1, newItem);
                }
                ++index;
            }
            if (itemNode.getInitialSemanticType() == SemanticType.LIST_ITEM) continue;
            hasTaggedListItems = false;
        }
        if (!hasTaggedListItems) {
            StaticContainers.getListsCollection().add(list);
        }
        if (nodes.size() == 1) {
            return (INode)nodes.iterator().next();
        }
        return ClusterTableConsumer.findLocalRoot(nodes);
    }

    private boolean updateNode(INode node, Long id, SemanticType semanticType, boolean hasTableBorder, BoundingBox boundingBox) {
        if ((ListUtils.isDetectedListNode(node) && !hasTableBorder || TableUtils.isTableNode(node)) && !Objects.equals(node.getRecognizedStructureId(), id) || semanticType != SemanticType.TABLE && !ClusterTableConsumer.isNodeInsideTable(node, id, boundingBox, semanticType)) {
            node.setRecognizedStructureId(null);
            return false;
        }
        node.setRecognizedStructureId(id);
        node.setSemanticType(semanticType);
        node.setCorrectSemanticScore(1.0);
        return true;
    }

    public static boolean isNodeInsideTable(INode node, Long id, BoundingBox boundingBox, SemanticType semanticType) {
        if (Objects.equals(node.getRecognizedStructureId(), id)) {
            return true;
        }
        if (node instanceof SemanticTextNode) {
            SemanticTextNode textNode = (SemanticTextNode)node;
            return ClusterTableConsumer.isTextNodeInsideTable(textNode, boundingBox);
        }
        if (node instanceof SemanticFigure) {
            for (ImageChunk image : ((SemanticFigure)node).getImages()) {
                if (boundingBox.getPageNumber() >= image.getPageNumber() || boundingBox.getLastPageNumber() <= image.getLastPageNumber() || boundingBox.contains(image.getBoundingBox(), 0.6, 0.6)) continue;
                return false;
            }
            return true;
        }
        if (node.getPageNumber() != null && semanticType != SemanticType.TABLE && semanticType != SemanticType.TABLE_BODY && (node.getPageNumber() < boundingBox.getPageNumber() || node.getLastPageNumber() > boundingBox.getPageNumber())) {
            return false;
        }
        for (INode child : node.getChildren()) {
            if (ClusterTableConsumer.isNodeInsideTable(child, id, boundingBox, semanticType)) continue;
            return false;
        }
        return true;
    }

    private static boolean isTextNodeInsideTable(SemanticTextNode textNode, BoundingBox boundingBox) {
        for (TextColumn column : textNode.getColumns()) {
            for (TextLine line : column.getLines()) {
                for (TextChunk chunk : line.getTextChunks()) {
                    if (TextChunkUtils.isWhiteSpaceChunk(chunk) || boundingBox.getPageNumber() > chunk.getPageNumber() || boundingBox.getLastPageNumber() < chunk.getLastPageNumber() || boundingBox.contains(chunk.getBoundingBox(), 0.6, 0.6)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private INode updateTreeWithRecognizedListItem(ListItem item, PDFList list) {
        INode bodyNode;
        HashMap<INode, SemanticType> elementsNodes = new HashMap<INode, SemanticType>();
        INode labelNode = this.updateTreeWithRecognizedListElement(item.getLabel());
        if (labelNode != null) {
            elementsNodes.put(labelNode, item.getLabel().getSemanticType());
        }
        if ((bodyNode = this.updateTreeWithRecognizedListElement(item.getBody())) != null) {
            elementsNodes.put(bodyNode, item.getBody().getSemanticType());
        }
        INode itemNode = ClusterTableConsumer.findLocalRoot(elementsNodes.keySet());
        while (itemNode.getParent() != null && itemNode.getParent().getChildren().size() == 1) {
            itemNode = itemNode.getParent();
        }
        for (Map.Entry entry : elementsNodes.entrySet()) {
            INode elementNode = (INode)entry.getKey();
            while (elementNode.getParent() != null && elementNode.getParent() != itemNode && elementNode.getParent().getChildren().size() == 1) {
                elementNode = elementNode.getParent();
            }
            this.updateNode(elementNode, list.getRecognizedStructureId(), (SemanticType)((Object)entry.getValue()), false, list.getBoundingBox());
        }
        return itemNode;
    }

    private INode updateTreeWithRecognizedListElement(ListElement listElement) {
        HashSet<INode> tableLeafNodes = new HashSet<INode>();
        for (TableTokenRow tokenRow : listElement.getContent()) {
            for (TextChunk chunk : tokenRow.getTextChunks()) {
                TableToken token;
                if (!(chunk instanceof TableToken) || (token = (TableToken)chunk).getNode() == null) continue;
                tableLeafNodes.add(token.getNode());
            }
        }
        return ClusterTableConsumer.findLocalRoot(tableLeafNodes);
    }

    public static INode findLocalRoot(Set<INode> nodes) {
        INode localRoot = null;
        block0: for (INode node : nodes) {
            if (node.isRoot()) {
                localRoot = node;
                break;
            }
            if (localRoot == null) {
                localRoot = node.getParent();
            }
            while (!node.isRoot()) {
                INode parent = node.getParent();
                NodeInfo parentInfo = parent.getNodeInfo();
                ++parentInfo.counter;
                if (parentInfo.counter > 1) {
                    if (parentInfo.depth >= localRoot.getNodeInfo().depth) continue block0;
                    localRoot = parent;
                    continue block0;
                }
                node = parent;
            }
        }
        ClusterTableConsumer.initTreeCounters(localRoot);
        return localRoot;
    }

    private boolean isAncestorFor(INode first, INode second) {
        while (!second.isRoot()) {
            if ((second = second.getParent()) != first) continue;
            return true;
        }
        return false;
    }

    private static void initTreeCounters(INode root) {
        if (root == null) {
            return;
        }
        Stack<INode> nodeStack = new Stack<INode>();
        nodeStack.push(root);
        while (!nodeStack.isEmpty()) {
            INode node = (INode)nodeStack.pop();
            NodeInfo nodeInfo = node.getNodeInfo();
            nodeInfo.counter = 0;
            for (INode child : node.getChildren()) {
                nodeStack.push(child);
            }
        }
        while (!root.isRoot()) {
            root = root.getParent();
            root.getNodeInfo().counter = 0;
        }
    }

    private void initTreeNodeInfo(INode root) {
        Stack<INode> nodeStack = new Stack<INode>();
        nodeStack.push(root);
        while (!nodeStack.isEmpty()) {
            INode node = (INode)nodeStack.pop();
            NodeInfo nodeInfo = node.getNodeInfo();
            nodeInfo.depth = node.isRoot() ? 0 : node.getParent().getNodeInfo().depth + 1;
            nodeInfo.counter = 0;
            for (INode child : node.getChildren()) {
                nodeStack.push(child);
            }
        }
    }

    private static boolean hasOtherChildrenWithContents(INode parent, INode node) {
        for (INode child : parent.getChildren()) {
            SemanticSpan span;
            if (child == node) continue;
            if (child instanceof SemanticFigure) {
                return !((SemanticFigure)child).getImages().isEmpty();
            }
            if (!(child instanceof SemanticSpan ? !(span = (SemanticSpan)child).isSpaceNode() && !span.isEmpty() : ClusterTableConsumer.hasOtherChildrenWithContents(child, null))) continue;
            return true;
        }
        return false;
    }

    @Override
    public WCAGProgressStatus getWCAGProgressStatus() {
        return WCAGProgressStatus.TABLE_DETECTION;
    }
}

