/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.sa;

import java.util.Objects;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.sa.GFSAPage;
import org.verapdf.pd.PDAnnotation;
import org.verapdf.pd.PDNameTreeNode;
import org.verapdf.pd.PDNamesDictionary;
import org.verapdf.pd.PDPage;
import org.verapdf.pd.actions.PDAction;
import org.verapdf.tools.StaticResources;
import org.verapdf.wcag.algorithms.entities.AnnotationNode;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;

public class GFSAAnnotationNode
extends AnnotationNode {
    public GFSAAnnotationNode(PDAnnotation annotation) {
        super(annotation.getSubtype().getValue(), GFSAAnnotationNode.getBoundingBox(annotation), GFSAAnnotationNode.getPageNumber(GFSAAnnotationNode.getDestination(annotation, ASAtom.D)), GFSAAnnotationNode.getObjectKeyNumber(GFSAAnnotationNode.getDestination(annotation, ASAtom.SD)));
    }

    private static BoundingBox getBoundingBox(PDAnnotation annotation) {
        Integer pageNumber = GFSAAnnotationNode.getAnnotationPageNumber(annotation);
        double[] rect = annotation.getRect();
        BoundingBox boundingBox = new BoundingBox(pageNumber, rect);
        if (pageNumber != null) {
            PDPage page = (PDPage)StaticResources.getDocument().getPages().get(pageNumber);
            boundingBox = GFSAPage.createCurrentTransformationMatrix(page).transformBoundingBox(boundingBox);
        }
        return boundingBox;
    }

    private static Integer getAnnotationPageNumber(PDAnnotation annotation) {
        Integer pageNumber = GFSAAnnotationNode.getPageNumber(annotation.getParent());
        if (pageNumber != null) {
            return pageNumber;
        }
        if (annotation.getObject().getKey() == null) {
            return null;
        }
        for (PDPage page : StaticResources.getDocument().getPages()) {
            COSObject annots = page.getKey(ASAtom.ANNOTS);
            if (annots.empty() || annots.getType() != COSObjType.COS_ARRAY) continue;
            for (COSObject annot : (COSArray)annots.getDirectBase()) {
                if (!annotation.getObject().getKey().equals((Object)annot.getKey())) continue;
                return page.getPageNumber();
            }
        }
        return null;
    }

    private static Integer getPageNumber(COSObject obj) {
        if (obj != null && ASAtom.PAGE == obj.getNameKey(ASAtom.TYPE)) {
            for (PDPage page : StaticResources.getDocument().getPages()) {
                if (!Objects.equals(obj.getKey(), page.getObject().getKey())) continue;
                return page.getPageNumber();
            }
        }
        return null;
    }

    private static Integer getObjectKeyNumber(COSObject obj) {
        if (obj != null && ASAtom.STRUCT_ELEM == obj.getNameKey(ASAtom.TYPE)) {
            return obj.getKey() != null ? Integer.valueOf(obj.getKey().getNumber()) : null;
        }
        return null;
    }

    private static COSObject getDestination(PDAnnotation annot, ASAtom key) {
        COSObject dests;
        PDAction action;
        COSObject destination = annot.getDestination();
        if ((destination == null || destination.empty()) && (action = annot.getA()) != null && ASAtom.GO_TO == action.getSubtype()) {
            destination = action.getObject().getKey(key);
        }
        if (destination == null || destination.empty()) {
            return null;
        }
        if (destination.getType() == COSObjType.COS_STRING) {
            PDNamesDictionary namesDictionary = StaticResources.getDocument().getCatalog().getNamesDictionary();
            if (namesDictionary == null) {
                return null;
            }
            PDNameTreeNode dests2 = namesDictionary.getDests();
            if (dests2 != null && (destination = dests2.getObject(destination.getString())) == null) {
                return null;
            }
        } else if (destination.getType() == COSObjType.COS_NAME && (dests = StaticResources.getDocument().getCatalog().getDests()) != null && (destination = dests.getKey(destination.getDirectBase().getName())) == null) {
            return null;
        }
        if (destination.getType() == COSObjType.COS_DICT) {
            destination = destination.getKey(key);
        }
        COSObject obj = null;
        if (destination.getType() == COSObjType.COS_ARRAY && destination.size() > 0) {
            obj = destination.at(0);
        }
        return obj;
    }
}

