/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.chunks;

import java.util.LinkedList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.content.LineChunk;

public class Rectangle {
    private final Integer pageNumber;
    private final double x;
    private final double y;
    private final double width;
    private final double height;

    public Rectangle(Integer pageNumber, double x, double y, double width, double height) {
        this.pageNumber = pageNumber;
        this.x = width < 0.0 ? x + width : x;
        this.y = height < 0.0 ? y + height : y;
        this.width = Math.abs(width);
        this.height = Math.abs(height);
    }

    public List<LineChunk> getLines(double lineWidth) {
        LinkedList<LineChunk> lines = new LinkedList<LineChunk>();
        lines.add(new LineChunk(this.pageNumber, this.x, this.y, this.x + this.width, this.y, lineWidth));
        lines.add(new LineChunk(this.pageNumber, this.x, this.y, this.x, this.y + this.height, lineWidth));
        lines.add(new LineChunk(this.pageNumber, this.x + this.width, this.y, this.x + this.width, this.y + this.height, lineWidth));
        lines.add(new LineChunk(this.pageNumber, this.x, this.y + this.height, this.x + this.width, this.y + this.height, lineWidth));
        return lines;
    }

    public LineChunk getLine(double lineWidth) {
        if (this.width < this.height) {
            double lineX = this.x + 0.5 * this.width;
            return new LineChunk(this.pageNumber, lineX, this.y + 0.5 * this.width, lineX, this.y + this.height - 0.5 * this.width, this.width + lineWidth);
        }
        double lineY = this.y + 0.5 * this.height;
        return new LineChunk(this.pageNumber, this.x + 0.5 * this.height, lineY, this.x + this.width - 0.5 * this.height, lineY, this.height + lineWidth);
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public String toString() {
        return (this.x + " " + this.y + " " + this.width + " " + this.height).replace(".", ",");
    }
}

