/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.chunks;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.verapdf.gf.model.factory.chunks.TextChunksHelper;

public class TextPieces {
    private final SortedSet<TextPiece> textPieces = new TreeSet<TextPiece>(new TextPieceComparator());
    private double currentX = 0.0;

    public void add(TextPiece textPiece) {
        this.textPieces.add(textPiece);
        this.currentX = textPiece.endX;
    }

    public String getValue() {
        StringBuilder unicodeValue = new StringBuilder();
        for (TextPiece textPiece : this.textPieces) {
            unicodeValue.append(textPiece.value);
        }
        return unicodeValue.toString();
    }

    public double getStartX() {
        return this.textPieces.first().startX;
    }

    public double getEndX() {
        return this.textPieces.stream().map(TextPiece::getEndX).max(Double::compare).orElse(this.getStartX());
    }

    public double getCurrentX() {
        return this.currentX;
    }

    public void shiftCurrentX(double shift) {
        this.currentX += shift;
    }

    public boolean isEmpty() {
        return this.textPieces.isEmpty();
    }

    public void setCurrentX(double currentX) {
        this.currentX = currentX;
    }

    public List<Double> getSymbolEnds() {
        ArrayList<Double> ends = new ArrayList<Double>();
        for (TextPiece textPiece : this.textPieces) {
            TextChunksHelper.updateSymbolEnds(ends, textPiece.endX - textPiece.startX, textPiece.startX, textPiece.value != null ? textPiece.value.length() : 0);
        }
        return ends;
    }

    public static class TextPieceComparator
    implements Comparator<TextPiece> {
        @Override
        public int compare(TextPiece textPiece1, TextPiece textPiece2) {
            int res = Double.compare(textPiece1.startX, textPiece2.startX);
            if (res != 0) {
                return res;
            }
            return Double.compare(textPiece1.endX, textPiece2.endX);
        }
    }

    public static class TextPiece {
        private final String value;
        private final double startX;
        private final double endX;

        public TextPiece(String value, double startX, double endX) {
            this.value = value;
            this.startX = startX;
            this.endX = endX;
        }

        public double getEndX() {
            return this.endX;
        }
    }
}

