/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.serializer;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.gf.model.impl.sa.GFSAAnnotationNode;
import org.verapdf.gf.model.impl.sa.GFSAPDFDocument;
import org.verapdf.gf.model.impl.sa.GFSAStructElem;
import org.verapdf.gf.model.impl.serializer.AnnotationNodeSerializer;
import org.verapdf.gf.model.impl.serializer.DocumentSerializer;
import org.verapdf.gf.model.impl.serializer.ImageSerializer;
import org.verapdf.gf.model.impl.serializer.LineArtSerializer;
import org.verapdf.gf.model.impl.serializer.LineSerializer;
import org.verapdf.gf.model.impl.serializer.NodeSerializer;
import org.verapdf.gf.model.impl.serializer.PageSerializer;
import org.verapdf.gf.model.impl.serializer.TextSerializer;
import org.verapdf.wcag.algorithms.entities.IPage;
import org.verapdf.wcag.algorithms.entities.content.ImageChunk;
import org.verapdf.wcag.algorithms.entities.content.LineArtChunk;
import org.verapdf.wcag.algorithms.entities.content.LineChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;

public class GFSAPDFDocumentSerializer {
    private static final Logger LOGGER = Logger.getLogger(GFSAPDFDocumentSerializer.class.getCanonicalName());
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static void serialize(File file, GFSAPDFDocument document) {
        try {
            objectMapper.writeValue(file, (Object)document);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception during serializing GFSAPDFDocument: " + e.getMessage());
        }
    }

    static {
        SimpleModule module = new SimpleModule("NodeSerializer", new Version(2, 1, 3, null, null, null));
        DocumentSerializer documentSerializer = new DocumentSerializer(GFSAPDFDocument.class);
        module.addSerializer(GFSAPDFDocument.class, (JsonSerializer)documentSerializer);
        NodeSerializer nodeSerializer = new NodeSerializer(GFSAStructElem.class);
        module.addSerializer(GFSAStructElem.class, (JsonSerializer)nodeSerializer);
        PageSerializer pageSerializer = new PageSerializer(IPage.class);
        module.addSerializer(IPage.class, (JsonSerializer)pageSerializer);
        TextSerializer textSerializer = new TextSerializer(TextChunk.class);
        module.addSerializer(TextChunk.class, (JsonSerializer)textSerializer);
        ImageSerializer imageSerializer = new ImageSerializer(ImageChunk.class);
        module.addSerializer(ImageChunk.class, (JsonSerializer)imageSerializer);
        AnnotationNodeSerializer annotationSerializer = new AnnotationNodeSerializer(GFSAAnnotationNode.class);
        module.addSerializer(GFSAAnnotationNode.class, (JsonSerializer)annotationSerializer);
        LineArtSerializer lineArtSerializer = new LineArtSerializer(LineArtChunk.class);
        module.addSerializer(LineArtChunk.class, (JsonSerializer)lineArtSerializer);
        LineSerializer lineSerializer = new LineSerializer(LineChunk.class);
        module.addSerializer(LineChunk.class, (JsonSerializer)lineSerializer);
        objectMapper.registerModule((Module)module);
    }
}

