/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.chunks;

import java.util.List;
import org.verapdf.cos.COSBase;
import org.verapdf.gf.model.factory.chunks.Matrix;
import org.verapdf.pd.font.PDFont;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;

public class TextChunksHelper {
    protected static COSBase getArgument(List<COSBase> arguments, String operatorType) {
        if ("\"".equals(operatorType)) {
            if (arguments.size() > 2) {
                return arguments.get(2);
            }
        } else if (!arguments.isEmpty()) {
            return arguments.get(0);
        }
        return null;
    }

    protected static BoundingBox calculateTextBoundingBox(Matrix textRenderingMatrixBefore, Matrix textRenderingMatrixAfter, PDFont font, Integer pageNumber) {
        double y2;
        double y1;
        double x2;
        double x1;
        Double ascent;
        double[] fontBoundingBox = font.getBoundingBox();
        Double descent = font.getDescent();
        if (descent == null) {
            descent = fontBoundingBox[1];
        }
        if ((ascent = font.getAscent()) == null) {
            ascent = fontBoundingBox[3];
        }
        if (textRenderingMatrixBefore.getScaleX() >= 0.0 && textRenderingMatrixBefore.getShearX() >= 0.0) {
            x1 = textRenderingMatrixBefore.getTranslateX() + descent * textRenderingMatrixBefore.getShearX() / 1000.0;
            x2 = textRenderingMatrixAfter.getTranslateX() + ascent * textRenderingMatrixAfter.getShearX() / 1000.0;
        } else if (textRenderingMatrixBefore.getScaleX() < 0.0 && textRenderingMatrixBefore.getShearX() < 0.0) {
            x1 = textRenderingMatrixAfter.getTranslateX() + ascent * textRenderingMatrixAfter.getShearX() / 1000.0;
            x2 = textRenderingMatrixBefore.getTranslateX() + descent * textRenderingMatrixBefore.getShearX() / 1000.0;
        } else if (textRenderingMatrixBefore.getScaleX() >= 0.0) {
            x1 = textRenderingMatrixBefore.getTranslateX() + ascent * textRenderingMatrixBefore.getShearX() / 1000.0;
            x2 = textRenderingMatrixAfter.getTranslateX() + descent * textRenderingMatrixAfter.getShearX() / 1000.0;
        } else {
            x1 = textRenderingMatrixAfter.getTranslateX() + descent * textRenderingMatrixAfter.getShearX() / 1000.0;
            x2 = textRenderingMatrixBefore.getTranslateX() + ascent * textRenderingMatrixBefore.getShearX() / 1000.0;
        }
        if (textRenderingMatrixBefore.getScaleY() >= 0.0 && textRenderingMatrixBefore.getShearY() >= 0.0) {
            y1 = textRenderingMatrixBefore.getTranslateY() + descent * textRenderingMatrixBefore.getScaleY() / 1000.0;
            y2 = textRenderingMatrixAfter.getTranslateY() + ascent * textRenderingMatrixAfter.getScaleY() / 1000.0;
        } else if (textRenderingMatrixBefore.getScaleY() < 0.0 && textRenderingMatrixBefore.getShearY() < 0.0) {
            y1 = textRenderingMatrixAfter.getTranslateY() + ascent * textRenderingMatrixAfter.getScaleY() / 1000.0;
            y2 = textRenderingMatrixBefore.getTranslateY() + descent * textRenderingMatrixBefore.getScaleY() / 1000.0;
        } else if (textRenderingMatrixBefore.getScaleY() >= 0.0) {
            y1 = textRenderingMatrixAfter.getTranslateY() + descent * textRenderingMatrixAfter.getScaleY() / 1000.0;
            y2 = textRenderingMatrixBefore.getTranslateY() + ascent * textRenderingMatrixBefore.getScaleY() / 1000.0;
        } else {
            y1 = textRenderingMatrixBefore.getTranslateY() + ascent * textRenderingMatrixBefore.getScaleY() / 1000.0;
            y2 = textRenderingMatrixAfter.getTranslateY() + descent * textRenderingMatrixAfter.getScaleY() / 1000.0;
        }
        return new BoundingBox(pageNumber, x1, y1, x2, y2);
    }

    protected static double calculateTextBaseLine(Matrix textMatrix) {
        double rotationDegree = textMatrix.getRotationDegree();
        if (NodeUtils.areCloseNumbers((double)Math.abs(rotationDegree), (double)90.0)) {
            return textMatrix.getTranslateX();
        }
        return textMatrix.getTranslateY();
    }

    protected static double calculateTextSize(Matrix textMatrix) {
        return Math.sqrt(textMatrix.getScaleY() * textMatrix.getScaleY() + textMatrix.getShearX() * textMatrix.getShearX());
    }

    protected static double calculateFontWeight(int renderingMode, PDFont font) {
        return renderingMode == 2 ? TextChunksHelper.getBolderFontWeight(font.getFontWeight()) : font.getFontWeight();
    }

    protected static void updateSymbolEnds(List<Double> symbolEnds, double shift, double left, int length) {
        if (length <= 1) {
            symbolEnds.add(left + shift);
        } else {
            double newShift = shift / (double)length;
            for (int i = 1; i <= length; ++i) {
                symbolEnds.add(left + (double)i * newShift);
            }
        }
    }

    private static double getBolderFontWeight(Double fontWeight) {
        if (fontWeight < 400.0) {
            return 400.0;
        }
        if (fontWeight < 600.0) {
            return 700.0;
        }
        return 900.0;
    }
}

