/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessages;

public abstract class Message {
    public static final long NULL = -1L;
    protected final JhoveMessage message;
    protected final String _subMessage;
    protected final long _offset;

    protected Message(String message) {
        this(JhoveMessages.getMessageInstance("NO-ID", message));
    }

    protected Message(JhoveMessage message) {
        this(message, message.getSubMessage(), -1L);
    }

    protected Message(String message, String subMessage) {
        this(JhoveMessages.getMessageInstance("NO-ID", message), subMessage);
    }

    protected Message(JhoveMessage message, String subMessage) {
        this(message, subMessage, -1L);
    }

    protected Message(String message, long offset) {
        this(JhoveMessages.getMessageInstance("NO-ID", message), offset);
    }

    protected Message(JhoveMessage message, long offset) {
        this(message, message.getSubMessage(), offset);
    }

    protected Message(String message, String subMessage, long offset) {
        this(JhoveMessages.getMessageInstance("NO-ID", message), subMessage, offset);
    }

    protected Message(JhoveMessage message, String subMessage, long offset) {
        this.message = message;
        this._subMessage = subMessage.isEmpty() ? null : subMessage;
        this._offset = offset;
    }

    public String getMessage() {
        return this.message.getMessage();
    }

    public String getSubMessage() {
        return this._subMessage;
    }

    public long getOffset() {
        return this._offset;
    }

    public String getId() {
        return this.message.getId();
    }

    public JhoveMessage getJhoveMessage() {
        return this.message;
    }

    public String getPrefix() {
        return "";
    }
}

