/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.HandlerBase;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.viewer.JhoveWindow;
import edu.harvard.hul.ois.jhove.viewer.ViewWindow;

public class ViewHandler
extends HandlerBase {
    private static final String NAME = "VIEW";
    private static final String RELEASE = "1.0";
    private static final int[] DATE = new int[]{2004, 11, 2};
    private static final String NOTE = "This is the JHOVE Viewer output handler";
    private static final String RIGHTS = "Copyright 2004 by JSTOR and the President and Fellows of Harvard College. Released under the terms of the GNU Lesser General Public License.";
    private JhoveWindow _jhwin;
    private ViewWindow _viewWin;
    private String syncStr = "anyoldtext";
    private static int viewWinXPos = 24;
    private static int viewWinYPos = 24;
    private static final int viewWinOrigXPos = 24;
    private static final int viewWinOrigYPos = 24;
    private static final int viewWinXInc = 25;
    private static final int viewWinYInc = 22;
    private int nDocs;

    public ViewHandler(JhoveWindow jhwin, App app, JhoveBase base) {
        super(NAME, RELEASE, DATE, NOTE, RIGHTS);
        this._app = app;
        this._base = base;
        base.setCallback(jhwin);
        this._vendor = Agent.harvardInstance();
        this._jhwin = jhwin;
    }

    @Override
    public void showHeader() {
        this._viewWin = new ViewWindow(this._app, this._base, this._jhwin);
        this.nDocs = 0;
    }

    @Override
    public void show(RepInfo info) {
        this._viewWin.addRepInfo(info, this._base);
        ++this.nDocs;
    }

    @Override
    public void show() {
    }

    @Override
    public void show(App app) {
    }

    @Override
    public void show(Module module) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showFooter() {
        if (this.nDocs == 0) {
            this._viewWin.dispose();
        }
        String string = this.syncStr;
        synchronized (string) {
            this._viewWin.setLocation(viewWinXPos, viewWinYPos);
            viewWinYPos += 22;
            if ((viewWinXPos += 25) > 344) {
                viewWinXPos = 24;
            }
            if (viewWinYPos > 184) {
                viewWinYPos = 24;
            }
            this._viewWin.setVisible(true);
        }
        this._viewWin.expandRows();
        this._viewWin.setVisible(true);
    }

    @Override
    public void show(OutputHandler handler) {
    }
}

