/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

public final class RFC1766Lang {
    String _langCode;

    public RFC1766Lang(String str) {
        this._langCode = str;
    }

    public String getLangCode() {
        return this._langCode;
    }

    public boolean isSyntaxCorrect() {
        if (this._langCode == null) {
            return false;
        }
        char[] chrs = this._langCode.toLowerCase().toCharArray();
        char firstChar = '\u0000';
        int ntags = 0;
        int taglength = 0;
        for (int i = 0; i < chrs.length; ++i) {
            char ch = chrs[i];
            if (i == 0) {
                firstChar = ch;
            }
            if (!Character.isLetter(ch) && ch != '-') {
                return false;
            }
            if (ch == '-') {
                taglength = 0;
                if (ntags++ != 0 || taglength != 1) continue;
                if (firstChar != 'i' && firstChar != 'x') {
                    return false;
                }
                if (taglength == 2) continue;
                return false;
            }
            if (++taglength <= 8) continue;
            return false;
        }
        return taglength != 0;
    }
}

