/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.messages;

import edu.harvard.hul.ois.jhove.messages.JhoveMessage;

final class JhoveMessageImpl
implements JhoveMessage {
    private final String id;
    private final String message;
    private final String subMessage;

    private JhoveMessageImpl(String id, String message, String subMessage) {
        this.id = id;
        this.message = message;
        this.subMessage = subMessage;
    }

    static JhoveMessage getInstance(String id, String message, String subMessage) {
        return new JhoveMessageImpl(id, message, subMessage);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public boolean hasSubMessage() {
        return this.subMessage == null || this.subMessage.isEmpty();
    }

    @Override
    public String getSubMessage() {
        return this.subMessage;
    }

    public String toString() {
        return "JhoveMessageImpl [id=" + this.id + ", message=" + this.message + ", subMessage=" + this.subMessage + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.subMessage == null ? 0 : this.subMessage.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JhoveMessageImpl)) {
            return false;
        }
        JhoveMessageImpl other = (JhoveMessageImpl)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return !(this.subMessage == null ? other.subMessage != null : !this.subMessage.equals(other.subMessage));
    }
}

