/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.JpegModule;
import edu.harvard.hul.ois.jhove.module.jpeg.Spiff;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class SpiffDir {
    private JpegModule _module;
    private List _thumbnails;

    public SpiffDir(JpegModule module) {
        this._module = module;
        this._thumbnails = new LinkedList();
    }

    public void readDirEntry(DataInputStream dstream, int length) throws IOException {
        int tag = (int)this._module.readUnsignedInt(dstream);
        switch (tag) {
            case 4: {
                this.readThumbnail(dstream, length);
                break;
            }
            default: {
                this._module.skipBytes(dstream, length - 6, this._module);
            }
        }
    }

    public void appendThumbnailProps(List imageList) {
        imageList.addAll(this._thumbnails);
    }

    private void readThumbnail(DataInputStream dstream, int length) throws IOException {
        int comp;
        NisoImageMetadata niso = new NisoImageMetadata();
        this._module.skipBytes(dstream, 4L, this._module);
        this._module.readUnsignedShort(dstream);
        this._module.readUnsignedShort(dstream);
        int tns = ModuleBase.readUnsignedByte((DataInputStream)dstream, (ModuleBase)this._module);
        int tnbps = ModuleBase.readUnsignedByte((DataInputStream)dstream, (ModuleBase)this._module);
        int tnc = ModuleBase.readUnsignedByte((DataInputStream)dstream, (ModuleBase)this._module);
        this._module.skipBytes(dstream, length - 13, this._module);
        niso.setMimeType("image/jpeg");
        niso.setByteOrder("big-endian");
        niso.setBitsPerSample(new int[]{tnbps});
        int cs = Spiff.colorSpaceToNiso(tns);
        if (cs >= 0) {
            niso.setColorSpace(cs);
        }
        if ((comp = Spiff.compressionTypeToNiso(tnc)) >= 0) {
            niso.setCompressionScheme(comp);
        }
        Property nisoProp = new Property("NisoImageMetadata", PropertyType.NISOIMAGEMETADATA, (Object)niso);
        LinkedList<Property> propList = new LinkedList<Property>();
        propList.add(nisoProp);
        Property imageProp = new Property("ThumbImage", PropertyType.PROPERTY, PropertyArity.LIST, propList);
        this._thumbnails.add(imageProp);
    }
}

