/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RAFInputStream;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHeader;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Codestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.FileTypeBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MessageConstants;
import edu.harvard.hul.ois.jhove.module.jpeg2000.TopLevelBoxHolder;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Jpeg2000Module
extends ModuleBase {
    private static final String NAME = "JPEG2000-hul";
    private static final String RELEASE = "1.4.2";
    private static final int[] DATE = new int[]{2019, 10, 18};
    private static final String[] FORMAT = new String[]{"JPEG 2000", "JP2", "JPX"};
    private static final String COVERAGE = "JP2 (ISO/IEC 15444-1:2000/ITU-T Rec. T.800 (200)), JPX (ISO/IEC 15444-2:2004)";
    private static final String[] MIMETYPE = new String[]{"image/jp2", "image/jpx"};
    private static final String WELLFORMED = "The required Signature and File Type box structures are the first two boxes in the file; all boxes required by a given profile exist in the file; all box structures are well-formed (a four byte unsigned integer Box Length, followed by a four byte unsigned integer Box type, followed by a eight byte unsigned integer Box Length, followed by the Box Contents); no data exist before the first byte of the first box or after the last byte of the last box";
    private static final String VALIDITY = "The file is well-formed";
    private static final String REPINFO = "Properties capturing the technical attributes of the JPEG 2000 image from all boxes";
    private static final String NOTE = null;
    private static final String RIGHTS = "Copyright 2004-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";
    protected NisoImageMetadata _niso;
    protected NisoImageMetadata _defaultNiso;
    protected RandomAccessFile _raf;
    protected RAFInputStream _rafStream;
    protected List<Property> _propList;
    protected List<Codestream> codestreams;
    protected List<Property> binaryFilterProps;
    protected List<Property> associationProps;
    protected List<Property> digitalSigProps;
    protected int nCodestreams;
    protected int nCodestreamHeaders;
    protected List<Property> colorSpecs;
    protected List<Property> uuids;
    protected List<Property> composLayers;
    protected List<Property> uuidInfos;
    protected List<String> xmlList;
    protected boolean jp2HdrSeen;
    protected boolean rreqSeen;
    protected boolean colorSpecSeen;
    protected boolean imageHeaderSeen;
    protected boolean jp2Compliant;
    protected boolean jpxCompliant;
    protected Codestream curCodestream;
    protected boolean filterMode;
    private static final int[] sigByte = new int[]{0, 0, 0, 12, 106, 80, 32, 32, 13, 10, 135, 10};

    public Jpeg2000Module() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, true);
        this._vendor = Agent.harvardInstance();
        Document doc = new Document("Information technology -- JPEG 2000 image coding system -- Part 1: Code coding system", DocumentType.STANDARD);
        Agent isoAgent = Agent.newIsoInstance();
        doc.setAuthor(isoAgent);
        doc.setIdentifier(new Identifier("ISO/IEC 15444-1:2000", IdentifierType.ISO));
        doc.setDate("2002-07-31");
        this._specification.add(doc);
        doc = new Document("Information technology -- JPEG 2000 image coding system -- Part 2: Extensions", DocumentType.STANDARD);
        doc.setAuthor(isoAgent);
        doc.setIdentifier(new Identifier("ISO/IEC 15444-2:2004", IdentifierType.ISO));
        doc.setDate("2004-05-15");
        this._specification.add(doc);
        doc = new Document("MIME Type Registrations for JPEG 2000 (ISO/IEC 15444) RFC 3745", DocumentType.RFC);
        Agent ietfAgent = new Agent.Builder("IETF", AgentType.STANDARD).web("http://www.ietf.org").build();
        doc.setPublisher(ietfAgent);
        Agent agent = new Agent.Builder("D. Singer", AgentType.OTHER).build();
        doc.setAuthor(agent);
        agent = new Agent.Builder("R. Clark", AgentType.OTHER).build();
        doc.setAuthor(agent);
        agent = new Agent.Builder("D. Lee", AgentType.OTHER).build();
        doc.setAuthor(agent);
        doc.setDate("2004-04");
        Identifier ident = new Identifier("http://www.ietf.org/rfc/rfc3745.txt", IdentifierType.URL);
        doc.setIdentifier(ident);
        this._specification.add(doc);
        doc = new Document("ITU-T Rec. T.800 (2002), Information technology -- JPEG 2000 image coding system: Core coding system", DocumentType.STANDARD);
        Agent.Builder ituBuilder = new Agent.Builder("ITU", AgentType.STANDARD).address("ITU, Place des Nations, CH-1211 Geneva 20 Switzerland").telephone("+41 22 730 51 11").fax("+41 22 730 6500").email("itumail@itu.int").web("http://www.itu.int/home/");
        doc.setAuthor(ituBuilder.build());
        doc.setDate("2002-08");
        ident = new Identifier("ITU-T Rec. T.800 (2002)", IdentifierType.ITU);
        doc.setIdentifier(ident);
        this._specification.add(doc);
        InternalSignature sig = new InternalSignature(sigByte, SignatureType.MAGIC, SignatureUseType.MANDATORY, 0, "");
        this._signature.add(sig);
        sig = new ExternalSignature(".jp2", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(sig);
        sig = new ExternalSignature(".jpx", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(sig);
        sig = new ExternalSignature(".jpf", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(sig);
        sig = new ExternalSignature("jp2 ", SignatureType.FILETYPE, SignatureUseType.OPTIONAL);
        this._signature.add(sig);
        sig = new ExternalSignature("jpx ", SignatureType.FILETYPE, SignatureUseType.OPTIONAL);
        this._signature.add(sig);
        this._bigEndian = true;
    }

    public final void parse(RandomAccessFile raf, RepInfo info) throws IOException {
        this.initParse();
        this._rafStream = new RAFInputStream(raf, this._je != null ? this._je.getBufferSize() : 0);
        this._dstream = new DataInputStream((InputStream)this._rafStream);
        info.setFormat(this._format[0]);
        info.setMimeType(this._mimeType[0]);
        info.setModule((Module)this);
        this._propList = new ArrayList<Property>(12);
        Property metadata = new Property("JPEG2000Metadata", PropertyType.PROPERTY, PropertyArity.LIST, this._propList);
        this._raf = raf;
        int i = 0;
        boolean badhdr = false;
        try {
            for (i = 0; i < 12; ++i) {
                int ch = Jpeg2000Module.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
                if (ch == sigByte[i]) continue;
                badhdr = true;
                break;
            }
        }
        catch (IOException e) {
            badhdr = true;
        }
        if (badhdr) {
            info.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_35, (long)i));
            info.setWellFormed(false);
            return;
        }
        info.setSigMatch(this._name);
        if (!this.readFileTypeBox(info)) {
            return;
        }
        if (!this.readBoxes(info)) {
            return;
        }
        if (info.getWellFormed() == 0) {
            return;
        }
        info.setProperty(metadata);
        this.checksumIfRafNotCopied(info, raf);
        if (!this.rreqSeen || info.getValid() != 1) {
            this.jpxCompliant = false;
        }
        if (!this.imageHeaderSeen || !this.colorSpecSeen || info.getValid() != 1) {
            this.jp2Compliant = false;
        }
        if (this.jp2Compliant) {
            info.setProfile("JP2");
        }
        if (this.jpxCompliant) {
            info.setProfile("JPX");
            String mime = this._mimeType[1];
            info.setMimeType(mime);
            this.curCodestream.getNiso().setMimeType(mime);
            this._defaultNiso.setMimeType(mime);
        }
        NisoImageMetadata niso = this.getCurrentNiso();
        int rate = this.calculateRatio(this.getFilePos(), niso.getBitsPerSample(), niso.getImageLength(), niso.getImageWidth());
        if (rate != -1) {
            niso.setCompressionLevel(rate);
        }
        if (!this.colorSpecs.isEmpty()) {
            this._propList.add(new Property("ColorSpecs", PropertyType.PROPERTY, PropertyArity.LIST, this.colorSpecs));
        }
        if (!this.binaryFilterProps.isEmpty()) {
            this._propList.add(new Property("BinaryFilters", PropertyType.PROPERTY, PropertyArity.LIST, this.binaryFilterProps));
        }
        if (!this.associationProps.isEmpty()) {
            this._propList.add(new Property("Associations", PropertyType.PROPERTY, PropertyArity.LIST, this.associationProps));
        }
        if (!this.digitalSigProps.isEmpty()) {
            this._propList.add(new Property("DigitalSignatures", PropertyType.PROPERTY, PropertyArity.LIST, this.digitalSigProps));
        }
        if (!this.uuids.isEmpty()) {
            this._propList.add(new Property("UUIDs", PropertyType.PROPERTY, PropertyArity.LIST, this.uuids));
        }
        if (!this.composLayers.isEmpty()) {
            this._propList.add(new Property("CompositingLayers", PropertyType.PROPERTY, PropertyArity.LIST, this.composLayers));
        }
        if (!this.uuidInfos.isEmpty()) {
            this._propList.add(new Property("UUIDInfoBoxes", PropertyType.PROPERTY, PropertyArity.LIST, this.uuidInfos));
        }
        if (!this.codestreams.isEmpty()) {
            ArrayList<Property> csProps = new ArrayList<Property>(this.codestreams.size());
            ListIterator<Codestream> csIter = this.codestreams.listIterator();
            while (csIter.hasNext()) {
                Codestream cs = csIter.next();
                csProps.add(cs.makeProperty());
            }
            this._propList.add(new Property("Codestreams", PropertyType.PROPERTY, PropertyArity.LIST, csProps));
        }
        if (!this.xmlList.isEmpty()) {
            this._propList.add(new Property("XML", PropertyType.STRING, PropertyArity.LIST, this.xmlList));
        }
    }

    public int calculateRatio(long fileSize, int[] bitsPerSample, long length, long width) {
        double BITS_IN_BYTE = 8.0;
        long bits = 0L;
        for (int bit : bitsPerSample) {
            bits += (long)bit;
        }
        double bytes = (double)bits / 8.0;
        double uncompressedSize = (double)length * (double)width * bytes;
        if (fileSize <= 0L) {
            return -1;
        }
        double ratio = uncompressedSize / (double)fileSize;
        return (int)Math.round(ratio);
    }

    public long getFilePos() {
        try {
            return this._rafStream.getFilePos();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public void seek(long pos) throws IOException {
        this._rafStream.seek(pos);
    }

    public NisoImageMetadata getDefaultNiso() {
        return this._defaultNiso;
    }

    public NisoImageMetadata getCurrentNiso() {
        if (this.curCodestream == null) {
            return this._defaultNiso;
        }
        return this.curCodestream.getNiso();
    }

    public Codestream getCodestream(int n) {
        Codestream cs;
        if (n < this.codestreams.size()) {
            cs = this.codestreams.get(n);
        } else {
            cs = new Codestream();
            cs.setDefaultNiso(this._defaultNiso);
            this.codestreams.add(cs);
        }
        this.curCodestream = cs;
        return cs;
    }

    public int getNCodestreams() {
        return this.nCodestreams;
    }

    public int getNCodestreamHeaders() {
        return this.nCodestreamHeaders;
    }

    public boolean isJP2HdrSeen() {
        return this.jp2HdrSeen;
    }

    public void setNCodestreams(int n) {
        this.nCodestreams = n;
    }

    public void setNCodestreamHeaders(int n) {
        this.nCodestreamHeaders = n;
    }

    public void setJP2HdrSeen(boolean b) {
        this.jp2HdrSeen = b;
    }

    public void setRReqSeen(boolean b) {
        this.rreqSeen = b;
    }

    public void setColorSpecSeen(boolean b) {
        this.colorSpecSeen = b;
    }

    public void setImageHeaderSeen(boolean b) {
        this.imageHeaderSeen = b;
    }

    public void setJP2Compliant(boolean b) {
        this.jp2Compliant = b;
        if (this.jp2Compliant && this.jpxCompliant) {
            this._defaultNiso.setMimeType(MIMETYPE[1]);
        }
    }

    public void setJPXCompliant(boolean b) {
        this.jpxCompliant = b;
    }

    public void addProperty(Property p) {
        this._propList.add(p);
    }

    public void addColorSpec(Property p) {
        this.colorSpecs.add(p);
    }

    public void addBinaryFilterProp(Property p) {
        this.binaryFilterProps.add(p);
    }

    public void addAssociationProp(Property p) {
        this.associationProps.add(p);
    }

    public void addDigitalSignatureProp(Property p) {
        this.digitalSigProps.add(p);
    }

    public void addUUID(Property p) {
        this.uuids.add(p);
    }

    public void addUUIDInfo(Property p) {
        this.uuidInfos.add(p);
    }

    public void addComposLayer(Property p) {
        this.composLayers.add(p);
    }

    public void addXML(String s) {
        this.xmlList.add(s);
    }

    public String read4Chars(DataInputStream stream) throws IOException {
        StringBuffer sbuf = new StringBuffer(4);
        for (int i = 0; i < 4; ++i) {
            int ch = Jpeg2000Module.readUnsignedByte((DataInputStream)stream, (ModuleBase)this);
            sbuf.append((char)ch);
        }
        return sbuf.toString();
    }

    public int readUnsignedShort(DataInputStream stream) throws IOException {
        return Jpeg2000Module.readUnsignedShort((DataInputStream)stream, (boolean)true, (ModuleBase)this);
    }

    public long readUnsignedInt(DataInputStream stream) throws IOException {
        return Jpeg2000Module.readUnsignedInt((DataInputStream)stream, (boolean)true, (ModuleBase)this);
    }

    public long readSignedLong(DataInputStream stream) throws IOException {
        return Jpeg2000Module.readSignedLong((DataInputStream)stream, (boolean)true, (ModuleBase)this);
    }

    protected void initParse() {
        super.initParse();
        this.colorSpecs = new LinkedList<Property>();
        this.binaryFilterProps = new LinkedList<Property>();
        this.associationProps = new LinkedList<Property>();
        this.digitalSigProps = new LinkedList<Property>();
        this.uuids = new LinkedList<Property>();
        this.uuidInfos = new LinkedList<Property>();
        this.composLayers = new LinkedList<Property>();
        this.xmlList = new LinkedList<String>();
        this.codestreams = new LinkedList<Codestream>();
        this.curCodestream = null;
        this.nCodestreams = 0;
        this.nCodestreamHeaders = 0;
        this.jp2HdrSeen = false;
        this.rreqSeen = false;
        this.filterMode = false;
        this._defaultNiso = new NisoImageMetadata();
        this._defaultNiso.setByteOrder("big-endian");
        this._defaultNiso.setMimeType(MIMETYPE[0]);
        this.jp2Compliant = true;
        this.jpxCompliant = true;
    }

    protected boolean readBoxes(RepInfo info) throws IOException {
        JP2Box box;
        TopLevelBoxHolder bh = new TopLevelBoxHolder(this, this._raf, info, this._dstream);
        while (bh.hasNext() && (box = (JP2Box)bh.next()) != null) {
            if (box.readBox()) continue;
            return false;
        }
        return true;
    }

    protected boolean readFileTypeBox(RepInfo info) throws IOException {
        BoxHeader hdr = new BoxHeader(this, this._dstream);
        hdr.readHeader();
        if (!"ftyp".equals(hdr.getType())) {
            info.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_22, hdr.getType(), this._nByte));
            info.setWellFormed(false);
            return false;
        }
        FileTypeBox box = new FileTypeBox(this._raf);
        box.setBoxHeader(hdr);
        box.setDataInputStream(this._dstream);
        box.setRandomAccessFile(this._raf);
        box.setModule(this);
        box.setRepInfo(info);
        return box.readBox();
    }

    protected boolean skipOverBox(BoxHeader hdr, RepInfo info, DataInputStream dstrm) throws IOException {
        if (hdr.getLength() != 0L) {
            this.skipBytes(dstrm, (int)hdr.getDataLength(), this);
        }
        return true;
    }
}

