/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.Jpeg2000Module;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BinaryFilterBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHeader;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CrossRefBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MessageConstants;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;

public class BoxHolder
implements Iterator<Object> {
    protected Jpeg2000Module _module;
    protected JP2Box _parentBox;
    protected RandomAccessFile _raf;
    protected DataInputStream _dstrm;
    protected BoxHeader _boxHeader;
    protected RepInfo _repInfo;
    protected long bytesLeft;
    protected long filePos;
    protected boolean hasBoxes = false;
    private BinaryFilterBox binaryFilterBox;

    public BoxHolder(RandomAccessFile raf) {
        this._raf = raf;
        this.binaryFilterBox = null;
        try {
            this.filePos = raf.getFilePointer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected long getFilePos() {
        return this.filePos;
    }

    @Override
    public boolean hasNext() {
        return this.hasBoxes && this.bytesLeft >= 8L;
    }

    @Override
    public Object next() {
        if (!this.hasBoxes) {
            return null;
        }
        try {
            JP2Box nextBox;
            if (this.binaryFilterBox != null) {
                if (this.binaryFilterBox.hasNext()) {
                    nextBox = (JP2Box)this.binaryFilterBox.next();
                } else {
                    this.binaryFilterBox = null;
                }
            }
            if (this.bytesLeft < 8L) {
                return null;
            }
            BoxHeader subhdr = new BoxHeader(this._module, this._dstrm);
            subhdr.readHeader();
            this.bytesLeft -= subhdr.getLength();
            String hType = subhdr.getType();
            if ("bfil".equals(hType)) {
                this.binaryFilterBox = new BinaryFilterBox(this._raf, this instanceof JP2Box ? (JP2Box)this : null);
                if (this.binaryFilterBox.hasNext()) {
                    return this.binaryFilterBox.next();
                }
                subhdr.readHeader();
                hType = subhdr.getType();
            }
            if ("cref".equals(hType)) {
                CrossRefBox xrefBox = new CrossRefBox(this._raf, this instanceof JP2Box ? (JP2Box)this : null);
                if (!xrefBox.readBox()) {
                    return null;
                }
                BoxHeader xrefhdr = new BoxHeader(this._module, xrefBox.getCrossRefStream());
                xrefhdr.readHeader();
                nextBox = JP2Box.boxMaker(xrefhdr.getType(), this instanceof JP2Box ? (JP2Box)this : null);
                return nextBox;
            }
            nextBox = JP2Box.boxMaker(hType, this);
            nextBox.setModule(this._module);
            nextBox.setRepInfo(this._repInfo);
            nextBox.setRandomAccessFile(this._raf);
            nextBox.setDataInputStream(this._dstrm);
            nextBox.setBoxHeader(subhdr);
            return nextBox;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected void superboxOverrun() {
        this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_53, this.getSelfPropName(), this._module.getFilePos()));
        this._repInfo.setWellFormed(false);
    }

    protected void superboxUnderrun() {
        this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_54, this.getSelfPropName(), this._module.getFilePos()));
        this._repInfo.setWellFormed(false);
    }

    protected String getSelfPropName() {
        return "";
    }
}

