/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ChannelDefBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CodestreamRegBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ColorGroupBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.IPRBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.LabelBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MessageConstants;
import edu.harvard.hul.ois.jhove.module.jpeg2000.OpacityBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ResolutionBox;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ComposLayerHdrBox
extends JP2Box {
    private Property label;
    private Property opacityProp;
    private Property channelDefProp;
    private Property codestreamRegProp;
    private List<Property> colorSpecs;

    public ComposLayerHdrBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        if (this._parentBox != null) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        this.hasBoxes = true;
        this.colorSpecs = new LinkedList<Property>();
        JP2Box box = null;
        boolean hasOpacity = false;
        boolean hasChannelDef = false;
        while (this.hasNext() && (box = (JP2Box)this.next()) != null) {
            if (box instanceof ColorGroupBox || box instanceof OpacityBox || box instanceof ChannelDefBox || box instanceof CodestreamRegBox || box instanceof IPRBox || box instanceof ResolutionBox || box instanceof LabelBox) {
                if (!box.readBox()) {
                    return false;
                }
                if (box instanceof OpacityBox) {
                    hasOpacity = true;
                } else if (box instanceof ChannelDefBox) {
                    hasChannelDef = true;
                }
                if (!(box instanceof LabelBox)) continue;
                this.label = new Property("Label", PropertyType.STRING, (Object)((LabelBox)box).getLabel());
                continue;
            }
            box.skipBox();
        }
        if (hasOpacity && hasChannelDef) {
            this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_12, this._module.getFilePos()));
            this._repInfo.setValid(false);
        }
        this.finalizeBytesRead();
        ArrayList<Property> propList = new ArrayList<Property>(4);
        if (this.label != null) {
            propList.add(this.label);
        }
        if (!this.colorSpecs.isEmpty()) {
            propList.add(new Property("ColorSpecs", PropertyType.PROPERTY, PropertyArity.LIST, this.colorSpecs));
        }
        if (this.opacityProp != null) {
            propList.add(this.opacityProp);
        }
        if (this.channelDefProp != null) {
            propList.add(this.channelDefProp);
        }
        if (this.codestreamRegProp != null) {
            propList.add(this.codestreamRegProp);
        }
        this._module.addComposLayer(new Property("CompositeLayerHeader", PropertyType.PROPERTY, PropertyArity.LIST, propList));
        return true;
    }

    protected void addColorSpec(Property p) {
        this.colorSpecs.add(p);
    }

    protected void addOpacity(Property p) {
        this.opacityProp = p;
    }

    protected void addChannelDef(Property p) {
        this.channelDefProp = p;
    }

    protected void addCodestreamReg(Property p) {
        this.codestreamRegProp = p;
    }

    @Override
    protected String getSelfPropName() {
        return "Compositing Layer Header Box";
    }
}

