/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MessageConstants;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class FragmentListBox
extends JP2Box {
    private List<long[]> _fragmentList;

    public FragmentListBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        if (!this._module.isJP2HdrSeen()) {
            this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_34, this._module.getFilePos()));
            return false;
        }
        this.initBytesRead();
        int len = (int)this._boxHeader.getDataLength();
        int nFrags = this._module.readUnsignedShort(this._dstrm);
        if (this._boxHeader.getLength() != 0L && len != 14 * nFrags + 2) {
            this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_23, this._module.getFilePos()));
            this._repInfo.setWellFormed(false);
            return false;
        }
        this._fragmentList = new ArrayList<long[]>(nFrags);
        for (int i = 0; i < nFrags; ++i) {
            long offset = this._module.readSignedLong(this._dstrm);
            long fragLen = this._module.readUnsignedInt(this._dstrm);
            int dataRef = this._module.readUnsignedShort(this._dstrm);
            if (dataRef != 0) {
                this._fragmentList = null;
                this._repInfo.setMessage((Message)new InfoMessage("Document references an external file", this._module.getFilePos()));
                continue;
            }
            if (this._fragmentList == null) continue;
            long[] frag = new long[]{offset, fragLen};
            this._fragmentList.add(frag);
        }
        this.finalizeBytesRead();
        return true;
    }

    protected List getFragmentList() {
        return this._fragmentList;
    }

    @Override
    protected String getSelfPropName() {
        return "Fragment List Box";
    }
}

