/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MainOrTile;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MessageConstants;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class QCCMarkerSegment
extends MarkerSegment {
    @Override
    protected boolean process(int bytesToEat) throws IOException {
        int[] spqcc;
        int bytesEaten;
        int compIdx;
        int compIdxBytes = this.nCompBytes();
        if (compIdxBytes == 0) {
            this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_46));
            return false;
        }
        if (compIdxBytes < 257) {
            compIdx = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
            bytesEaten = 1;
        } else {
            compIdx = this._module.readUnsignedShort(this._dstream);
            bytesEaten = 2;
        }
        int sqcc = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
        ++bytesEaten;
        int sqccLow = sqcc & 0x1F;
        switch (sqccLow) {
            case 0: {
                int i;
                int nspqcc = bytesToEat - bytesEaten;
                spqcc = new int[nspqcc];
                for (i = 0; i < nspqcc; ++i) {
                    spqcc[i] = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
                }
                break;
            }
            case 1: 
            case 2: {
                int i;
                int nspqcc = (bytesToEat - bytesEaten) / 2;
                spqcc = new int[nspqcc];
                for (i = 0; i < nspqcc; ++i) {
                    spqcc[i] = this._module.readUnsignedShort(this._dstream);
                }
                break;
            }
            default: {
                this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_47));
                return false;
            }
        }
        MainOrTile cs = this.getMainOrTile();
        ArrayList<Property> propList = new ArrayList<Property>(2);
        propList.add(new Property("QuantizationStyle", PropertyType.INTEGER, (Object)new Integer(sqcc)));
        propList.add(new Property("StepValue", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)spqcc));
        cs.setCompProperty(compIdx, new Property("QuantizationComponent", PropertyType.PROPERTY, PropertyArity.LIST, propList));
        return true;
    }
}

