/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.AssociationBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Codestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CodestreamHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Strings;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MessageConstants;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class ROIBox
extends JP2Box {
    private Property roiProp;

    public ROIBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        this.initBytesRead();
        int nroi = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
        ArrayList<Property> propList = new ArrayList<Property>(nroi);
        for (int i = 0; i < nroi; ++i) {
            ArrayList<Property> roiPropList = new ArrayList<Property>(7);
            int incs = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
            if (incs > 1) {
                this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_51, this._module.getFilePos()));
                this._repInfo.setValid(false);
            }
            roiPropList.add(this._module.addIntegerProperty("InCodestream", incs, JP2Strings.inCodestreamStr));
            int rtyp = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
            if (rtyp > 1) {
                this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_52, this._module.getFilePos()));
                this._repInfo.setValid(false);
            }
            roiPropList.add(this._module.addIntegerProperty("RegionType", rtyp, JP2Strings.roiTypeStr));
            int rcp = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
            roiPropList.add(new Property("CodingPriority", PropertyType.INTEGER, (Object)new Integer(rcp)));
            long lcx = this._module.readUnsignedInt(this._dstrm);
            roiPropList.add(new Property("HorizontalLocation", PropertyType.LONG, (Object)new Long(lcx)));
            long lcy = this._module.readUnsignedInt(this._dstrm);
            roiPropList.add(new Property("HorizontalLocation", PropertyType.LONG, (Object)new Long(lcy)));
            long wdt = this._module.readUnsignedInt(this._dstrm);
            roiPropList.add(new Property("Width", PropertyType.LONG, (Object)new Long(wdt)));
            long hth = this._module.readUnsignedInt(this._dstrm);
            roiPropList.add(new Property("Height", PropertyType.LONG, (Object)new Long(hth)));
            propList.add(new Property("ROI", PropertyType.PROPERTY, PropertyArity.LIST, roiPropList));
        }
        this.roiProp = new Property("ROIs", PropertyType.PROPERTY, PropertyArity.LIST, propList);
        if (!(this._parentBox instanceof AssociationBox)) {
            if (this._parentBox instanceof CodestreamHeaderBox) {
                Codestream cs = ((CodestreamHeaderBox)this._parentBox).getCodestream();
                cs.setROIProperty(this.roiProp);
            } else {
                this._module.addProperty(this.roiProp);
            }
        }
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "ROI Description Box";
    }

    @Override
    protected Property getSelfPropDesc() {
        if (this.roiProp != null) {
            return new Property("Description", PropertyType.PROPERTY, (Object)this.roiProp);
        }
        return null;
    }
}

