/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MessageConstants;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ReaderRequirementsBox
extends JP2Box {
    public ReaderRequirementsBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        if (this._parentBox != null) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        int len = (int)this._boxHeader.getDataLength();
        int maskLength = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
        switch (maskLength) {
            case 1: {
                ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
                ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
                break;
            }
            case 2: {
                this._module.readUnsignedShort(this._dstrm);
                this._module.readUnsignedShort(this._dstrm);
                break;
            }
            case 4: {
                this._module.readUnsignedInt(this._dstrm);
                this._module.readUnsignedInt(this._dstrm);
                break;
            }
            case 8: {
                this._module.readSignedLong(this._dstrm);
                this._module.readSignedLong(this._dstrm);
                break;
            }
            default: {
                this._repInfo.setMessage((Message)new ErrorMessage(MessageConstants.JPEG2000_HUL_49, this._module.getFilePos()));
                this._repInfo.setWellFormed(false);
                return false;
            }
        }
        int nsf = this._module.readUnsignedShort(this._dstrm);
        for (int i = 0; i < nsf; ++i) {
            this._module.readUnsignedShort(this._dstrm);
        }
        this._module.skipBytes(this._dstrm, (int)((long)len - (this._module.getFilePos() - this.startBytesRead)), this._module);
        this.finalizeBytesRead();
        this._module.setRReqSeen(true);
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Reader Requirements Box";
    }
}

