/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.RFC1766Lang;
import edu.harvard.hul.ois.jhove.XMPHandler;
import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.DocNode;
import edu.harvard.hul.ois.jhove.module.pdf.PageObject;
import edu.harvard.hul.ois.jhove.module.pdf.PageTreeNode;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfIndirectObj;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfProfile;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import edu.harvard.hul.ois.jhove.module.pdf.PdfXMPSource;
import edu.harvard.hul.ois.jhove.module.pdf.TaggedProfile;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class AProfile
extends PdfProfile {
    private TaggedProfile _taggedProfile;
    private boolean _levelA;
    private boolean hasDevRGB;
    private boolean hasDevCMYK;
    private boolean hasUncalCS;
    private String[] annotTypes = new String[]{"Text", "Link", "FreeText", "Line", "Square", "Circle", "Polygon", "Polyline", "Highlight", "Underline", "Squiggly", "StrikeOut", "Stamp", "Caret", "Ink", "Popup", "Widget", "Screen", "PrinterMark", "TrapNet"};
    private String[] excludedActions = new String[]{"Launch", "Sound", "Movie", "ResetForm", "ImportData", "JavaScript", "set-state", "no-op"};
    private String[] excludedFilters = new String[]{"LZWDecode"};

    public AProfile(PdfModule module) {
        super(module);
        this._profileText = "ISO PDF/A-1, Level B";
    }

    public void setTaggedProfile(TaggedProfile tpr) {
        this._taggedProfile = tpr;
    }

    @Override
    public boolean satisfiesThisProfile() {
        this._levelA = true;
        if (!this._module.mayBePDFACompliant()) {
            this._levelA = false;
            return false;
        }
        if (this._taggedProfile != null && !this._taggedProfile.isAlreadyOK()) {
            this._levelA = false;
        }
        this.hasDevCMYK = false;
        this.hasDevRGB = false;
        this.hasUncalCS = false;
        try {
            if (!(this._module.getEncryptionDict() == null && this.trailerDictOK() && this.catalogOK() && this.resourcesOK() && this.fontsOK() && this.outlinesOK())) {
                this._levelA = false;
                return false;
            }
        }
        catch (Exception e) {
            this._levelA = false;
            return false;
        }
        return true;
    }

    protected boolean satisfiesLevelA() {
        return this._levelA;
    }

    private boolean trailerDictOK() {
        PdfDictionary trailerDict = this._module.getTrailerDict();
        if (trailerDict == null) {
            return false;
        }
        try {
            if (trailerDict.get("Encrypt") != null) {
                return false;
            }
            if (trailerDict.get("ID") == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean catalogOK() {
        PdfDictionary cat = this._module.getCatalogDict();
        if (cat == null) {
            return false;
        }
        try {
            RFC1766Lang l;
            PdfSimpleObject lang = (PdfSimpleObject)cat.get("Lang");
            if (lang != null && !(l = new RFC1766Lang(lang.getStringValue())).isSyntaxCorrect()) {
                return false;
            }
            PdfStream metadata = (PdfStream)this._module.resolveIndirectObject(cat.get("Metadata"));
            if (!this.metadataOK(metadata)) {
                return false;
            }
            PdfDictionary form = (PdfDictionary)this._module.resolveIndirectObject(cat.get("AcroForm"));
            if (form != null && !this.formOK(form)) {
                return false;
            }
            if (cat.get("AA") != null || cat.get("OCProperties") != null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean fontsOK() {
        if (!this.type0FontsOK()) {
            return false;
        }
        List<Map<Integer, PdfObject>> lst = this._module.getFontMaps();
        ListIterator<Map<Integer, PdfObject>> iter = lst.listIterator();
        try {
            while (iter.hasNext()) {
                Map fmap = (Map)iter.next();
                for (PdfDictionary font : fmap.values()) {
                    if (this.fontOK(font)) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean fontOK(PdfDictionary font) {
        try {
            PdfObject toUni;
            PdfObject enc;
            PdfObject order;
            PdfSimpleObject fType = (PdfSimpleObject)font.get("Subtype");
            String fTypeStr = fType.getStringValue();
            PdfDictionary desc = (PdfDictionary)this._module.resolveIndirectObject(font.get("FontDescriptor"));
            PdfSimpleObject flagsObj = null;
            if (desc != null) {
                flagsObj = (PdfSimpleObject)this._module.resolveIndirectObject(desc.get("Flags"));
            }
            int flags = 0;
            if (flagsObj != null) {
                flags = flagsObj.getIntValue();
            }
            if ("Type1".equals(fTypeStr)) {
                if (desc == null) {
                    return false;
                }
                return desc.get("CharSet") != null;
            }
            if ("Type0".equals(fTypeStr) && (order = font.get("Ordering")) instanceof PdfSimpleObject) {
                try {
                    String ordText = ((PdfSimpleObject)order).getStringValue();
                    if ("Adobe-GB1".equals(ordText) || "Adobe-CNS1".equals(ordText) || "Adobe-Japan1".equals(ordText) || "Adobe-Korea1".equals(ordText)) {
                        return true;
                    }
                }
                catch (Exception ordText) {
                    // empty catch block
                }
            }
            if ((enc = font.get("Encoding")) instanceof PdfSimpleObject) {
                if ((flags & 4) != 0) {
                    return false;
                }
                String encName = ((PdfSimpleObject)enc).getStringValue();
                if ("WinAnsiEncoding".equals(encName) || "MacRomanDecoding".equals(encName) || "MacExpertDecoding".equals(encName)) {
                    return true;
                }
            }
            if ((toUni = font.get("ToUnicode")) == null) {
                this._levelA = false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean type0FontsOK() {
        Map<Integer, PdfObject> type0Map = this._module.getFontMap(1);
        if (type0Map == null) {
            return true;
        }
        try {
            Iterator<PdfObject> iter = type0Map.values().iterator();
            while (iter.hasNext()) {
                PdfArray descendants;
                Vector<PdfObject> subfonts;
                PdfObject objFont;
                PdfDictionary subfont;
                PdfSimpleObject subtype;
                PdfSimpleObject ob;
                String registry = null;
                String ordering = null;
                PdfDictionary font = (PdfDictionary)iter.next();
                PdfObject enc = font.get("Encoding");
                if (enc instanceof PdfDictionary) {
                    PdfDictionary info = (PdfDictionary)this._module.resolveIndirectObject(((PdfDictionary)enc).get("CIDSystemInfo"));
                    ob = (PdfSimpleObject)info.get("Registry");
                    registry = ob.getStringValue();
                    ob = (PdfSimpleObject)info.get("Ordering");
                    ordering = ob.getStringValue();
                }
                if (!(subtype = (PdfSimpleObject)(subfont = (PdfDictionary)this._module.resolveIndirectObject(objFont = (subfonts = (descendants = (PdfArray)this._module.resolveIndirectObject(font.get("DescendantFonts"))).getContent()).elementAt(0))).get("Subtype")).getStringValue().equals("CIDFontType0") && !subtype.getStringValue().equals("CIDFontType2")) {
                    return false;
                }
                PdfDictionary info = (PdfDictionary)this._module.resolveIndirectObject(subfont.get("CIDSystemInfo"));
                ob = (PdfSimpleObject)info.get("Registry");
                String obstr = ob.getStringValue();
                if (registry == null) {
                    registry = obstr;
                } else if (!registry.equals(obstr)) {
                    return false;
                }
                ob = (PdfSimpleObject)info.get("Ordering");
                obstr = ob.getStringValue();
                if (ordering == null) {
                    ordering = obstr;
                } else if (!ordering.equals(obstr)) {
                    return false;
                }
                if (!"CIDFontType2".equals(subtype.getStringValue())) continue;
                PdfObject cgmap1 = subfont.get("CIDToGIDMap");
                if (cgmap1 == null) {
                    return false;
                }
                PdfObject cgmap = cgmap1 instanceof PdfIndirectObj ? this._module.resolveIndirectObject(cgmap1) : cgmap1;
                if (!(cgmap instanceof PdfSimpleObject ? !"Identity".equals(((PdfSimpleObject)cgmap).getStringValue()) : !(cgmap instanceof PdfStream))) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean ttFontEncodingOK(PdfDictionary font) {
        try {
            PdfSimpleObject encoding;
            String encStr;
            PdfDictionary desc = (PdfDictionary)this._module.resolveIndirectObject(font.get("FontDescriptor"));
            if (desc == null) {
                return true;
            }
            PdfSimpleObject flagObj = (PdfSimpleObject)desc.get("Flags");
            int flags = flagObj.getIntValue();
            if ((flags & 4) == 0 && !"MacRomanEncoding".equals(encStr = (encoding = (PdfSimpleObject)font.get("Encoding")).getStringValue()) && !"WinAnsiEncoding".equals(encStr)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean formOK(PdfDictionary form) {
        try {
            PdfArray fields = (PdfArray)this._module.resolveIndirectObject(form.get("Fields"));
            Vector<PdfObject> fieldVec = fields.getContent();
            for (int i = 0; i < fieldVec.size(); ++i) {
                PdfDictionary field = (PdfDictionary)fieldVec.elementAt(i);
                if (this.fieldOK(field)) continue;
                return false;
            }
            PdfSimpleObject needapp = (PdfSimpleObject)form.get("NeedAppearances");
            if (needapp != null && !needapp.isFalse()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean fieldOK(PdfDictionary field) {
        try {
            if (field.get("AA") != null) {
                return false;
            }
            if (field.get("A") != null) {
                return false;
            }
            if (field.get("DR") == null) {
                return false;
            }
            PdfArray kids = (PdfArray)field.get("Kids");
            if (kids != null) {
                Vector<PdfObject> kidVec = kids.getContent();
                for (int i = 0; i < kidVec.size(); ++i) {
                    PdfDictionary kid = (PdfDictionary)kidVec.elementAt(i);
                    if (kid.get("Parent") == null || this.fieldOK(kid)) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean resourcesOK() {
        PageTreeNode docTreeRoot = this._module.getDocumentTree();
        try {
            DocNode docNode;
            docTreeRoot.startWalk();
            while ((docNode = docTreeRoot.nextDocNode()) != null) {
                PdfArray annots;
                PdfDictionary rsrc = docNode.getResources();
                if (rsrc != null) {
                    PdfDictionary cs = (PdfDictionary)this._module.resolveIndirectObject(rsrc.get("ColorSpace"));
                    if (!this.colorSpaceOK(cs)) {
                        return false;
                    }
                    PdfDictionary gs = (PdfDictionary)this._module.resolveIndirectObject(rsrc.get("ExtGState"));
                    if (!this.extGStateOK(gs)) {
                        return false;
                    }
                    PdfDictionary xo = (PdfDictionary)this._module.resolveIndirectObject(rsrc.get("XObject"));
                    if (!this.xObjectsOK(xo)) {
                        return false;
                    }
                }
                if (!(docNode instanceof PageObject)) continue;
                List<PdfStream> streams = ((PageObject)docNode).getContentStreams();
                if (streams != null) {
                    ListIterator<PdfStream> iter = streams.listIterator();
                    while (iter.hasNext()) {
                        PdfObject filters;
                        PdfStream stream = (PdfStream)iter.next();
                        PdfDictionary dict = stream.getDict();
                        PdfDictionary rs = (PdfDictionary)this._module.resolveIndirectObject(dict.get("Resources"));
                        if (rs != null) {
                            PdfDictionary cs = (PdfDictionary)this._module.resolveIndirectObject(rs.get("ColorSpace"));
                            if (!this.colorSpaceOK(cs)) {
                                return false;
                            }
                            PdfDictionary gs = (PdfDictionary)this._module.resolveIndirectObject(rs.get("ExtGState"));
                            if (!this.extGStateOK(gs)) {
                                return false;
                            }
                            PdfDictionary xo = (PdfDictionary)this._module.resolveIndirectObject(rs.get("XObject"));
                            if (!this.xObjectsOK(xo)) {
                                return false;
                            }
                        }
                        if (!this.hasFilters(filters = dict.get("Filter"), this.excludedFilters)) continue;
                        return false;
                    }
                }
                if ((annots = ((PageObject)docNode).getAnnotations()) == null) continue;
                Vector<PdfObject> annVec = annots.getContent();
                for (int i = 0; i < annVec.size(); ++i) {
                    double caVal;
                    PdfDictionary annDict = (PdfDictionary)this._module.resolveIndirectObject(annVec.elementAt(i));
                    PdfSimpleObject subtypeObj = (PdfSimpleObject)annDict.get("Subtype");
                    String subtypeVal = subtypeObj.getStringValue();
                    boolean stOK = false;
                    for (int j = 0; j < this.annotTypes.length; ++j) {
                        if (!this.annotTypes[j].equals(subtypeVal)) continue;
                        stOK = true;
                        break;
                    }
                    if (!stOK) {
                        return false;
                    }
                    if ("Widget".equals(subtypeVal) && annDict.get("AA") != null) {
                        return false;
                    }
                    PdfSimpleObject ca = (PdfSimpleObject)annDict.get("CA");
                    if (ca == null || (caVal = ca.getDoubleValue()) == 1.0) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean colorSpaceOK(PdfDictionary cs) {
        if (cs == null) {
            return true;
        }
        Iterator<PdfObject> iter = cs.iterator();
        while (iter.hasNext()) {
            PdfObject res = iter.next();
            if (!(res instanceof PdfArray)) continue;
            Vector<PdfObject> resv = ((PdfArray)res).getContent();
            PdfSimpleObject snameobj = (PdfSimpleObject)resv.elementAt(0);
            String sname = snameobj.getStringValue();
            boolean oldHasUncalCS = this.hasUncalCS;
            if ("DeviceCMYK".equals(sname)) {
                this.hasDevCMYK = true;
                this.hasUncalCS = true;
            } else if ("DeviceRGB".equals(sname)) {
                this.hasDevRGB = true;
                this.hasUncalCS = true;
            } else if ("DeviceGray".equals(sname)) {
                this.hasUncalCS = true;
            }
            if (this.hasUncalCS && !oldHasUncalCS && !this.checkUncalIntent()) {
                return false;
            }
            if (!this.hasDevRGB || !this.hasDevCMYK) continue;
            return false;
        }
        return true;
    }

    private boolean checkUncalIntent() {
        try {
            PdfDictionary catDict = this._module.getCatalogDict();
            PdfArray intentsArray = (PdfArray)this._module.resolveIndirectObject(catDict.get("OutputIntents"));
            if (intentsArray == null) {
                return false;
            }
            Vector<PdfObject> intVec = intentsArray.getContent();
            PdfStream theOutProfile = null;
            boolean pdfaProfileSeen = false;
            for (int i = 0; i < intVec.size(); ++i) {
                PdfSimpleObject subtype;
                PdfStream outProfile;
                PdfDictionary intent = (PdfDictionary)intVec.elementAt(0);
                PdfSimpleObject outCond = (PdfSimpleObject)intent.get("OutputCondition");
                if (outCond == null || (outProfile = (PdfStream)this._module.resolveIndirectObject(intent.get("DestOutputProfile"))) == null) continue;
                if (theOutProfile != null) {
                    if (outProfile != theOutProfile) {
                        return false;
                    }
                } else {
                    theOutProfile = outProfile;
                }
                if ((subtype = (PdfSimpleObject)intent.get("S")) == null || !"GTS_PDFA1".equals(subtype.getStringValue())) continue;
                pdfaProfileSeen = true;
            }
            if (theOutProfile == null || !pdfaProfileSeen) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean outlinesOK() {
        if (!this._module.getActionsExist()) {
            return true;
        }
        PdfDictionary outlineDict = this._module.getOutlineDict();
        if (outlineDict == null) {
            return true;
        }
        try {
            PdfDictionary item = (PdfDictionary)this._module.resolveIndirectObject(outlineDict.get("First"));
            while (item != null) {
                if (!this.checkOutlineItem(item)) {
                    return false;
                }
                item = (PdfDictionary)this._module.resolveIndirectObject(item.get("Next"));
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean checkOutlineItem(PdfDictionary item) {
        try {
            PdfDictionary action = (PdfDictionary)this._module.resolveIndirectObject(item.get("A"));
            if (action != null && !this.actionOK(action)) {
                return false;
            }
            PdfDictionary child = (PdfDictionary)this._module.resolveIndirectObject(item.get("First"));
            while (child != null) {
                if (!this.checkOutlineItem(child)) {
                    return false;
                }
                PdfDictionary next = (PdfDictionary)this._module.resolveIndirectObject(child.get("Next"));
                if (next.getObjNumber() != child.getObjNumber()) {
                    child = next;
                    continue;
                }
                child = null;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean actionOK(PdfDictionary action) {
        try {
            int i;
            PdfSimpleObject actType = (PdfSimpleObject)action.get("S");
            String actStr = actType.getStringValue();
            for (i = 0; i < this.excludedActions.length; ++i) {
                if (!this.excludedActions[i].equals(actStr)) continue;
                return false;
            }
            PdfObject next = action.get("Next");
            if (next instanceof PdfDictionary) {
                if (!this.actionOK((PdfDictionary)next)) {
                    return false;
                }
            } else if (next instanceof PdfArray) {
                Vector<PdfObject> nextVec = ((PdfArray)next).getContent();
                for (i = 0; i < nextVec.size(); ++i) {
                    PdfDictionary nact = (PdfDictionary)nextVec.elementAt(i);
                    if (this.actionOK(nact)) continue;
                    return false;
                }
            } else if (next != null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean extGStateOK(PdfDictionary gs) {
        if (gs == null) {
            return true;
        }
        try {
            double caVal;
            String bmVal;
            String smVal;
            String riVal;
            String tr2Val;
            PdfObject tr = gs.get("TR");
            PdfObject tr2 = gs.get("TR2");
            if (tr != null) {
                return false;
            }
            if (tr2 != null && !"Default".equals(tr2Val = ((PdfSimpleObject)tr2).getStringValue())) {
                return false;
            }
            PdfSimpleObject ri = (PdfSimpleObject)gs.get("RI");
            if (ri != null && !this.validIntentString(riVal = ri.getStringValue())) {
                return false;
            }
            PdfSimpleObject smask = (PdfSimpleObject)gs.get("SMask");
            if (smask != null && !"None".equals(smVal = smask.getStringValue())) {
                return false;
            }
            PdfSimpleObject blendMode = (PdfSimpleObject)gs.get("BM");
            if (blendMode != null && !"Normal".equals(bmVal = blendMode.getStringValue()) && !"Compatible".equals(bmVal)) {
                return false;
            }
            PdfSimpleObject ca = (PdfSimpleObject)gs.get("CA");
            if (ca != null && (caVal = ca.getDoubleValue()) != 1.0) {
                return false;
            }
            ca = (PdfSimpleObject)gs.get("ca");
            if (ca != null && (caVal = ca.getDoubleValue()) != 1.0) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean xObjectOK(PdfDictionary xo) {
        if (xo == null) {
            return true;
        }
        try {
            PdfSimpleObject subtype = (PdfSimpleObject)xo.get("Subtype");
            if (subtype != null) {
                String subtypeVal = subtype.getStringValue();
                if ("PS".equals(subtypeVal)) {
                    return false;
                }
                if ("Image".equals(subtypeVal) && !this.imageObjectOK(xo)) {
                    return false;
                }
                if ("Form".equals(subtypeVal) && !this.formObjectOK(xo)) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected boolean formObjectOK(PdfDictionary xo) {
        return xo.get("OPI") == null && xo.get("Ref") == null;
    }

    protected boolean imageObjectOK(PdfDictionary xo) {
        try {
            String intentStr;
            if (xo.get("OPI") != null || xo.get("Alternates") != null) {
                return false;
            }
            PdfObject filters = xo.get("Filter");
            if (this.hasFilters(filters, this.excludedFilters)) {
                return false;
            }
            PdfSimpleObject interp = (PdfSimpleObject)xo.get("Interpolate");
            if (interp != null && !interp.isFalse()) {
                return false;
            }
            PdfSimpleObject intent = (PdfSimpleObject)xo.get("Intent");
            if (intent != null && !this.validIntentString(intentStr = intent.getStringValue())) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean validIntentString(String str) {
        return "RelativeColorimetric".equals(str) || "AbsoluteColorimetric".equals(str) || "Perceptual".equals(str) || "Saturation".equals(str);
    }

    private boolean metadataOK(PdfStream metadata) {
        if (metadata == null) {
            return false;
        }
        try {
            PdfDictionary metaDict = metadata.getDict();
            if (metaDict.get("Filter") != null) {
                return false;
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XMLReader parser = factory.newSAXParser().getXMLReader();
            PdfXMPSource src = new PdfXMPSource(metadata, this._module.getFile());
            XMPHandler handler = new XMPHandler();
            parser.setContentHandler((ContentHandler)handler);
            parser.setErrorHandler((ErrorHandler)handler);
            try {
                parser.parse((InputSource)((Object)src));
                if (!handler.isPdfaCompliant()) {
                    return false;
                }
            }
            catch (SAXException se) {
                String msg = se.getMessage();
                if (msg != null && msg.startsWith("ENC=")) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

