/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessages;
import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.MessageConstants;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import java.io.IOException;

public final class Destination {
    private boolean _indirect;
    private PdfSimpleObject _indirectDest;
    private PdfDictionary _pageDest;

    public Destination(PdfObject destObj, PdfModule module, boolean named) throws PdfException {
        block7: {
            this._indirect = false;
            if (destObj == null) {
                throw new IllegalArgumentException("Parameter destObj cannot be null.");
            }
            if (!named && destObj instanceof PdfSimpleObject) {
                this._indirect = true;
                this._indirectDest = (PdfSimpleObject)destObj;
                return;
            }
            PdfArray destArray = null;
            try {
                if (destObj instanceof PdfArray) {
                    destArray = (PdfArray)destObj;
                    this._pageDest = Destination.findDirectDest(module, destArray);
                    break block7;
                }
                if (named && destObj instanceof PdfDictionary) {
                    destArray = (PdfArray)((PdfDictionary)destObj).get("D");
                    this._pageDest = Destination.findDirectDest(module, destArray);
                    break block7;
                }
                throw new PdfInvalidException(MessageConstants.PDF_HUL_1);
            }
            catch (ClassCastException e) {
                throw new PdfInvalidException(MessageConstants.PDF_HUL_2);
            }
            catch (IOException e) {
                JhoveMessage message = JhoveMessages.getMessageInstance((String)MessageConstants.PDF_HUL_3.getId(), (String)String.format(MessageConstants.PDF_HUL_3.getMessage(), e.getLocalizedMessage(), destArray._objNumber));
                throw new PdfInvalidException(message);
            }
        }
    }

    public boolean isIndirect() {
        return this._indirect;
    }

    public PdfSimpleObject getIndirectDest() {
        return this._indirectDest;
    }

    public PdfDictionary getPageDest() {
        return this._pageDest;
    }

    public int getPageDestObjNumber() throws NullPointerException {
        return this._pageDest.getObjNumber();
    }

    private static PdfDictionary findDirectDest(PdfModule module, PdfArray destObj) throws PdfException, IOException {
        return (PdfDictionary)module.resolveIndirectObject(destObj.getContent().elementAt(0));
    }
}

