/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.MessageConstants;
import edu.harvard.hul.ois.jhove.module.pdf.PageObject;
import edu.harvard.hul.ois.jhove.module.pdf.PageTreeNode;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import java.io.IOException;

public abstract class DocNode {
    protected PdfModule _module;
    protected PageTreeNode _parent;
    protected PdfDictionary _dict;
    protected boolean _pageObjectFlag;
    protected boolean _walkFinished;

    public DocNode(PdfModule module, PageTreeNode parent, PdfDictionary dict) throws PdfMalformedException {
        if (dict == null) {
            throw new PdfMalformedException(MessageConstants.PDF_HUL_4);
        }
        this._module = module;
        this._parent = parent;
        this._dict = dict;
    }

    public boolean isPageObject() {
        return this._pageObjectFlag;
    }

    public abstract void startWalk();

    public abstract PageObject nextPageObject() throws PdfMalformedException;

    public abstract DocNode nextDocNode() throws PdfMalformedException;

    public DocNode getParent() {
        return this._parent;
    }

    public PdfDictionary getDict() {
        return this._dict;
    }

    public PdfDictionary getResources() throws PdfException {
        PdfObject resdict = this._dict.get("Resources");
        try {
            resdict = this._module.resolveIndirectObject(resdict);
            return (PdfDictionary)resdict;
        }
        catch (IOException | ClassCastException f) {
            throw new PdfInvalidException(MessageConstants.PDF_HUL_5);
        }
    }

    public PdfDictionary getFontResources() throws PdfException {
        PdfDictionary resdict = this.getResources();
        if (resdict == null) {
            return null;
        }
        PdfObject fontdict = resdict.get("Font");
        try {
            fontdict = this._module.resolveIndirectObject(fontdict);
            return (PdfDictionary)fontdict;
        }
        catch (IOException | ClassCastException e) {
            throw new PdfMalformedException(MessageConstants.PDF_HUL_6);
        }
    }

    public PdfArray getMediaBox() throws PdfInvalidException {
        PdfArray mbox = null;
        try {
            mbox = (PdfArray)this.get("MediaBox", true);
        }
        catch (ClassCastException e) {
            throw new PdfInvalidException(MessageConstants.PDF_HUL_7);
        }
        if (mbox != null && mbox.toRectangle() == null) {
            throw new PdfInvalidException(MessageConstants.PDF_HUL_8);
        }
        return mbox;
    }

    public PdfObject get(String key, boolean inheritable) {
        PdfObject val = this._dict.get(key);
        if (val == null) {
            if (this._parent == null || !inheritable) {
                return null;
            }
            return this._parent.get(key, inheritable);
        }
        return val;
    }
}

