/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.MessageConstants;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;

public enum FileSpecification {
    INSTANCE;

    private static final String[] dictKeys;

    public static String getFileSpecString(PdfObject obj) throws PdfInvalidException {
        if (obj instanceof PdfSimpleObject) {
            return ((PdfSimpleObject)obj).getStringValue();
        }
        try {
            if (obj instanceof PdfDictionary) {
                PdfDictionary dictObj = (PdfDictionary)obj;
                for (String dictKey : dictKeys) {
                    PdfSimpleObject pathObj = (PdfSimpleObject)dictObj.get(dictKey);
                    if (pathObj == null) continue;
                    return pathObj.getStringValue();
                }
            }
        }
        catch (ClassCastException e) {
            throw new PdfInvalidException(MessageConstants.PDF_HUL_9);
        }
        return null;
    }

    static {
        dictKeys = new String[]{"F", "Unix", "DOS", "Mac"};
    }
}

