/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.Stream;
import edu.harvard.hul.ois.jhove.module.pdf.Tokenizer;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileTokenizer
extends Tokenizer {
    private long _fileBufferPositionOffset;
    private byte[] _fileBuffer;
    private static final int FILEBUFSIZE = 65536;
    private int _fileBufferBytes;
    private int _fileBufferOffset;

    public FileTokenizer(RandomAccessFile file) {
        this._file = file;
        this._fileBufferPositionOffset = -1L;
        this._fileBuffer = new byte[65536];
        this.initFileBuffer();
    }

    private void initFileBuffer() {
        this._fileBufferBytes = 0;
        this._fileBufferOffset = 0;
    }

    public long getFilePos() {
        return this._fileBufferPositionOffset + (long)this._fileBufferOffset;
    }

    @Override
    public int readChar() throws IOException {
        if (this._fileBufferOffset >= this._fileBufferBytes) {
            if (this._fileBufferBytes > 0) {
                long newOffset = this._fileBufferPositionOffset + (long)this._fileBufferOffset;
                this._file.seek(newOffset);
                this._fileBufferPositionOffset = newOffset;
            }
            this._fileBufferBytes = this._file.read(this._fileBuffer);
            if (this._fileBufferBytes <= 0) {
                throw new EOFException();
            }
            this._fileBufferOffset = 0;
        }
        return this._fileBuffer[this._fileBufferOffset++] & 0xFF;
    }

    @Override
    public void seek(long offset) throws IOException {
        if (this._fileBufferPositionOffset >= 0L && offset >= this._fileBufferPositionOffset && offset < this._fileBufferPositionOffset + (long)this._fileBufferBytes) {
            this._fileBufferOffset = (int)(offset - this._fileBufferPositionOffset);
        } else {
            this._file.seek(offset);
            this.initFileBuffer();
            this._fileBufferPositionOffset = offset;
        }
        this.seekReset(offset);
    }

    @Override
    public void backupChar() {
        --this._fileBufferOffset;
    }

    @Override
    protected void initStream(Stream token) {
        token.setOffset(this.getFilePos());
    }

    @Override
    protected void setStreamOffset(Stream token) {
        if (token.getOffset() < 0L) {
            token.setOffset(this.getFilePos());
        }
    }
}

