/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.messages.JhoveMessages;
import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.Keyword;
import edu.harvard.hul.ois.jhove.module.pdf.Numeric;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfProfile;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.Token;
import java.util.Vector;
import java.util.logging.Logger;

public final class LinearizedProfile
extends PdfProfile {
    private Logger _logger;

    public LinearizedProfile(PdfModule module) {
        super(module);
        this._profileText = "Linearized PDF";
        this._logger = Logger.getLogger("edu.harvard.hul.ois.jhove.module");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean satisfiesThisProfile() {
        this._logger.info("Checking Linearized Profile");
        try {
            long fileLength = this._raf.length();
            PdfObject firstObj = this.findFirstObject();
            if (!(firstObj instanceof PdfDictionary)) {
                return false;
            }
            PdfDictionary lindict = (PdfDictionary)firstObj;
            if (lindict.get("Linearized") == null) return false;
            PdfObject lengthObj = lindict.get("L");
            if (!(lengthObj instanceof PdfSimpleObject)) return false;
            Token lengthTok = ((PdfSimpleObject)lengthObj).getToken();
            if (!(lengthTok instanceof Numeric)) return false;
            long length = ((Numeric)lengthTok).getLongValue();
            if (length != fileLength) {
                return false;
            }
            PdfArray hintArray = (PdfArray)lindict.get("H");
            if (hintArray == null) return false;
            this._logger.info("Checking hint array");
            Vector<PdfObject> hintVec = hintArray.getContent();
            int vecSize = hintVec.size();
            if (vecSize != 2 && vecSize != 4) {
                return false;
            }
            for (int i = 0; i < vecSize; i += 2) {
                long hlen;
                PdfSimpleObject hobj = (PdfSimpleObject)this._module.resolveIndirectObject(hintVec.elementAt(i));
                Numeric hnum = (Numeric)hobj.getToken();
                long hoffset = hnum.getLongValue();
                if (hoffset + (hlen = (hnum = (Numeric)(hobj = (PdfSimpleObject)hintVec.elementAt(i + 1)).getToken()).getLongValue()) > fileLength) {
                    return false;
                }
                this._parser.seek(hoffset);
                PdfObject hintStream = this._parser.readObject(false);
                if (hintStream instanceof PdfSimpleObject) {
                    this._parser.readObject(false);
                    this._parser.readObject(false);
                    hintStream = this._parser.readObject(false);
                }
                if (!(hintStream instanceof PdfDictionary)) {
                    return false;
                }
                if (LinearizedProfile.validateHintStream((PdfDictionary)hintStream)) continue;
                return false;
            }
            PdfSimpleObject firstObjNum = (PdfSimpleObject)lindict.get("O");
            if (!(firstObjNum.getToken() instanceof Numeric)) {
                return false;
            }
            PdfSimpleObject endpageObj = (PdfSimpleObject)lindict.get("E");
            Numeric endpageTok = (Numeric)endpageObj.getToken();
            long endpage = endpageTok.getLongValue();
            if (endpage > fileLength) {
                return false;
            }
            PdfSimpleObject numpagesObj = (PdfSimpleObject)lindict.get("N");
            if (!(numpagesObj.getToken() instanceof Numeric)) {
                return false;
            }
            PdfSimpleObject xrefObj = (PdfSimpleObject)lindict.get("T");
            Numeric xrefTok = (Numeric)xrefObj.getToken();
            long xrefOffset = xrefTok.getLongValue();
            if (this.verifyXRef(xrefOffset)) return true;
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private PdfObject findFirstObject() {
        try {
            this._parser.seek(8L);
            do {
                Token tok;
                if (!((tok = this._parser.getNext()) instanceof Keyword) || !"obj".equals(((Keyword)tok).getValue())) continue;
                PdfObject val = this._parser.readObject(false);
                if (this._parser.getOffset() <= 1024L) {
                    return val;
                }
                return null;
            } while (this._parser.getOffset() <= 1024L);
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean verifyXRef(long xrefOffset) {
        try {
            this._logger.info("Verifying cross-reference table");
            this._parser.seek(xrefOffset);
            this._parser.getNext(Numeric.class, JhoveMessages.DEFAULT_MESSAGE);
            this._parser.getNext(Numeric.class, JhoveMessages.DEFAULT_MESSAGE);
            this._parser.getNext(Keyword.class, JhoveMessages.DEFAULT_MESSAGE);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean validateHintStream(PdfDictionary hDict) {
        try {
            PdfSimpleObject obj = (PdfSimpleObject)hDict.get("S");
            if (obj == null) {
                return false;
            }
            int offset = obj.getIntValue();
            if (offset < 0) {
                return false;
            }
            obj = (PdfSimpleObject)hDict.get("T");
            if (obj != null && (offset = obj.getIntValue()) < 0) {
                return false;
            }
            obj = (PdfSimpleObject)hDict.get("O");
            if (obj != null && (offset = obj.getIntValue()) < 0) {
                return false;
            }
            obj = (PdfSimpleObject)hDict.get("A");
            if (obj != null && (offset = obj.getIntValue()) < 0) {
                return false;
            }
            obj = (PdfSimpleObject)hDict.get("E");
            if (obj != null && (offset = obj.getIntValue()) < 0) {
                return false;
            }
            obj = (PdfSimpleObject)hDict.get("V");
            if (obj != null && (offset = obj.getIntValue()) < 0) {
                return false;
            }
            obj = (PdfSimpleObject)hDict.get("I");
            if (obj != null && (offset = obj.getIntValue()) < 0) {
                return false;
            }
            obj = (PdfSimpleObject)hDict.get("L");
            if (obj != null && (offset = obj.getIntValue()) < 0) {
                return false;
            }
            obj = (PdfSimpleObject)hDict.get("C");
            return obj == null || (offset = obj.getIntValue()) >= 0;
        }
        catch (Exception e) {
            return false;
        }
    }
}

