/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.MessageConstants;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import java.io.IOException;
import java.util.Vector;

public class NameTreeNode {
    protected PdfModule _module;
    protected NameTreeNode _parent;
    protected PdfDictionary _dict;
    private Vector _kids = null;
    private Vector _names = null;
    private Vector _lowerLimit = null;
    private Vector _upperLimit = null;

    public NameTreeNode(PdfModule module, NameTreeNode parent, PdfDictionary dict) throws PdfException {
        this._module = module;
        this._parent = parent;
        this._dict = dict;
        try {
            PdfArray namesVec;
            PdfArray kidsVec;
            PdfArray limitsDict = (PdfArray)module.resolveIndirectObject(dict.get("Limits"));
            if (limitsDict != null) {
                Vector<PdfObject> vec = limitsDict.getContent();
                PdfSimpleObject limobj = (PdfSimpleObject)vec.elementAt(0);
                this._lowerLimit = limobj.getRawBytes();
                limobj = (PdfSimpleObject)vec.elementAt(1);
                this._upperLimit = limobj.getRawBytes();
            }
            if ((kidsVec = (PdfArray)module.resolveIndirectObject(dict.get("Kids"))) != null) {
                this._kids = kidsVec.getContent();
            }
            if ((namesVec = (PdfArray)module.resolveIndirectObject(dict.get("Names"))) != null) {
                this._names = namesVec.getContent();
            }
        }
        catch (ClassCastException ce) {
            throw new PdfInvalidException(MessageConstants.PDF_HUL_12);
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException ce) {
            throw new PdfInvalidException(MessageConstants.PDF_HUL_13);
        }
        catch (IOException e) {
            throw new PdfMalformedException(MessageConstants.PDF_HUL_14);
        }
    }

    public boolean inBounds(Vector key) {
        if (this._lowerLimit == null) {
            return true;
        }
        if (this._upperLimit == null) {
            return true;
        }
        return NameTreeNode.compareKey(key, this._lowerLimit) >= 0 && NameTreeNode.compareKey(key, this._upperLimit) <= 0;
    }

    public PdfObject get(Vector key) throws PdfException {
        try {
            if (!this.inBounds(key)) {
                return null;
            }
            if (this._names != null) {
                for (int i = 0; i < this._names.size(); i += 2) {
                    PdfSimpleObject k1 = (PdfSimpleObject)this._names.elementAt(i);
                    int cmp = NameTreeNode.compareKey(key, k1.getRawBytes());
                    if (cmp == 0) {
                        return this._module.resolveIndirectObject((PdfObject)this._names.elementAt(i + 1));
                    }
                    if (cmp >= 0) continue;
                    return null;
                }
                return null;
            }
            if (this._kids != null) {
                for (int i = 0; i < this._kids.size(); ++i) {
                    PdfObject res;
                    PdfDictionary kid = (PdfDictionary)this._module.resolveIndirectObject((PdfObject)this._kids.elementAt(i));
                    NameTreeNode kidnode = new NameTreeNode(this._module, this, kid);
                    if (!kidnode.inBounds(key) || (res = kidnode.get(key)) == null) continue;
                    return res;
                }
                return null;
            }
            throw new PdfMalformedException(MessageConstants.PDF_HUL_15);
        }
        catch (IOException | ArrayIndexOutOfBoundsException | ClassCastException | NullPointerException e) {
            throw new PdfMalformedException(MessageConstants.PDF_HUL_16);
        }
    }

    private static int compareKey(Vector a, Vector b) {
        int lenb;
        int lena = a.size();
        int len = lena < (lenb = b.size()) ? lena : lenb;
        for (int i = 0; i < len; ++i) {
            int bi;
            int ai = (Integer)a.elementAt(i);
            if (ai < (bi = ((Integer)b.elementAt(i)).intValue())) {
                return -1;
            }
            if (ai <= bi) continue;
            return 1;
        }
        if (lena == lenb) {
            return 0;
        }
        if (lena < lenb) {
            return -1;
        }
        return 1;
    }
}

