/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.DocNode;
import edu.harvard.hul.ois.jhove.module.pdf.MessageConstants;
import edu.harvard.hul.ois.jhove.module.pdf.PageTreeNode;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class PageObject
extends DocNode {
    private List<PdfStream> _contentStreams = null;

    public PageObject(PdfModule module, PageTreeNode parent, PdfDictionary dict) throws PdfMalformedException {
        super(module, parent, dict);
        this._pageObjectFlag = true;
    }

    public void loadContent(PdfModule module) throws PdfException {
        PdfObject contents = this._dict.get("Contents");
        if (contents == null) {
            return;
        }
        try {
            contents = module.resolveIndirectObject(contents);
            this.processContents(module, contents);
        }
        catch (IOException e) {
            throw new PdfMalformedException(MessageConstants.PDF_HUL_26, 0L);
        }
    }

    public List<PdfStream> getContentStreams() {
        return this._contentStreams;
    }

    public PdfArray getAnnotations() throws PdfException {
        try {
            return (PdfArray)this._module.resolveIndirectObject(this._dict.get("Annots"));
        }
        catch (ClassCastException e) {
            throw new PdfInvalidException(MessageConstants.PDF_HUL_21);
        }
        catch (IOException e) {
            throw new PdfMalformedException(MessageConstants.PDF_HUL_22);
        }
    }

    @Override
    public void startWalk() {
        this._walkFinished = false;
    }

    @Override
    public PageObject nextPageObject() {
        if (this._walkFinished) {
            return null;
        }
        this._walkFinished = true;
        return this;
    }

    @Override
    public DocNode nextDocNode() {
        return this.nextPageObject();
    }

    public PdfArray getArtBox() throws PdfException {
        return PageObject.retrieveAndCheckRectangle(this._dict, "ArtBox", MessageConstants.PDF_HUL_23);
    }

    public PdfArray getTrimBox() throws PdfException {
        return PageObject.retrieveAndCheckRectangle(this._dict, "TrimBox", MessageConstants.PDF_HUL_24);
    }

    public PdfArray getBleedBox() throws PdfException {
        return PageObject.retrieveAndCheckRectangle(this._dict, "BleedBox", MessageConstants.PDF_HUL_25);
    }

    private static PdfArray retrieveAndCheckRectangle(PdfDictionary dict, String dictKey, JhoveMessage invalidMessage) throws PdfInvalidException {
        PdfArray mbox = null;
        try {
            mbox = (PdfArray)dict.get(dictKey);
        }
        catch (ClassCastException e) {
            throw new PdfInvalidException(invalidMessage);
        }
        if (mbox == null) {
            return null;
        }
        if (mbox.toRectangle() != null) {
            return mbox;
        }
        throw new PdfInvalidException(invalidMessage);
    }

    private void processContents(PdfModule module, PdfObject contents) throws PdfException, IOException {
        if (contents instanceof PdfStream) {
            this._contentStreams = new ArrayList<PdfStream>(1);
            this._contentStreams.add((PdfStream)contents);
            return;
        }
        if (!(contents instanceof PdfArray)) {
            throw new PdfInvalidException(MessageConstants.PDF_HUL_27, 0L);
        }
        this.loadContentFromArray(module, (PdfArray)contents);
    }

    private void loadContentFromArray(PdfModule module, PdfArray contents) throws PdfException, IOException {
        Vector<PdfObject> contentVec = contents.getContent();
        if (contentVec.size() == 0) {
            return;
        }
        this._contentStreams = new ArrayList<PdfStream>(contentVec.size());
        for (int i = 0; i < contentVec.size(); ++i) {
            PdfObject streamElement = contentVec.elementAt(i);
            if (!((streamElement = module.resolveIndirectObject(streamElement)) instanceof PdfStream)) {
                throw new PdfInvalidException(MessageConstants.PDF_HUL_28, 0L);
            }
            this._contentStreams.add((PdfStream)streamElement);
        }
    }
}

