/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.DocNode;
import edu.harvard.hul.ois.jhove.module.pdf.MessageConstants;
import edu.harvard.hul.ois.jhove.module.pdf.PageObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfIndirectObj;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;

public class PageTreeNode
extends DocNode {
    private List<DocNode> _descendants;
    private ListIterator<DocNode> _descendantsIter;
    private DocNode _currentDescendant;
    private boolean _walkFirst;
    private Set<Integer> _visitedNodes;

    public PageTreeNode(PdfModule module, PageTreeNode parent, PdfDictionary dict) throws PdfMalformedException {
        super(module, parent, dict);
        this._pageObjectFlag = false;
        this._descendants = new ArrayList<DocNode>(1);
    }

    public void buildSubtree(boolean toplevel, int recGuard) throws PdfException {
        if (recGuard <= 0) {
            throw new PdfMalformedException(MessageConstants.PDF_HUL_32);
        }
        PdfArray kids = null;
        try {
            PdfObject obj = this._dict.get("Kids");
            kids = obj instanceof PdfIndirectObj ? (PdfArray)((PdfIndirectObj)obj).getObject() : (PdfArray)obj;
            if (toplevel && kids == null) {
                PdfSimpleObject type = (PdfSimpleObject)this._dict.get("Type");
                if (type != null && "Page".equals(type.getStringValue())) {
                    PageObject pageObj = new PageObject(this._module, this, this._dict);
                    this._descendants = new ArrayList<DocNode>(1);
                    this._descendants.add(pageObj);
                }
            } else {
                Vector<PdfObject> kidsVec = kids.getContent();
                this._descendants = new ArrayList<DocNode>(kidsVec.size());
                for (int i = 0; i < kidsVec.size(); ++i) {
                    PdfIndirectObj kidRef = (PdfIndirectObj)kidsVec.elementAt(i);
                    PdfDictionary kid = (PdfDictionary)this._module.resolveIndirectObject(kidRef);
                    PdfSimpleObject kidtype = (PdfSimpleObject)kid.get("Type");
                    String kidtypeStr = kidtype.getStringValue();
                    if ("Page".equals(kidtypeStr)) {
                        PageObject pageObj = new PageObject(this._module, this, kid);
                        pageObj.loadContent(this._module);
                        this._descendants.add(pageObj);
                        continue;
                    }
                    if (!"Pages".equals(kidtypeStr)) continue;
                    PageTreeNode nodeObj = new PageTreeNode(this._module, this, kid);
                    nodeObj.buildSubtree(false, recGuard - 1);
                    this._descendants.add(nodeObj);
                }
            }
        }
        catch (PdfException ee) {
            throw ee;
        }
        catch (ArrayIndexOutOfBoundsException excep) {
            throw new PdfInvalidException(MessageConstants.PDF_HUL_147);
        }
        catch (Exception e) {
            throw new PdfInvalidException(MessageConstants.PDF_HUL_29);
        }
    }

    @Override
    public void startWalk() {
        this._descendantsIter = this._descendants.listIterator();
        this._currentDescendant = null;
        this._walkFirst = true;
        this._walkFinished = false;
        this._visitedNodes = new HashSet<Integer>();
    }

    @Override
    public PageObject nextPageObject() throws PdfMalformedException {
        PageObject retval;
        if (this._walkFinished) {
            return null;
        }
        if (this._currentDescendant == null) {
            if (!this._descendantsIter.hasNext()) {
                this._walkFinished = true;
                return null;
            }
            this._currentDescendant = this._descendantsIter.next();
            this._currentDescendant.startWalk();
        }
        if ((retval = this._currentDescendant.nextPageObject()) == null) {
            if (this._descendantsIter.hasNext()) {
                this._currentDescendant = this._descendantsIter.next();
                this._currentDescendant.startWalk();
                retval = this._currentDescendant.nextPageObject();
            } else {
                this._walkFinished = true;
            }
        }
        if (retval != null) {
            Integer objnum = retval.getDict().getObjNumber();
            if (this._visitedNodes.contains(objnum)) {
                throw new PdfMalformedException(MessageConstants.PDF_HUL_30);
            }
            this._visitedNodes.add(objnum);
        }
        return retval;
    }

    @Override
    public DocNode nextDocNode() throws PdfMalformedException {
        DocNode retval;
        if (this._walkFinished) {
            return null;
        }
        if (this._walkFirst) {
            this._walkFirst = false;
            return this;
        }
        if (this._currentDescendant == null) {
            if (!this._descendantsIter.hasNext()) {
                this._walkFinished = true;
                return null;
            }
            this._currentDescendant = this._descendantsIter.next();
            this._currentDescendant.startWalk();
        }
        if ((retval = this._currentDescendant.nextDocNode()) == null) {
            if (this._descendantsIter.hasNext()) {
                this._currentDescendant = this._descendantsIter.next();
                this._currentDescendant.startWalk();
                retval = this._currentDescendant.nextDocNode();
            } else {
                this._walkFinished = true;
            }
        }
        if (retval != null) {
            Integer objnum = retval.getDict().getObjNumber();
            if (this._visitedNodes.contains(objnum)) {
                throw new PdfMalformedException(MessageConstants.PDF_HUL_31);
            }
            this._visitedNodes.add(objnum);
        }
        return retval;
    }
}

