/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;

public class PdfFlateInputStream
extends FilterInputStream {
    private InflaterInputStream iis;
    private int predictor;
    private int columns;
    private int bpc;
    private int colors;
    private int colBytes;
    private int rowLen;
    private byte[] rowBuf;
    private byte[] rowBuf2;
    private int rowBufOff;
    private boolean eof;
    private int iisBufOff;
    private byte[] iisBuf;
    private static final int IISBUF_SIZE = 4096;
    private int iisBufLen;
    private boolean iisEof;

    public PdfFlateInputStream(InputStream is) {
        this(is, null);
    }

    public PdfFlateInputStream(InputStream is, PdfDictionary parms) {
        super(is);
        this.iis = new InflaterInputStream(is);
        this.predictor = 1;
        this.columns = 1;
        this.bpc = 8;
        this.colors = 1;
        this.iisBuf = new byte[4096];
        this.iisBufLen = 0;
        this.iisBufOff = 0;
        this.iisEof = false;
        this.eof = false;
        if (parms != null) {
            try {
                PdfSimpleObject pred = (PdfSimpleObject)parms.get("Predictor");
                if (pred != null) {
                    this.predictor = pred.getIntValue();
                }
            }
            catch (Exception pred) {
                // empty catch block
            }
            try {
                PdfSimpleObject col = (PdfSimpleObject)parms.get("Columns");
                if (col != null) {
                    this.columns = col.getIntValue();
                }
            }
            catch (Exception col) {
                // empty catch block
            }
            try {
                PdfSimpleObject bitsper = (PdfSimpleObject)parms.get("BitsPerComponent");
                if (bitsper != null) {
                    this.bpc = bitsper.getIntValue();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.predictor != 1) {
            this.colBytes = (this.colors * this.bpc + 7) / 8;
            this.rowLen = (this.columns * this.colors * this.bpc + 7) / 8 + this.colBytes;
            this.rowBuf = new byte[this.rowLen];
            this.rowBuf2 = new byte[this.rowLen];
            this.rowBufOff = this.rowLen;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.predictor == 1) {
            return this.readIISByte();
        }
        if (this.rowBufOff == this.rowLen) {
            this.readRow();
            if (this.eof) {
                return -1;
            }
        }
        return this.rowBuf[this.rowBufOff++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.predictor == 1) {
            return this.readIISBytes(b, off, len);
        }
        if (this.rowBufOff == this.rowLen) {
            this.readRow();
            if (this.eof) {
                return -1;
            }
        }
        if (len > this.rowLen - this.rowBufOff) {
            len = this.rowLen - this.rowBufOff;
        }
        for (int i = 0; i < len; ++i) {
            b[off + i] = this.rowBuf[this.rowBufOff++];
        }
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.skipIISBytes(n);
    }

    private void readRow() throws IOException {
        int n;
        byte[] r = this.rowBuf;
        this.rowBuf = this.rowBuf2;
        this.rowBuf2 = r;
        this.rowBufOff = this.colBytes;
        if (this.predictor >= 10) {
            this.readIISByte();
        }
        for (int off = this.colBytes; off < this.rowLen; off += n) {
            n = this.readIISBytes(this.rowBuf, off, this.rowLen - off);
            if (n > 0) {
                continue;
            }
            this.eof = true;
            return;
        }
        switch (this.predictor) {
            case 1: 
            case 10: {
                break;
            }
            case 2: 
            case 11: {
                int i;
                for (i = this.colBytes; i < this.rowLen; ++i) {
                    int n2 = i;
                    this.rowBuf[n2] = (byte)(this.rowBuf[n2] + this.rowBuf[i - this.colBytes]);
                }
                break;
            }
            case 12: {
                int i;
                for (i = this.colBytes; i < this.rowLen; ++i) {
                    int n3 = i;
                    this.rowBuf[n3] = (byte)(this.rowBuf[n3] + this.rowBuf2[i]);
                }
                break;
            }
            case 13: {
                int i;
                for (i = this.colBytes; i < this.rowLen; ++i) {
                    int n4 = i;
                    this.rowBuf[n4] = (byte)(this.rowBuf[n4] + ((this.rowBuf[i - this.colBytes] & 0xFF) + (this.rowBuf2[i] & 0xFF)) / 2);
                }
                break;
            }
            case 14: {
                int i = this.colBytes;
                while (i < this.rowLen) {
                    int a = this.rowBuf[i - this.colBytes] & 0xFF;
                    int b = this.rowBuf2[i] & 0xFF;
                    int c = this.rowBuf2[i - this.colBytes] & 0xFF;
                    int p = a + b - c;
                    int pa = Math.abs(p - a);
                    int pb = Math.abs(p - b);
                    int pc = Math.abs(p - c);
                    int val = pa <= pb && pa <= pc ? a : (pb <= pc ? b : c);
                    int n5 = i++;
                    this.rowBuf[n5] = (byte)(this.rowBuf[n5] + (byte)val);
                }
                break;
            }
            case 15: {
                break;
            }
        }
    }

    private int readIISByte() throws IOException {
        if (this.iisBufOff >= this.iisBufLen && !this.iisEof) {
            this.readIIS();
        }
        if (this.iisEof) {
            return -1;
        }
        return this.iisBuf[this.iisBufOff++] & 0xFF;
    }

    private int readIISBytes(byte[] buf, int off, int len) throws IOException {
        if (this.iisBufOff >= this.iisBufLen && !this.iisEof) {
            this.readIIS();
        }
        if (this.iisEof) {
            return -1;
        }
        if (this.iisBufLen - this.iisBufOff < len) {
            len = this.iisBufLen - this.iisBufOff;
        }
        for (int i = off; i < off + len; ++i) {
            buf[i] = this.iisBuf[this.iisBufOff++];
        }
        return len;
    }

    private long skipIISBytes(long n) throws IOException {
        if (this.iisBufOff >= this.iisBufLen && !this.iisEof) {
            this.readIIS();
        }
        if (this.iisEof) {
            return -1L;
        }
        if ((long)(this.iisBufLen - this.iisBufOff) < n) {
            n = this.iisBufLen - this.iisBufOff;
        }
        this.iisBufOff = (int)((long)this.iisBufOff + n);
        return n;
    }

    private int readIIS() throws IOException {
        if (this.iisEof) {
            return -1;
        }
        int n = this.iis.read(this.iisBuf);
        this.iisBufOff = 0;
        this.iisBufLen = n;
        if (n <= 0) {
            this.iisEof = true;
        }
        return n;
    }
}

