/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.Parser;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.Vector;

public abstract class PdfProfile {
    protected PdfModule _module;
    protected String _profileText;
    protected Parser _parser;
    protected RandomAccessFile _raf;
    private boolean _alreadyOK;

    public PdfProfile(PdfModule module) {
        this._module = module;
    }

    public boolean isAlreadyOK() {
        return this._alreadyOK;
    }

    public final boolean satisfiesProfile(RandomAccessFile raf, Parser parser) {
        this._raf = raf;
        this._parser = parser;
        this._alreadyOK = false;
        boolean sp = this.satisfiesThisProfile();
        if (sp) {
            this._alreadyOK = true;
        }
        return sp;
    }

    public abstract boolean satisfiesThisProfile();

    public String getText() {
        return this._profileText;
    }

    protected boolean hasFilters(PdfObject filter, String[] names) {
        try {
            if (filter == null) {
                return false;
            }
            if (filter instanceof PdfSimpleObject) {
                String filterName = ((PdfSimpleObject)filter).getStringValue();
                for (int j = 0; j < names.length; ++j) {
                    if (!names[j].equals(filterName)) continue;
                    return true;
                }
            } else {
                Vector<PdfObject> filterVec = ((PdfArray)filter).getContent();
                for (int i = 0; i < filterVec.size(); ++i) {
                    PdfSimpleObject filt = (PdfSimpleObject)filterVec.elementAt(i);
                    String filterName = filt.getStringValue();
                    for (int j = 0; j < names.length; ++j) {
                        if (!names[j].equals(filterName)) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    protected boolean xObjectsOK(PdfDictionary xos) {
        if (xos == null) {
            return true;
        }
        try {
            Iterator<PdfObject> iter = xos.iterator();
            while (iter.hasNext()) {
                PdfDictionary xobj;
                PdfObject obj = this._module.resolveIndirectObject(iter.next());
                if (obj instanceof PdfStream) {
                    obj = ((PdfStream)obj).getDict();
                }
                if (!(obj instanceof PdfDictionary) || this.xObjectOK(xobj = (PdfDictionary)obj)) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected boolean xObjectOK(PdfDictionary xo) {
        return true;
    }
}

