/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.FileSpecification;
import edu.harvard.hul.ois.jhove.module.pdf.Filter;
import edu.harvard.hul.ois.jhove.module.pdf.MessageConstants;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.Stream;
import java.util.Vector;

public class PdfStream
extends PdfObject {
    private Stream _stream;
    private PdfDictionary _dict;
    private Filter[] _filters;
    private boolean pdfaCompliant;

    public PdfStream(PdfDictionary dict, Stream stream, int objNumber, int genNumber) throws PdfException {
        super(objNumber, genNumber);
        this._stream = stream;
        this._dict = dict;
        this.pdfaCompliant = true;
        this.extractFilters();
    }

    public PdfStream(PdfDictionary dict, Stream stream) throws PdfException {
        this._stream = stream;
        this._dict = dict;
        this.pdfaCompliant = true;
        this.extractFilters();
    }

    public PdfDictionary getDict() {
        return this._dict;
    }

    public Stream getStream() {
        return this._stream;
    }

    public String getFileSpecification() throws PdfInvalidException {
        PdfObject spec = this._dict.get("F");
        if (spec == null) {
            return null;
        }
        this.pdfaCompliant = false;
        return FileSpecification.getFileSpecString(spec);
    }

    public boolean isPdfaCompliant() {
        return this.pdfaCompliant;
    }

    public Filter[] getFilters() {
        return this._filters;
    }

    public String getFilterName() {
        PdfObject name;
        PdfObject decparms = this._dict.get("DecodeParams");
        if (decparms instanceof PdfDictionary && (name = ((PdfDictionary)decparms).get("Name")) instanceof PdfSimpleObject) {
            return ((PdfSimpleObject)name).getStringValue();
        }
        return null;
    }

    private void extractFilters() throws PdfException {
        PdfObject parms;
        boolean ff = false;
        this._filters = new Filter[0];
        PdfObject filter = this._dict.get("Filter");
        if (filter == null) {
            filter = this._dict.get("FFilter");
            if (filter == null) {
                return;
            }
            ff = true;
            this.pdfaCompliant = false;
        }
        if (ff) {
            parms = this._dict.get("FDecodeParms");
            if (parms != null) {
                this.pdfaCompliant = false;
            }
        } else {
            parms = this._dict.get("DecodeParms");
        }
        try {
            if (filter instanceof PdfArray) {
                Vector<PdfObject> vec = ((PdfArray)filter).getContent();
                int size = vec.size();
                Filter[] val = new Filter[size];
                Vector<PdfObject> parmVec = null;
                if (parms != null) {
                    parmVec = ((PdfArray)parms).getContent();
                }
                for (int i = 0; i < size; ++i) {
                    PdfSimpleObject sParm;
                    PdfObject parm;
                    PdfSimpleObject f = (PdfSimpleObject)vec.get(i);
                    val[i] = new Filter(f.getStringValue());
                    if (parmVec == null || (parm = parmVec.get(i)) instanceof PdfSimpleObject && "null".equals((sParm = (PdfSimpleObject)parm).getStringValue())) continue;
                    val[i].setDecodeParms((PdfDictionary)parmVec.get(i));
                }
                this._filters = val;
            } else {
                Filter[] val = new Filter[]{new Filter(((PdfSimpleObject)filter).getStringValue())};
                if (parms instanceof PdfDictionary) {
                    val[0].setDecodeParms((PdfDictionary)parms);
                }
                this._filters = val;
            }
        }
        catch (Exception e) {
            throw new PdfMalformedException(MessageConstants.PDF_HUL_45);
        }
    }

    public boolean isImage() {
        PdfObject subtype = this._dict.get("Subtype");
        if (subtype instanceof PdfSimpleObject) {
            String subtypeStr = ((PdfSimpleObject)subtype).getStringValue();
            return "Image".equals(subtypeStr);
        }
        return false;
    }
}

