/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.MessageConstants;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.StructureElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Logger;

public class StructureTree {
    protected Logger _logger = Logger.getLogger("edu.harvard.hul.ois.jhove.module");
    private PdfModule _module;
    private PdfDictionary _rootDict;
    private PdfDictionary _roleMap;
    private boolean _present;
    private boolean _valid;
    private boolean _transient;

    public StructureTree(PdfModule module) {
        this(module, false);
    }

    public StructureTree(PdfModule module, boolean tranzhent) {
        this._module = module;
        this._transient = tranzhent;
        try {
            PdfDictionary docCatDict = module.getCatalogDict();
            this._rootDict = null;
            try {
                this._rootDict = (PdfDictionary)this._module.resolveIndirectObject(docCatDict.get("StructTreeRoot"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this._rootDict == null) {
                this._present = false;
                this._valid = false;
                return;
            }
            this._present = true;
            this.validateRoot();
            this.checkRoleMap();
            this.checkChildren();
            this._valid = true;
        }
        catch (Exception e) {
            this._valid = false;
        }
    }

    public boolean isPresent() {
        return this._present;
    }

    public boolean isValid() {
        return this._valid;
    }

    public PdfModule getModule() {
        return this._module;
    }

    protected boolean isTransient() {
        return this._transient;
    }

    public String dereferenceStructType(String st) {
        if (this._roleMap == null) {
            return st;
        }
        for (int i = 0; i < 50; ++i) {
            try {
                PdfSimpleObject mapped = (PdfSimpleObject)this._roleMap.get(st);
                if (mapped == null) {
                    return st;
                }
                st = mapped.getStringValue();
                continue;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private void validateRoot() throws PdfException {
        try {
            PdfSimpleObject typ = (PdfSimpleObject)this._rootDict.get("Type");
            if (!"StructTreeRoot".equals(typ.getStringValue())) {
                throw new PdfInvalidException(MessageConstants.PDF_HUL_59);
            }
        }
        catch (ClassCastException | NullPointerException e) {
            throw new PdfInvalidException(MessageConstants.PDF_HUL_60);
        }
    }

    private void checkChildren() throws PdfException {
        ArrayList<StructureElement> kidsList = null;
        PdfObject kids = null;
        try {
            kids = this._module.resolveIndirectObject(this._rootDict.get("K"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (kids == null) {
            return;
        }
        if (kids instanceof PdfDictionary) {
            StructureElement se = new StructureElement((PdfDictionary)kids, this);
            se.buildSubtree();
            se.checkAttributes();
            return;
        }
        if (kids instanceof PdfArray) {
            Vector<PdfObject> kidsVec = ((PdfArray)kids).getContent();
            kidsList = new ArrayList<StructureElement>(kidsVec.size());
            for (int i = 0; i < kidsVec.size(); ++i) {
                PdfObject kid;
                try {
                    kid = this._module.resolveIndirectObject(kidsVec.elementAt(i));
                }
                catch (IOException e) {
                    throw new PdfMalformedException(MessageConstants.PDF_HUL_61);
                }
                StructureElement se = new StructureElement((PdfDictionary)kid, this);
                se.buildSubtree();
                se.checkAttributes();
                kidsList.add(se);
            }
        } else {
            throw new PdfInvalidException(MessageConstants.PDF_HUL_62);
        }
    }

    private void checkRoleMap() throws PdfException {
        try {
            this._roleMap = (PdfDictionary)this._module.resolveIndirectObject(this._rootDict.get("RoleMap"));
        }
        catch (Exception e) {
            throw new PdfInvalidException(MessageConstants.PDF_HUL_63);
        }
    }
}

