/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessages;
import edu.harvard.hul.ois.jhove.module.tiff.ExifIFD;
import edu.harvard.hul.ois.jhove.module.tiff.GPSInfoIFD;
import edu.harvard.hul.ois.jhove.module.tiff.GlobalParametersIFD;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.InteroperabilityIFD;
import edu.harvard.hul.ois.jhove.module.tiff.MessageConstants;
import edu.harvard.hul.ois.jhove.module.tiff.TiffException;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassB;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassG;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITBL;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITBLP1;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITBP;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITBPP1;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITBPP2;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITCT;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITCTP1;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITCTP2;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITFP;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITFPP1;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITFPP2;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITHC;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITHCP1;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITHCP2;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITLW;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITLWP1;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITLWP2;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITMP;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITMPP1;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITMPP2;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITSD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassITSDP2;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassP;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassR;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassY;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileDLFBW;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileDLFColor;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileDLFGray;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileDNG;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileDNGThumb;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileEP;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileExif;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileExifThumb;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileFXC;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileFXF;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileFXJ;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileFXL;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileFXM;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileFXS;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileGeoTIFF;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileRFC1314;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;

public class TiffModule
extends ModuleBase {
    public static final String[] defaultConfigParams = new String[]{"byteoffset=true"};
    protected Logger _logger = Logger.getLogger("edu.harvard.hul.ois.jhove");
    private static final String NAME = "TIFF-hul";
    private static final String RELEASE = "1.9.2";
    private static final int[] DATE = new int[]{2019, 12, 10};
    private static final String[] FORMAT = new String[]{"TIFF", "Tagged Image File Format"};
    private static final String COVERAGE = "TIFF 4.0, 5.0, and 6.0; TIFF/IT (ISO/DIS 12639:2003), including file types CT, LW, HC, MP, BP, BL, and FP, and conformance levels P1 and P2; TIFF/EP (ISO 12234-2:2001); Exif 2.0, 2.1 (JEIDA-49-1998), 2.2 (JEITA CP-3451), 2.21 (JEITA CP-3451A), and 2.3 (JEITA CP-3451C); Baseline GeoTIFF 1.0; Baseline 6.0 bilevel (known in TIFF 5.0 as Class B), grayscale (Class G), palette-color (Class P), and RGB (Class R); 6.0 extension YCbCr (Class Y); DLF Benchmark for Faithful Digital Reproductions of Monographs and Serials; TIFF-FX (RFC 2301), Class F (RFC 2306); RFC 1314; and DNG (Digital Negative)";
    private static final String[] MIMETYPE = new String[]{"image/tiff", "image/tiff-fx", "image/ief"};
    private static final String WELLFORMED = "A TIFF file is well-formed if it has a big-endian or little-endian header; at least one IFD; all IFDs are 16-bit word aligned; all IFDs have at least one entry; all IFD entries are sorted in ascending order by tag number; all IFD entries specify the correct type and count; all value offsets are 16-bit word aligned; all value offsets reference locations within the file; and the final IFD is followed by an offset of 0";
    private static final String VALIDITY = "A TIFF file is valid if well-formed; ImageLength, ImageWidth, and PhotometricInterpretation tags are defined; strip or tile tags are defined; tag values are self-consistent (see JHOVE documentation); TileWidth and TileLength values are integral multiples of 16; and DateTime tag is properly formatted";
    private static final String REPINFO = "Additional representation information includes: NISO Z39.87 Digital Still Image Technical Metadata and all other tag values";
    private static final String NOTE = null;
    private static final String RIGHTS = "Copyright 2003-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";
    protected List<TiffProfile> _profile;
    TiffProfileExif _exifMainProfile;
    TiffProfileExifThumb _exifThumbnailProfile;
    TiffProfileDNG _dngMainProfile;
    TiffProfileDNGThumb _dngThumbnailProfile;
    protected boolean _exifFirstFlag;
    protected boolean _exifThumbnailFlag;
    protected boolean _dngThumbnailFlag;
    protected boolean _dngRawFlag;
    protected RandomAccessFile _raf;
    protected int _version;
    protected boolean _byteOffsetIsValid;

    public TiffModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, true);
        this._vendor = Agent.harvardInstance();
        Document doc = new Document("TIFF, Revision 6.0", DocumentType.REPORT);
        Agent adobeAgent = Agent.newAdobeInstance();
        doc.setPublisher(adobeAgent);
        doc.setDate("1992-06-03");
        doc.setEdition("Final");
        doc.setIdentifier(new Identifier("http://partners.adobe.com/asn/tech/tiff/specification.jsp", IdentifierType.URL));
        this._specification.add(doc);
        doc = new Document("TIFF, Revision 5.0", DocumentType.REPORT);
        Agent agent = new Agent.Builder("Aldus Corporation", AgentType.COMMERCIAL).build();
        doc.setPublisher(agent);
        doc.setDate("1988-08-08");
        doc.setNote("Aldus was acquired by Adobe Systems, Inc., in 1993");
        this._specification.add(doc);
        doc = new Document("Tagged Image File Format, Rev. 4.0", DocumentType.REPORT);
        agent = new Agent.Builder("Aldus Corporation", AgentType.COMMERCIAL).build();
        doc.setPublisher(agent);
        doc.setDate("1987-04-30");
        doc.setNote("Aldus was acquired by Adobe Systems, Inc., in 1993");
        this._specification.add(doc);
        doc = new Document("ISO 12234-2:2001, Electronic still-picture imaging -- Removable memory -- Part 2: TIFF/EP image data format", DocumentType.STANDARD);
        Agent isoAgent = Agent.newIsoInstance();
        doc.setPublisher(isoAgent);
        doc.setDate("2001-10-15");
        Identifier ident = new Identifier("ISO 12234-2:2001(E)", IdentifierType.ISO);
        doc.setIdentifier(ident);
        this._specification.add(doc);
        doc = new Document("ISO/DIS 12639:2003, Graphic technology -- Prepress digital data exchange -- Tag image file format for image technology (TIFF/IT)", DocumentType.STANDARD);
        doc.setPublisher(isoAgent);
        doc.setDate("2003-09-04");
        ident = new Identifier("ISO/DIS 12639:2003(E)", IdentifierType.ISO);
        doc.setIdentifier(ident);
        this._specification.add(doc);
        doc = new Document("Benchmark for Faithful Digital Reproductions of Monographs and Serials", DocumentType.REPORT);
        agent = new Agent.Builder("Digital Library Federation", AgentType.NONPROFIT).address("1755 Massachusetts Ave., NW, Suite 500, Washington, DC 20036").telephone("+1 (202) 939-4761").fax("+1 (202) 939-4765").email("dlf@clir.org").web("http://www.diglib.org/").build();
        doc.setPublisher(agent);
        doc.setEdition("Version 1");
        doc.setDate("2002-12");
        ident = new Identifier("http://www.diglib.org/standards/bmarkfin.htm", IdentifierType.URL);
        doc.setIdentifier(ident);
        this._specification.add(doc);
        doc = new Document("Adobe PageMaker TIFF 6.0 Technical Notes", DocumentType.REPORT);
        doc.setPublisher(adobeAgent);
        doc.setDate("1995-09-14");
        ident = new Identifier("http://partners.adobe.com/asn/developer/pdfs/tn/TIFFPM6.pdf", IdentifierType.URL);
        doc.setIdentifier(ident);
        this._specification.add(doc);
        doc = new Document("Adobe Photoshop TIFF Technical Notes", DocumentType.REPORT);
        doc.setPublisher(adobeAgent);
        doc.setDate("2002-03-22");
        ident = new Identifier("http://partners.adobe.com/asn/developer/pdfs/tn/TIFFphotoshop.pdf", IdentifierType.URL);
        doc.setIdentifier(ident);
        this._specification.add(doc);
        doc = new Document("Adobe Photoshop 6.0 File Formats Specification", DocumentType.REPORT);
        doc.setPublisher(adobeAgent);
        doc.setDate("2000-11");
        doc.setEdition("Version 6.0, Release 2");
        this._specification.add(doc);
        doc = new Document("TIFF-F Revised Specification: The Spirit of TIFF Class F", DocumentType.REPORT);
        agent = new Agent.Builder("Cygnet Technologies", AgentType.COMMERCIAL).build();
        doc.setPublisher(agent);
        doc.setDate("1990-04-28");
        doc.setNote("Cygnet is no longer in business");
        this._specification.add(doc);
        doc = new Document("Tag Image File Format (TIFF) -- F Profile for Facsimile", DocumentType.RFC);
        Agent ietfAgent = new Agent.Builder("IETF", AgentType.STANDARD).web("http://www.ietf.org").build();
        doc.setPublisher(ietfAgent);
        doc.setDate("1998-03");
        ident = new Identifier("RFC 2306", IdentifierType.RFC);
        doc.setIdentifier(ident);
        ident = new Identifier("http://hul.harvard.edu/jhove/references.html#rfc2306", IdentifierType.URL);
        doc.setIdentifier(ident);
        this._specification.add(doc);
        doc = new Document("A File Format for the Exchange of Images in the Internet", DocumentType.RFC);
        doc.setPublisher(ietfAgent);
        doc.setDate("1992-04");
        ident = new Identifier("RFC 1314", IdentifierType.RFC);
        doc.setIdentifier(ident);
        ident = new Identifier("http://www.ietf.org/rfc/rfc1314.txt", IdentifierType.URL);
        doc.setIdentifier(ident);
        this._specification.add(doc);
        doc = new Document("Exchangeable image file format for digital still cameras: Exif Version 2.3", DocumentType.STANDARD);
        Agent jeitaAgent = new Agent.Builder("Japan Electronics and Information Technology Industries Association", AgentType.STANDARD).web("http://www.jeita.or.jp/").address("Mitsui Sumitomo Kaijo Building Annex, 11, Kanda Surugadai 3-chome, Chiyoda-ku, Tokyo 101-0062, Japan").telephone("+81(03) 3518-6421").fax("+81(03) 3295-8721").build();
        doc.setPublisher(jeitaAgent);
        doc.setDate("2010-04");
        ident = new Identifier("JEITA CP-3451C", IdentifierType.JEITA);
        doc.setIdentifier(ident);
        ident = new Identifier("http://home.jeita.or.jp/tsc/std-pdf/CP3451C.pdf", IdentifierType.URL);
        doc.setIdentifier(ident);
        this._specification.add(doc);
        doc = new Document("Exchangeable image file format for digital still cameras: Exif Version 2.2", DocumentType.STANDARD);
        doc.setPublisher(jeitaAgent);
        doc.setDate("2002-04");
        ident = new Identifier("JEITA CP-3451", IdentifierType.JEITA);
        doc.setIdentifier(ident);
        ident = new Identifier("http://www.exif.org/Exif2-2.PDF", IdentifierType.URL);
        doc.setIdentifier(ident);
        this._specification.add(doc);
        doc = new Document("Digital Still Camera Image File Format Standard (Exchangeable image file format for Digital Still Camera:Exif)", DocumentType.STANDARD);
        doc.setPublisher(jeitaAgent);
        doc.setDate("1998-12");
        ident = new Identifier("JEITA JEIDA-49-1998", IdentifierType.JEITA);
        doc.setIdentifier(ident);
        ident = new Identifier("http://www.exif.org/dcf-exif.PDF", IdentifierType.URL);
        doc.setIdentifier(ident);
        this._specification.add(doc);
        doc = new Document("GeoTIFF Format Specification: GeoTIFF Revision 1.0", DocumentType.REPORT);
        agent = new Agent.Builder("Niles Ritter", AgentType.OTHER).build();
        doc.setAuthor(agent);
        agent = new Agent.Builder("Mike Ruth", AgentType.OTHER).build();
        doc.setAuthor(agent);
        agent = new Agent.Builder("GeoTIFF Working Group", AgentType.OTHER).build();
        doc.setPublisher(agent);
        doc.setEdition("Version 1.8.1");
        doc.setDate("1995-10-31");
        ident = new Identifier("http://remotesensing.org/geotiff/spec/geotiffhome.html", IdentifierType.URL);
        doc.setIdentifier(ident);
        this._specification.add(doc);
        doc = new Document("File Format for Internet Fax", DocumentType.RFC);
        doc.setPublisher(ietfAgent);
        doc.setDate("1998-03");
        ident = new Identifier("RFC 2301", IdentifierType.RFC);
        doc.setIdentifier(ident);
        ident = new Identifier("http://www.ietf.org/rfc/rfc2301.txt", IdentifierType.URL);
        doc.setIdentifier(ident);
        this._specification.add(doc);
        int[] sigbyteI = new int[]{73, 73, 42, 0};
        InternalSignature sig = new InternalSignature(sigbyteI, SignatureType.MAGIC, SignatureUseType.MANDATORY_IF_APPLICABLE, 0, "Little-endian (least significant byte first)");
        this._signature.add(sig);
        int[] sigbyteM = new int[]{77, 77, 0, 42};
        sig = new InternalSignature(sigbyteM, SignatureType.MAGIC, SignatureUseType.MANDATORY_IF_APPLICABLE, 0, "Big-endian (most significant byte first)");
        this._signature.add(sig);
        sig = new ExternalSignature("TIFF", SignatureType.FILETYPE, SignatureUseType.OPTIONAL);
        this._signature.add(sig);
        sig = new ExternalSignature(".tif", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(sig);
        sig = new ExternalSignature(".tfx", SignatureType.EXTENSION, SignatureUseType.OPTIONAL, "For TIFF-FX");
        this._signature.add(sig);
        sig = new ExternalSignature("TFX ", SignatureType.FILETYPE, SignatureUseType.OPTIONAL, "For TIFF-FX");
        this._signature.add(sig);
        this.buildProfileList();
        this._byteOffsetIsValid = false;
    }

    public final void parse(RandomAccessFile raf, RepInfo info) throws IOException {
        if (this._defaultParams != null) {
            for (String param : this._defaultParams) {
                if (!"byteoffset=true".equalsIgnoreCase(param)) continue;
                this._byteOffsetIsValid = true;
            }
        }
        this._raf = raf;
        this._logger.info("TiffModule parsing file");
        this.initParse();
        info.setModule((Module)this);
        info.setMimeType(this._mimeType[0]);
        info.setFormat(this._format[0]);
        Property[] tiffMetadata = new Property[2];
        List<IFD> ifds = null;
        boolean inHeader = true;
        try {
            raf.seek(0L);
            byte ch0 = this._raf.readByte();
            byte ch1 = this._raf.readByte();
            if (ch0 != ch1 || ch0 != 73 && ch0 != 77) {
                String mess = MessageFormat.format(MessageConstants.TIFF_HUL_20.getMessage(), Character.valueOf((char)ch0), Character.valueOf((char)ch1));
                JhoveMessage message = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_20.getId(), (String)mess);
                throw new TiffException(message, 0L);
            }
            inHeader = false;
            this._bigEndian = ch0 == 77;
            tiffMetadata[0] = new Property("ByteOrder", PropertyType.STRING, (Object)(this._bigEndian ? "big-endian" : "little-endian"));
            int magic = TiffModule.readUnsignedShort((RandomAccessFile)this._raf, (boolean)this._bigEndian);
            if (magic != 42) {
                String mess = MessageFormat.format(MessageConstants.TIFF_HUL_21.getMessage(), magic);
                JhoveMessage message = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_21.getId(), (String)mess);
                throw new TiffException(message, 2L);
            }
            info.setSigMatch(this._name);
            this._version = 4;
            ifds = this.parseIFDs(4L, info);
            info.setVersion(Integer.toString(this._version) + ".0");
            LinkedList<Property> ifdsList = new LinkedList<Property>();
            Property ifdsProp = new Property("IFDs", PropertyType.PROPERTY, PropertyArity.LIST, ifdsList);
            ifdsList.add(new Property("Number", PropertyType.INTEGER, (Object)new Integer(ifds.size())));
            ListIterator<IFD> iter = ifds.listIterator();
            while (iter.hasNext()) {
                IFD ifd = iter.next();
                ifdsList.add(ifd.getProperty(this._je != null ? this._je.getShowRawFlag() : false));
                List<String> errors = ifd.getErrors();
                if (!errors.isEmpty()) {
                    info.setValid(false);
                    ListIterator<String> eter = errors.listIterator();
                    while (eter.hasNext()) {
                        info.setMessage((Message)new ErrorMessage(eter.next()));
                    }
                }
                ListIterator<TiffProfile> pter = this._profile.listIterator();
                while (pter.hasNext()) {
                    TiffProfile prof = pter.next();
                    if (prof.isAlreadyOK() || !prof.satisfiesProfile(ifd)) continue;
                    info.setProfile(prof.getText());
                }
                if (ifd.isFirst()) {
                    this._exifFirstFlag = this._exifMainProfile.satisfiesProfile(ifd);
                    this._exifThumbnailProfile.setMainCompression(((TiffIFD)ifd).getNisoImageMetadata().getCompressionScheme());
                } else if (ifd.isThumbnail()) {
                    this._exifThumbnailFlag = this._exifThumbnailProfile.satisfiesProfile(ifd);
                }
                if (ifd.isFirst()) {
                    this._dngThumbnailFlag = this._dngThumbnailProfile.satisfiesProfile(ifd);
                }
                if (this._dngRawFlag) continue;
                this._dngRawFlag = this._dngMainProfile.satisfiesProfile(ifd);
            }
            tiffMetadata[1] = ifdsProp;
            if (this._exifFirstFlag && this._exifThumbnailFlag) {
                info.setProfile(this._exifMainProfile.getText());
            }
            if (this._dngThumbnailFlag && this._dngRawFlag) {
                info.setProfile(this._dngMainProfile.getText());
            }
            info.setProperty(new Property("TIFFMetadata", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)tiffMetadata));
        }
        catch (TiffException e) {
            if (e.getJhoveMessage() != null) {
                info.setMessage((Message)new ErrorMessage(e.getJhoveMessage(), e.getOffset()));
            } else {
                info.setMessage((Message)new ErrorMessage(e.getMessage(), e.getOffset()));
            }
            info.setWellFormed(false);
            return;
        }
        catch (IOException e) {
            JhoveMessage msg;
            if (inHeader) {
                msg = MessageConstants.TIFF_HUL_67;
            } else {
                String mess = MessageFormat.format(MessageConstants.TIFF_HUL_68.getMessage(), e.getClass().getName());
                msg = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_68.getId(), (String)mess);
            }
            info.setMessage((Message)new ErrorMessage(msg));
            info.setWellFormed(false);
            return;
        }
        this.checksumIfRafNotCopied(info, raf);
        info.setMimeType(this._mimeType[this.selectMimeTypeIndex()]);
        this.checkValidity(ifds, info);
    }

    public void setByteOffsetValid(boolean v) {
        this._byteOffsetIsValid = v;
    }

    public final List<IFD> exifParse(RandomAccessFile raf, RepInfo info) throws IOException {
        this._raf = raf;
        this.initParse();
        List<IFD> ifds = null;
        boolean inHeader = true;
        try {
            raf.seek(0L);
            byte ch0 = this._raf.readByte();
            byte ch1 = this._raf.readByte();
            if (ch0 != ch1 || ch0 != 73 && ch0 != 77) {
                String mess = MessageFormat.format(MessageConstants.TIFF_HUL_22.getMessage(), Character.valueOf((char)ch0), Character.valueOf((char)ch1));
                JhoveMessage message = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_22.getId(), (String)mess);
                throw new TiffException(message, 0L);
            }
            this._bigEndian = ch0 == 77;
            int magic = TiffModule.readUnsignedShort((RandomAccessFile)this._raf, (boolean)this._bigEndian);
            if (magic != 42) {
                String mess = MessageFormat.format(MessageConstants.TIFF_HUL_23.getMessage(), magic);
                JhoveMessage message = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_23.getId(), (String)mess);
                throw new TiffException(message, 2L);
            }
            inHeader = false;
            this._version = 4;
            ifds = this.parseIFDs(4L, info, true, 0);
            ListIterator<IFD> iter = ifds.listIterator();
            while (iter.hasNext()) {
                IFD ifd = iter.next();
                List<String> errors = ifd.getErrors();
                if (errors.isEmpty()) continue;
                info.setValid(false);
                ListIterator<String> eter = errors.listIterator();
                while (eter.hasNext()) {
                    info.setMessage((Message)new ErrorMessage(eter.next()));
                }
            }
        }
        catch (TiffException e) {
            if (e.getJhoveMessage() != null) {
                info.setMessage((Message)new InfoMessage(e.getJhoveMessage(), e.getOffset()));
            } else {
                info.setMessage((Message)new InfoMessage(e.getMessage(), e.getOffset()));
            }
            return ifds;
        }
        catch (IOException e) {
            JhoveMessage msg;
            if (inHeader) {
                msg = MessageConstants.TIFF_HUL_70;
            } else {
                String mess = MessageFormat.format(MessageConstants.TIFF_HUL_69.getMessage(), e.getClass().getName());
                msg = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_69.getId(), (String)mess);
            }
            info.setMessage((Message)new ErrorMessage(msg));
            info.setWellFormed(false);
            return null;
        }
        return ifds;
    }

    protected void buildProfileList() {
        this._profile = new ArrayList<TiffProfile>(30);
        this._profile.add(new TiffProfileClassB());
        this._profile.add(new TiffProfileClassG());
        this._profile.add(new TiffProfileClassP());
        this._profile.add(new TiffProfileClassR());
        this._profile.add(new TiffProfileClassY());
        this._profile.add(new TiffProfileClassITBL());
        this._profile.add(new TiffProfileClassITBLP1());
        this._profile.add(new TiffProfileClassITBP());
        this._profile.add(new TiffProfileClassITBPP1());
        this._profile.add(new TiffProfileClassITBPP2());
        this._profile.add(new TiffProfileClassITCT());
        this._profile.add(new TiffProfileClassITCTP1());
        this._profile.add(new TiffProfileClassITCTP2());
        this._profile.add(new TiffProfileClassITFP());
        this._profile.add(new TiffProfileClassITFPP1());
        this._profile.add(new TiffProfileClassITFPP2());
        this._profile.add(new TiffProfileClassITHC());
        this._profile.add(new TiffProfileClassITHCP1());
        this._profile.add(new TiffProfileClassITHCP2());
        this._profile.add(new TiffProfileClassITLW());
        this._profile.add(new TiffProfileClassITLWP1());
        this._profile.add(new TiffProfileClassITLWP2());
        this._profile.add(new TiffProfileClassITMP());
        this._profile.add(new TiffProfileClassITMPP1());
        this._profile.add(new TiffProfileClassITMPP2());
        this._profile.add(new TiffProfileClassITSD());
        this._profile.add(new TiffProfileClassITSDP2());
        this._profile.add(new TiffProfileEP());
        this._profile.add(new TiffProfileGeoTIFF());
        this._profile.add(new TiffProfileDLFBW());
        this._profile.add(new TiffProfileDLFGray());
        this._profile.add(new TiffProfileDLFColor());
        this._profile.add(new TiffProfileRFC1314());
        this._profile.add(new TiffProfileFXS());
        this._profile.add(new TiffProfileFXF());
        this._profile.add(new TiffProfileFXJ());
        this._profile.add(new TiffProfileFXL());
        this._profile.add(new TiffProfileFXC());
        this._profile.add(new TiffProfileFXM());
        this._exifMainProfile = new TiffProfileExif();
        this._exifThumbnailProfile = new TiffProfileExifThumb();
        this._dngMainProfile = new TiffProfileDNG();
        this._dngThumbnailProfile = new TiffProfileDNGThumb();
    }

    protected void checkValidity(List<IFD> ifds, RepInfo info) {
        this._logger.info("TiffModule checking validity of IFDs");
        ListIterator<IFD> iter = ifds.listIterator();
        while (iter.hasNext()) {
            try {
                IFD ifd = iter.next();
                if (!(ifd instanceof TiffIFD)) continue;
                this.checkValidity((TiffIFD)ifd, info);
            }
            catch (TiffException e) {
                if (e.getJhoveMessage() != null) {
                    info.setMessage((Message)new ErrorMessage(e.getJhoveMessage(), e.getOffset()));
                } else {
                    info.setMessage((Message)new ErrorMessage(e.getMessage(), e.getOffset()));
                }
                info.setValid(false);
            }
        }
    }

    protected void checkValidity(TiffIFD ifd, RepInfo info) throws TiffException {
        String dateTime;
        int[] dotRange;
        JhoveMessage message;
        boolean tilesDefined;
        long imageLength;
        long imageWidth;
        NisoImageMetadata niso = ifd.getNisoImageMetadata();
        int photometricInterpretation = niso.getColorSpace();
        if (photometricInterpretation == -1) {
            this.reportInvalid(MessageConstants.TIFF_HUL_63, info);
        }
        if ((imageWidth = niso.getImageWidth()) == -1L) {
            this.reportInvalid(MessageConstants.TIFF_HUL_62, info);
        }
        if ((imageLength = niso.getImageLength()) == -1L) {
            this.reportInvalid(MessageConstants.TIFF_HUL_64, info);
        }
        long[] stripOffsets = niso.getStripOffsets();
        long[] stripByteCounts = niso.getStripByteCounts();
        boolean stripsDefined = stripOffsets != null || stripByteCounts != null;
        long tileWidth = niso.getTileWidth();
        long tileLength = niso.getTileLength();
        long[] tileOffsets = niso.getTileOffsets();
        long[] tileByteCounts = niso.getTileByteCounts();
        boolean bl = tilesDefined = tileWidth != -1L || tileLength != -1L || tileOffsets != null || tileByteCounts != null;
        if (stripsDefined && tilesDefined) {
            this.reportInvalid(MessageConstants.TIFF_HUL_24, info);
            throw new TiffException(MessageConstants.TIFF_HUL_24);
        }
        if (!stripsDefined && !tilesDefined) {
            this.reportInvalid(MessageConstants.TIFF_HUL_25, info);
            throw new TiffException(MessageConstants.TIFF_HUL_25);
        }
        int planarConfiguration = niso.getPlanarConfiguration();
        int samplesPerPixel = niso.getSamplesPerPixel();
        if (stripsDefined) {
            if (stripOffsets == null) {
                this.reportInvalid(MessageConstants.TIFF_HUL_26, info);
                throw new TiffException(MessageConstants.TIFF_HUL_26);
            }
            if (stripByteCounts == null) {
                this.reportInvalid(MessageConstants.TIFF_HUL_27, info);
                throw new TiffException(MessageConstants.TIFF_HUL_27);
            }
            int len = stripOffsets.length;
            if (len != stripByteCounts.length) {
                String mess = MessageFormat.format(MessageConstants.TIFF_HUL_28.getMessage(), len, stripByteCounts.length);
                JhoveMessage message2 = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_28.getId(), (String)mess);
                this.reportInvalid(message2, info);
            }
            try {
                long fileLength = this._raf.length();
                for (int i = 0; i < len; ++i) {
                    long offset = stripOffsets[i];
                    long count = stripByteCounts[i];
                    if (offset + count <= fileLength) continue;
                    this.reportInvalid(MessageConstants.TIFF_HUL_29, info);
                }
            }
            catch (IOException fileLength) {
                // empty catch block
            }
        }
        if (tilesDefined) {
            if (tileWidth == -1L) {
                this.reportInvalid(MessageConstants.TIFF_HUL_30, info);
            }
            if (tileLength == -1L) {
                this.reportInvalid(MessageConstants.TIFF_HUL_31, info);
            }
            if (tileOffsets == null) {
                this.reportInvalid(MessageConstants.TIFF_HUL_32, info);
            }
            if (tileByteCounts == null) {
                this.reportInvalid(MessageConstants.TIFF_HUL_33, info);
            }
            if (tileWidth % 16L > 0L) {
                String mess = MessageFormat.format(MessageConstants.TIFF_HUL_34.getMessage(), tileWidth);
                JhoveMessage message3 = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_34.getId(), (String)mess);
                this.reportInvalid(message3, info);
            }
            if (tileLength % 16L > 0L) {
                String mess = MessageFormat.format(MessageConstants.TIFF_HUL_35.getMessage(), tileLength);
                JhoveMessage message4 = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_35.getId(), (String)mess);
                this.reportInvalid(message4, info);
            }
            long tilesPerImage = (imageWidth + tileWidth - 1L) / tileWidth * ((imageLength + tileLength - 1L) / tileLength);
            if (planarConfiguration == 2) {
                JhoveMessage message5;
                long spp_tpi = (long)samplesPerPixel * tilesPerImage;
                if (tileOffsets != null && (long)tileOffsets.length < spp_tpi) {
                    String mess = MessageFormat.format(MessageConstants.TIFF_HUL_36.getMessage(), tileOffsets.length, spp_tpi);
                    message5 = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_36.getId(), (String)mess);
                    this.reportInvalid(message5, info);
                }
                if (tileByteCounts != null && (long)tileByteCounts.length < spp_tpi) {
                    String mess = MessageFormat.format(MessageConstants.TIFF_HUL_37.getMessage(), tileByteCounts.length, spp_tpi);
                    message5 = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_37.getId(), (String)mess);
                    this.reportInvalid(message5, info);
                }
            } else {
                String mess;
                if (tileOffsets != null && (long)tileOffsets.length < tilesPerImage) {
                    mess = MessageFormat.format(MessageConstants.TIFF_HUL_38.getMessage(), tileOffsets.length, tilesPerImage);
                    JhoveMessage message6 = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_38.getId(), (String)mess);
                    this.reportInvalid(message6, info);
                }
                if (tileByteCounts != null && (long)tileByteCounts.length < tilesPerImage) {
                    mess = MessageFormat.format(MessageConstants.TIFF_HUL_39.getMessage(), tileByteCounts.length, tilesPerImage);
                    JhoveMessage message7 = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_39.getId(), (String)mess);
                    this.reportInvalid(message7, info);
                }
            }
        }
        int newSubfileType = (int)ifd.getNewSubfileType();
        if (photometricInterpretation == 4 && (newSubfileType & 4) == 0 || photometricInterpretation != 4 && (newSubfileType & 4) != 0) {
            this.reportInvalid(MessageConstants.TIFF_HUL_40, info);
        }
        int[] bitsPerSample = niso.getBitsPerSample();
        if (photometricInterpretation == 4 && (samplesPerPixel < 1 || bitsPerSample[0] != 1)) {
            this.reportInvalid(MessageConstants.TIFF_HUL_41, info);
        }
        if ((photometricInterpretation == 0 || photometricInterpretation == 1 || photometricInterpretation == 3 || photometricInterpretation == 4) && samplesPerPixel < 1) {
            String mess = MessageFormat.format(MessageConstants.TIFF_HUL_42.getMessage(), samplesPerPixel);
            JhoveMessage message8 = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_42.getId(), (String)mess);
            this.reportInvalid(message8, info);
        }
        if ((photometricInterpretation == 2 || photometricInterpretation == 6 || photometricInterpretation == 8) && samplesPerPixel < 3) {
            String mess = MessageFormat.format(MessageConstants.TIFF_HUL_43.getMessage(), samplesPerPixel);
            JhoveMessage message9 = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_43.getId(), (String)mess);
            this.reportInvalid(message9, info);
        }
        if (photometricInterpretation == 3) {
            int len;
            int[] colormapBitCodeValue = niso.getColormapBitCodeValue();
            int[] colormapRedValue = niso.getColormapRedValue();
            int[] colormapGreenValue = niso.getColormapGreenValue();
            int[] colormapBlueValue = niso.getColormapBlueValue();
            if (colormapBitCodeValue == null || colormapRedValue == null || colormapGreenValue == null || colormapBlueValue == null) {
                this.reportInvalid(MessageConstants.TIFF_HUL_44, info);
            }
            if (samplesPerPixel != 1) {
                String mess = MessageFormat.format(MessageConstants.TIFF_HUL_45.getMessage(), samplesPerPixel);
                message = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_45.getId(), (String)mess);
                this.reportInvalid(message, info);
            }
            if (colormapBitCodeValue.length < (len = 1 << bitsPerSample[0])) {
                String mess = MessageFormat.format(MessageConstants.TIFF_HUL_46.getMessage(), colormapBitCodeValue.length, len);
                JhoveMessage message10 = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_46.getId(), (String)mess);
                this.reportInvalid(message10, info);
            }
        }
        if (ifd.getCellLength() != -1 && ifd.getThreshholding() != 2) {
            this.reportInvalid(MessageConstants.TIFF_HUL_47, info);
        }
        if ((dotRange = ifd.getDotRange()) != null && bitsPerSample != null) {
            int sampleMax = 1 << bitsPerSample[0];
            if (dotRange.length < 2 || dotRange[0] >= sampleMax || dotRange[1] >= sampleMax) {
                this.reportInvalid(MessageConstants.TIFF_HUL_48, info);
            }
        }
        if (niso.getCompressionScheme() == 6 && ifd.getJPEGProc() == -1) {
            this.reportInvalid(MessageConstants.TIFF_HUL_49, info);
        }
        if (photometricInterpretation == 8 || photometricInterpretation == 9) {
            int in;
            int len = 0;
            int[] xs = niso.getExtraSamples();
            if (xs != null) {
                len = niso.getExtraSamples().length;
            }
            if ((in = samplesPerPixel - len) != 1 && in != 3) {
                String mess = MessageFormat.format(MessageConstants.TIFF_HUL_50.getMessage(), samplesPerPixel, len);
                message = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_50.getId(), (String)mess);
                this.reportInvalid(message, info);
            }
            for (int i = 0; i < bitsPerSample.length; ++i) {
                if (bitsPerSample[i] == 8 || bitsPerSample[i] == 16) continue;
                this.reportInvalid(MessageConstants.TIFF_HUL_51, info);
            }
        }
        if (ifd.getClipPath() != null && ifd.getXClipPathUnits() == -1L) {
            this.reportInvalid(MessageConstants.TIFF_HUL_52, info);
        }
        if ((dateTime = ifd.getDateTime()) != null) {
            if (dateTime.length() != 19) {
                String mess = MessageFormat.format(MessageConstants.TIFF_HUL_53.getMessage(), dateTime);
                JhoveMessage message11 = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_53.getId(), (String)mess);
                this.reportInvalid(message11, info);
                return;
            }
            if (dateTime.charAt(4) != ':' || dateTime.charAt(7) != ':' || dateTime.charAt(10) != ' ' || dateTime.charAt(13) != ':' || dateTime.charAt(16) != ':') {
                String mess = MessageFormat.format(MessageConstants.TIFF_HUL_54.getMessage(), dateTime);
                JhoveMessage message12 = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_54.getId(), (String)mess);
                this.reportInvalid(message12, info);
                return;
            }
            try {
                int yyyy = Integer.parseInt(dateTime.substring(0, 4));
                int mm = Integer.parseInt(dateTime.substring(5, 7));
                int dd = Integer.parseInt(dateTime.substring(8, 10));
                int hh = Integer.parseInt(dateTime.substring(11, 13));
                int mn = Integer.parseInt(dateTime.substring(14, 16));
                int ss = Integer.parseInt(dateTime.substring(17));
                if (yyyy < 0 || yyyy > 9999 || mm < 1 || mm > 12 || dd < 1 || dd > 31 || hh < 0 || hh > 24 || mn < 0 || mn > 59 || ss < 0 || mn > 59) {
                    String mess = MessageFormat.format(MessageConstants.TIFF_HUL_55.getMessage(), dateTime);
                    JhoveMessage message13 = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_55.getId(), (String)mess);
                    this.reportInvalid(message13, info);
                }
            }
            catch (Exception e) {
                String mess = MessageFormat.format(MessageConstants.TIFF_HUL_56.getMessage(), dateTime);
                JhoveMessage message14 = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_56.getId(), (String)mess);
                this.reportInvalid(message14, info);
            }
        }
    }

    protected void reportInvalid(JhoveMessage message, RepInfo info) {
        info.setMessage((Message)new ErrorMessage(message));
        info.setValid(false);
    }

    protected List<IFD> parseIFDs(long offset, RepInfo info) throws TiffException {
        return this.parseIFDs(offset, info, false, 0);
    }

    protected List<IFD> parseIFDs(long offset, RepInfo info, boolean suppressErrors, int ifdType) throws TiffException {
        long next = 0L;
        try {
            this._raf.seek(offset);
            next = TiffModule.readUnsignedInt((RandomAccessFile)this._raf, (boolean)this._bigEndian);
        }
        catch (IOException e) {
            throw new TiffException(MessageConstants.TIFF_HUL_57, offset);
        }
        if (next == 0L) {
            throw new TiffException(MessageConstants.TIFF_HUL_58, offset);
        }
        LinkedList<IFD> list = new LinkedList<IFD>();
        while (next != 0L) {
            if ((next & 1L) != 0L) {
                String mess = MessageFormat.format(MessageConstants.TIFF_HUL_59.getMessage(), next);
                JhoveMessage message = JhoveMessages.getMessageInstance((String)MessageConstants.TIFF_HUL_59.getId(), (String)mess);
                throw new TiffException(message);
            }
            if (list.size() > 50) {
                throw new TiffException(MessageConstants.TIFF_HUL_60);
            }
            this._logger.info("Parsing next IFD at offset " + next);
            IFD ifd = this.parseIFDChain(next, info, ifdType, list, suppressErrors);
            next = ifd.getNext();
        }
        return list;
    }

    protected IFD parseIFDChain(long next, RepInfo info, int type, List<IFD> list, boolean suppressErrors) throws TiffException {
        IFD ifd = null;
        switch (type) {
            case 1: {
                ifd = new ExifIFD(next, info, this._raf, this._bigEndian);
                break;
            }
            case 2: {
                ifd = new InteroperabilityIFD(next, info, this._raf, this._bigEndian);
                break;
            }
            case 3: {
                ifd = new GPSInfoIFD(next, info, this._raf, this._bigEndian);
                break;
            }
            case 4: {
                ifd = new GlobalParametersIFD(next, info, this._raf, this._bigEndian);
                break;
            }
            default: {
                ifd = new TiffIFD(next, info, this._raf, this._bigEndian);
            }
        }
        ifd.parse(this._byteOffsetIsValid, suppressErrors);
        int version = ifd.getVersion();
        if (version > this._version) {
            this._version = version;
        }
        if (list.isEmpty() && type == 0) {
            ifd.setFirst(true);
        } else if (list.size() == 1 && type == 0) {
            ifd.setThumbnail(true);
        }
        list.add(ifd);
        if (ifd instanceof TiffIFD) {
            IFD io;
            long offset;
            TiffIFD tifd = (TiffIFD)ifd;
            long[] subIFDs = tifd.getSubIFDs();
            if (subIFDs != null) {
                for (int i = 0; i < subIFDs.length; ++i) {
                    next = subIFDs[i];
                    while (next != 0L) {
                        IFD sub = this.parseIFDChain(next, info, 0, list, suppressErrors);
                        next = sub.getNext();
                    }
                }
            }
            if ((offset = tifd.getExifIFD()) != -1L) {
                IFD ex = this.parseIFDChain(offset, info, 1, list, suppressErrors);
                tifd.setTheExifIFD((ExifIFD)ex);
            }
            if ((offset = tifd.getGPSInfoIFD()) != -1L) {
                IFD gp = this.parseIFDChain(offset, info, 3, list, suppressErrors);
                tifd.setTheGPSInfoIFD((GPSInfoIFD)gp);
            }
            if ((offset = tifd.getInteroperabilityIFD()) != -1L) {
                io = this.parseIFDChain(offset, info, 2, list, suppressErrors);
                tifd.setTheInteroperabilityIFD((InteroperabilityIFD)io);
            }
            if ((offset = tifd.getGlobalParametersIFD()) != -1L) {
                io = this.parseIFDChain(offset, info, 4, list, suppressErrors);
                tifd.setTheGlobalParametersIFD((GlobalParametersIFD)io);
            }
        }
        return ifd;
    }

    protected void initParse() {
        super.initParse();
        ListIterator<TiffProfile> pter = this._profile.listIterator();
        while (pter.hasNext()) {
            TiffProfile prof = pter.next();
            prof.setAlreadyOK(false);
        }
        this._exifFirstFlag = false;
        this._exifThumbnailFlag = true;
        this._dngThumbnailFlag = false;
        this._dngRawFlag = false;
    }

    protected int selectMimeTypeIndex() {
        int trial = -1;
        ListIterator<TiffProfile> pter = this._profile.listIterator();
        while (pter.hasNext()) {
            TiffProfile prof = pter.next();
            if (!prof.isAlreadyOK()) continue;
            int idx = prof.getMimeClass();
            if (idx == 0) {
                return 0;
            }
            if (trial >= 0 && idx != trial) {
                return 0;
            }
            trial = idx;
        }
        if (trial == -1) {
            return 0;
        }
        return trial;
    }
}

