/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITMPP1
extends TiffProfileClassIT {
    public TiffProfileClassITMPP1() {
        this._profileText = "TIFF/IT-MP/P1 (ISO 12639:1998)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!super.satisfiesThisProfile(ifd)) {
            return false;
        }
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        if (!this.satisfiesNewSubfileType(tifd, 0L)) {
            return false;
        }
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        int[] bps = niso.getBitsPerSample();
        if (bps == null || bps[0] != 8) {
            return false;
        }
        if (!this.satisfiesCompression(tifd, 1)) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tifd, 0)) {
            return false;
        }
        if (!this.satisfiesOrientation(tifd, 1)) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tifd, 1)) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tifd, new int[]{2, 3})) {
            return false;
        }
        if (!this.satisfiesDotRange(tifd, 0, 255)) {
            return false;
        }
        int ind = tifd.getImageColorIndicator();
        if (ind != 0 && ind != 1) {
            return false;
        }
        if (ind == 1 && tifd.getImageColorValue() == -1) {
            return false;
        }
        int[] pir = tifd.getPixelIntensityRange();
        if (pir == null || pir.length < 2) {
            return false;
        }
        if (pir[0] != 0 || pir[1] != 255) {
            return false;
        }
        return tifd.getDocumentName() == null && niso.getScannerModelName() == null && tifd.getPageName() == null && niso.getHostComputer() == null && tifd.getSite() == null && tifd.getColorSequence() == null && tifd.getIT8Header() == null;
    }
}

