/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public abstract class TiffProfileDLF
extends TiffProfile {
    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        return this.satisfiesPhotometricInterpretation(tifd, new int[]{0, 1});
    }

    protected boolean hasMinimumResolution(TiffIFD tifd, double minUnit2Res, double minUnit3Res) {
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        Rational xrat = niso.getXSamplingFrequency();
        Rational yrat = niso.getYSamplingFrequency();
        if (xrat == null || yrat == null) {
            return false;
        }
        int resUnit = niso.getSamplingFrequencyUnit();
        switch (resUnit) {
            case 2: {
                if (!(xrat.toDouble() < minUnit2Res) && !(yrat.toDouble() < minUnit2Res)) break;
                return false;
            }
            case 3: {
                if (!(xrat.toDouble() < minUnit3Res) && !(yrat.toDouble() < minUnit3Res)) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

