/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.utf8;

public enum Utf8Block {
    LAT(0, 127, "Basic Latin"),
    LAT_1_SUPP(128, 255, "Latin-1 Supplement"),
    LAT_1_EXT_A(256, 383, "Latin Extended-A"),
    LAT_1_EXT_B(384, 591, "Latin Extended-B"),
    IPA_EXT(592, 687, "IPA Extensions"),
    SPACE_MOD(688, 767, "Spacing Modifier Letters"),
    COMB_DIACRITICAL(768, 879, "Combining Diacritical Marks"),
    GREEK_COPTIC(880, 1023, "Greek and Coptic"),
    CYRILLIC(1024, 1279, "Cyrillic"),
    CYRILLIC_SUPP(1280, 1327, "Cyrillic Supplementary"),
    ARMENIAN(1328, 1423, "Armenian"),
    HEBREW(1424, 1535, "Hebrew"),
    ARABIC(1536, 1791, "Arabic"),
    SYRIAC(1792, 1871, "Syriac"),
    THAANA(1920, 1983, "Thaana"),
    NKO(1984, 2047, "NKo"),
    MANDIAC(2112, 2143, "Mandaic"),
    DEVANAGARI(2304, 2431, "Devanagari"),
    BENGALI(2432, 2559, "Bengali"),
    GURMUKHI(2560, 2687, "Gurmukhi"),
    GUJARATI(2688, 2815, "Gujarati"),
    ORIYA(2816, 2943, "Oriya"),
    TAMIL(2944, 3071, "Tamil"),
    TELUGU(3072, 3199, "Telugu"),
    KANNADA(3200, 3327, "Kannada"),
    MALAYALAM(3328, 3455, "Malayalam"),
    SINHALA(3456, 3583, "Sinhala"),
    THAI(3584, 3711, "Thai"),
    LAO(3712, 3839, "Lao"),
    TIBETAN(3840, 4095, "Tibetan"),
    MYANMAR(4096, 4255, "Myanmar"),
    GEORGIAN(4256, 4351, "Georgian"),
    HANGUL_JAMO(4352, 4607, "Hangul Jamo"),
    ETHIOPOC(4608, 4991, "Ethiopic"),
    CHEROKEE(5024, 5119, "Cherokee"),
    UNFD_CNDN_ABRGNL_SYLL(5120, 5759, "Unified Canadian Aboriginal Syllabics"),
    OGHAM(5760, 5791, "Ogham"),
    RUNIC(5792, 5887, "Runic"),
    TAGALOG(5888, 5919, "Tagalog"),
    HANUNOO(5920, 5951, "Hanunoo"),
    BUHID(5952, 5983, "Buhid"),
    TADBANWA(5984, 6015, "Tagbanwa"),
    KHMER(6016, 6143, "Khmer"),
    MONGOLIAN(6144, 6319, "Mongolian"),
    LIMBU(6400, 6479, "Limbu"),
    TAI_LE(6480, 6527, "Tai Le"),
    KHMER_SYM(6624, 6655, "Khmer Symbols"),
    COMB_DIACRITICAL_EXT(6832, 6911, "Combining Diacritical Marks Extended"),
    BALINESE(6912, 7039, "Balinese"),
    BATAK(7104, 7167, "Batak"),
    PHONETIC_EXT(7424, 7551, "Phonetic Extensions"),
    LATIN_EXT_ADD(7680, 7935, "Latin Extended Additional"),
    GREEK_EXT(7936, 8191, "Greek Extended"),
    GENERAL_PUNCT(8192, 8303, "General Punctuation"),
    SUPER_AND_SUB(8304, 8351, "Superscripts and Subscripts"),
    CURRENCY_SYM(8352, 8399, "Currency Symbols"),
    COMB_DIACRITICAL_SYM(8400, 8447, "Combining Diacritical Marks for Symbols"),
    LETTERLIKE_SYM(8448, 8527, "Letterlike Symbols"),
    NUMBER_FORMS(8528, 8591, "Number Forms"),
    ARROWS(8592, 8703, "Arrows"),
    MATHS_OPS(8704, 8959, "Mathematical Operators"),
    MISC_TECH(8960, 9215, "Miscellaneous Technical"),
    CONTROL_PICS(9216, 9279, "Control Pictures"),
    OCR(9280, 9311, "Optical Character Recognition"),
    ENCL_ALPHANUMS(9312, 9471, "Enclosed Alphanumerics"),
    BOX_DRAWING(9472, 9599, "Box Drawing"),
    BLOCK_ELEMS(9600, 9631, "Block Elements"),
    GEOM_SHAPES(9632, 9727, "Geometric Shapes"),
    MISC_SHAPES(9728, 9983, "Miscellaneous Symbols"),
    DINGBATS(9984, 10175, "Dingbats"),
    MISC_MATH_SYMS_a(10176, 10223, "Miscellaneous Mathematical Symbols-A"),
    SUPP_ARROWS_A(10224, 10239, "Supplemental Arrows-A"),
    BRAILLE_PATTS(10240, 10495, "Braille Patterns"),
    SUPP_ARROWS_B(10496, 10623, "Supplemental Arrows-B"),
    MISC_MATH_SYMS_B(10624, 10751, "Miscellaneous Mathematical Symbols-B"),
    SUPP_MATHS_OPS(10752, 11007, "Supplemental Mathematical Operators"),
    LATIN_EXT_C(11360, 11391, "Latin Extended-C"),
    CJK_RADICALS_SUPP(11904, 12031, "CJK Radicals Supplement"),
    KANGXI_RADICALS(12032, 12255, "Kangxi Radicals"),
    IDEOGRAPHIC_DESC_CHARS(12272, 12287, "Ideographic Description Characters"),
    CJK_SYMS_PUNCT(12288, 12351, "CJK Symbols and Punctuation"),
    HIRAGANA(12352, 12447, "Hiragana"),
    KATAKANA(12448, 12543, "Katakana"),
    BOPOMOFO(12544, 12591, "Bopomofo"),
    HANGUL_COMPAT_JAMO(12592, 12687, "Hangul Compatibility Jamo"),
    KANBUN(12688, 12703, "Kanbun"),
    BOPOMOFO_EXT(12704, 12735, "Bopomofo Extended"),
    KATAKANA_PHONETIC_EXT(12784, 12799, "Katakana Phonetic Extensions"),
    ENCL_CJK_LETT_MONTHS(12800, 13055, "Enclosed CJK Letters and Months"),
    CJK_COMPAT(13056, 13311, "CJK Compatibility"),
    CJK_UNIFIED_IDEOGRAPHS_EXT_A(13312, 19903, "CJK Unified Ideographs Extension A"),
    YIJING_HEX_SYMS(19904, 19967, "Yijing Hexagram Symbols"),
    CJK_UNIFIED_IDEOGRAPHS(19968, 40959, "CJK Unified Ideographs"),
    YI_SYLLABLES(40960, 42127, "Yi Syllables"),
    YI_RADICALS(42128, 42191, "Yi Radicals"),
    LATIN_EXT_D(42784, 43007, "Latin Extended-D"),
    PHAGS_PA(43072, 43135, "Phags-pa"),
    MYNAMAR_EXT_B(43488, 43519, "Myanmar Extended-B"),
    ETHIOPIC_EXT_A(43776, 43823, "Ethiopic Extended-A"),
    LATIN_EXT_E(43824, 43887, "Latin Extended-E"),
    HANGUL_SYM(44032, 55215, "Hangul Syllables"),
    HIGH_SURROG(55296, 56191, "High Surrogates"),
    HIGH_PRIVATE_SURROG(56192, 56319, "High Private Use Surrogates"),
    LOW_SURROG(56320, 57343, "Low Surrogates"),
    PRIVATE_USE(57344, 63743, "Private Use Area"),
    CJK_COMPAT_IDEOGRAPH(63744, 64255, "CJK Compatibility Ideographs"),
    ALPHA_PRES_FORMS_A(64256, 64335, "Alphabetic Presentation Forms"),
    ARABIC_PRES_FORMS_A(64336, 65023, "Arabic Presentation Forms-A"),
    VAR_SELS(65024, 65039, "Variation Selectors"),
    COMB_HALF_MARKS(65056, 65071, "Combining Half Marks"),
    CJK_COMPAT_FORMS(65072, 65103, "CJK Compatibility Forms"),
    SMALL_FORMS_VAR(65104, 65135, "Small Form Variants"),
    ARABIC_PRES_FORMS_B(65136, 65279, "Arabic Presentation Forms-B"),
    HALFWDTH_FULLWDTH_FORMS(65280, 65519, "Halfwidth and Fullwidth Forms"),
    SPECIALS(65520, 65535, "Specials"),
    LINEAR_B_SYLLABARY(65536, 65663, "Linear B Syllabary"),
    LINEAR_B_IDEOGRAMS(65664, 65791, "Linear B Ideograms"),
    AGEAN_NUMS(65792, 65855, "Aegean Numbers"),
    COPTIC_EPACT_NUMS(66272, 66303, "Coptic Epact Numbers"),
    OLD_ITALIC(66304, 66351, "Old Italic"),
    GOTHIC(66352, 66383, "Gothic"),
    OLD_PERMIC(66384, 66431, "Old Permic"),
    UGARITIC(66432, 66463, "Ugaritic"),
    DESERET(66560, 66639, "Deseret"),
    SHAVIAN(66640, 66687, "Shavian"),
    OSMANYA(66688, 66735, "Osmanya"),
    ELBASAN(66816, 66863, "Elbasan"),
    CAUCASIAN_ALBANIAN(66864, 66927, "Caucasian Albanian"),
    LINEAR_A(67072, 67455, "Linear A"),
    CYPRIOT_SYLLAB(67584, 67647, "Cypriot Syllabary"),
    PALMYRENE(67680, 67711, "Palmyrene"),
    NABATAEAN(67712, 67759, "Nabataean"),
    PHOENICIAN(67840, 67871, "Phoenician"),
    OLD_NORTH_ARABIAN(68224, 68255, "Old North Arabian"),
    MANICHAEAN(68288, 68351, "Manichaean"),
    PSALTER_PAHLAVI(68480, 68527, "Psalter Pahlavi"),
    BRHAMI(69632, 69759, "Brahmi"),
    MAHAJANI(69968, 70015, "Mahajani"),
    SINHALA_ARCHAIC_NUMS(70112, 70143, "Sinhala Archaic Numbers"),
    KHOJKI(70144, 70223, "Khojki"),
    KHUDAWADI(70320, 70399, "Khudawadi"),
    GRANTHA(70400, 70527, "Grantha"),
    TIRHUTA(70784, 70879, "Tirhuta"),
    SIDDHAM(71040, 71167, "Siddham"),
    MODI(71168, 71263, "Modi"),
    WARANG_CITI(71840, 71935, "Warang Citi"),
    PAU_CIN_HAU(72384, 72447, "Pau Cin Hau"),
    CUNEIFORM(73728, 73983, "Cuneiform"),
    BAMUM_SUPP(92160, 92351, "Bamum Supplement"),
    MRO(92736, 92783, "Mro"),
    BASSA_VAH(92880, 92927, "Bassa Vah"),
    PAHAWH_HMONG(92928, 93071, "Pahawh Hmong"),
    KANA_SUPP(110592, 110847, "Kana Supplement"),
    DUPLOYAN(113664, 113823, "Duployan"),
    SHORTHAND_FORMAT_CTRLS(113824, 113839, "Shorthand Format Controls"),
    BYZANT_MUSIC_SYMS(118784, 119039, "Byzantine Musical Symbols"),
    MUSIC_SYMS(119040, 119295, "Musical Symbols"),
    COUNT_ROD_NUMS(119648, 119679, "Counting Rod Numerals"),
    MATHS_ALPAHNUM_SYMS(119808, 120831, "Mathematical Alphanumeric Symbols"),
    MENDE_KIKAKUI(124928, 125151, "Mende Kikakui"),
    PLAYING_CARDS(127136, 127231, "Playing Cards"),
    MISC_SUMS_PICTOGRPHS(127744, 127999, "Miscellaneous Symbols and Pictographs"),
    EMOTICONS(128512, 128591, "Emoticons"),
    ORNAMENTAL_DINGBATS(128592, 128639, "Ornamental Dingbats"),
    TRANSPORT_MAPS_SYMS(128640, 128767, "Transport and Map Symbols"),
    ALCHEMICAL_SYMS(128768, 128895, "Alchemical Symbols"),
    GEOM_SHAPES_EXT(128896, 129023, "Geometric Shapes Extended"),
    SUPP_ARROWS_C(129024, 129279, "Supplemental Arrows-C"),
    CJK_UNIFIED_IDEOGRAPHS_EXT_B(131072, 173791, "CJK Unified Ideographs Extension B"),
    CJK_UNIFIED_IDEOGRAPHS_EXT_D(177984, 178063, "CJK Unified Ideographs Extension D"),
    CJK_COMPAT_IDEOGRAPH_EXT(194560, 195103, "CJK Compatibility Ideographs Supplement"),
    TAGS(917504, 917631, "Tags"),
    VAR_SELS_SUPP(917760, 917999, "Variation Selectors Supplement"),
    SUPP_PRIV_USE_A(983040, 1048575, "Supplementary Private Use Area-A"),
    SUPP_PRIV_USE_b(0x100000, 0x10FFFF, "Supplementary Private Use Area-B");

    public final int end;
    public final String name;
    public final int start;

    private Utf8Block(int start, int end, String name) {
        this.start = start;
        this.end = end;
        this.name = name;
    }

    public static Utf8Block blockFromInt(int code) {
        for (Utf8Block block : Utf8Block.values()) {
            if (block.start > code || block.end < code) continue;
            return block;
        }
        return null;
    }
}

