/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessages;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.wave.AssocDataListChunk;
import edu.harvard.hul.ois.jhove.module.wave.BroadcastExtChunk;
import edu.harvard.hul.ois.jhove.module.wave.CartChunk;
import edu.harvard.hul.ois.jhove.module.wave.CueChunk;
import edu.harvard.hul.ois.jhove.module.wave.DataChunk;
import edu.harvard.hul.ois.jhove.module.wave.DataSize64Chunk;
import edu.harvard.hul.ois.jhove.module.wave.ExifInfo;
import edu.harvard.hul.ois.jhove.module.wave.FactChunk;
import edu.harvard.hul.ois.jhove.module.wave.FormatChunk;
import edu.harvard.hul.ois.jhove.module.wave.InstrumentChunk;
import edu.harvard.hul.ois.jhove.module.wave.LabelChunk;
import edu.harvard.hul.ois.jhove.module.wave.LinkChunk;
import edu.harvard.hul.ois.jhove.module.wave.ListInfoChunk;
import edu.harvard.hul.ois.jhove.module.wave.MessageConstants;
import edu.harvard.hul.ois.jhove.module.wave.MpegChunk;
import edu.harvard.hul.ois.jhove.module.wave.NoteChunk;
import edu.harvard.hul.ois.jhove.module.wave.PeakEnvelopeChunk;
import edu.harvard.hul.ois.jhove.module.wave.SampleChunk;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WaveModule
extends ModuleBase {
    private static final String NAME = "WAVE-hul";
    private static final String RELEASE = "1.8.1";
    private static final int[] DATE = new int[]{2019, 12, 10};
    private static final String[] FORMATS = new String[]{"WAVE", "Audio for Windows", "EBU Technical Specification 3285", "Broadcast Wave Format", "BWF", "EBU Technical Specification 3306", "RF64"};
    private static final String COVERAGE = "WAVE (PCMWAVEFORMAT, WAVEFORMATEX, WAVEFORMATEXTENSIBLE); Broadcast Wave Format (BWF) version 0, 1 and 2; RF64";
    private static final String[] MIMETYPES = new String[]{"audio/vnd.wave", "audio/wav", "audio/wave", "audio/x-wav", "audio/x-wave"};
    private static final String WELLFORMED = null;
    private static final String VALIDITY = null;
    private static final String REPINFO = null;
    private static final String NOTE = "There is no published standard for WAVE files. This module regards a file as valid if it conforms to common usage practices.";
    private static final String RIGHTS = "Copyright 2004-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";
    private static final String RIFF_SIGNATURE = "RIFF";
    private static final String RF64_SIGNATURE = "RF64";
    private static final int RIFF_FORM_TYPE_LENGTH = 4;
    public static final long LOOKUP_EXTENDED_DATA_SIZE = 0xFFFFFFFFL;
    protected Map<String, Long> extendedChunkSizes;
    protected Property _metadata;
    protected List<Property> _propList;
    protected List<Property> _notes;
    protected List<Property> _labels;
    protected List<Property> _labeledText;
    protected List<Property> _samples;
    protected AESAudioMetadata _aesMetadata;
    protected long riffSize;
    protected int _blockAlign;
    protected ExifInfo _exifInfo;
    protected int waveCodec;
    protected long extendedRiffSize;
    protected long extendedSampleLength;
    protected long sampleCount;
    protected long sampleRate;
    protected boolean formatChunkSeen;
    protected boolean factChunkSeen;
    protected boolean dataChunkSeen;
    protected boolean dataSize64ChunkSeen;
    protected boolean instrumentChunkSeen;
    protected boolean mpegChunkSeen;
    protected boolean cartChunkSeen;
    protected boolean broadcastExtChunkSeen;
    protected boolean peakChunkSeen;
    protected boolean linkChunkSeen;
    protected boolean cueChunkSeen;
    protected boolean flagPCMWaveFormat;
    protected boolean flagWaveFormatEx;
    protected boolean flagWaveFormatExtensible;
    protected boolean flagRF64;
    protected boolean firstSampleOffsetMarked;

    public WaveModule() {
        super(NAME, RELEASE, DATE, FORMATS, COVERAGE, MIMETYPES, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, false);
        this._vendor = Agent.harvardInstance();
        Agent msAgent = new Agent.Builder("Microsoft Corporation", AgentType.COMMERCIAL).address("One Microsoft Way, Redmond, WA 98052-6399").telephone("+1 (800) 426-9400").web("http://www.microsoft.com").build();
        Document doc = new Document("PCMWAVEFORMAT", DocumentType.WEB);
        doc.setIdentifier(new Identifier("http://msdn.microsoft.com/library/default.asp?url=/library/en-us/multimed/htm/_win32_pcmwaveformat_str.asp", IdentifierType.URL));
        doc.setPublisher(msAgent);
        this._specification.add(doc);
        doc = new Document("WAVEFORMATEX", DocumentType.WEB);
        doc.setIdentifier(new Identifier("http://msdn.microsoft.com/library/default.asp?url=/library/en-us/multimed/htm/_win32_waveformatex_str.asp", IdentifierType.URL));
        doc.setPublisher(msAgent);
        this._specification.add(doc);
        doc = new Document("WAVEFORMATEXTENSIBLE", DocumentType.WEB);
        doc.setIdentifier(new Identifier("http://msdn.microsoft.com/library/default.asp?url=/library/en-us/multimed/htm/_win32_waveformatextensible_str.asp", IdentifierType.URL));
        doc.setPublisher(msAgent);
        this._specification.add(doc);
        Agent ebuAgent = new Agent.Builder("European Broadcasting Union", AgentType.COMMERCIAL).address("Casa postale 45, Ancienne Route 17A, CH-1218 Grand-Saconex, Geneva, Switzerland").telephone("+41 (0)22 717 2111").fax("+41 (0)22 747 4000").email("techreview@ebu.ch").web("http://www.ebu.ch").build();
        doc = new Document("Specification of the Broadcast Wave Format (BWF)", DocumentType.REPORT);
        doc.setIdentifier(new Identifier("EBU Technical Specification 3285", IdentifierType.OTHER));
        doc.setIdentifier(new Identifier("https://tech.ebu.ch/docs/tech/tech3285.pdf", IdentifierType.URL));
        doc.setPublisher(ebuAgent);
        doc.setDate("2011-05");
        this._specification.add(doc);
        doc = new Document("MBWF / RF64: An Extended File Format for Audio", DocumentType.REPORT);
        doc.setIdentifier(new Identifier("EBU Technical Specification 3306", IdentifierType.OTHER));
        doc.setIdentifier(new Identifier("https://tech.ebu.ch/docs/tech/tech3306-2009.pdf", IdentifierType.URL));
        doc.setPublisher(ebuAgent);
        doc.setDate("2009-07");
        this._specification.add(doc);
        Agent ietfAgent = new Agent.Builder("IETF", AgentType.STANDARD).web("https://www.ietf.org").build();
        doc = new Document("WAVE and AVI Codec Registries", DocumentType.RFC);
        doc.setPublisher(ietfAgent);
        doc.setDate("1998-06");
        doc.setIdentifier(new Identifier("RFC 2361", IdentifierType.RFC));
        doc.setIdentifier(new Identifier("https://www.ietf.org/rfc/rfc2361.txt", IdentifierType.URL));
        this._specification.add(doc);
        ExternalSignature sig = new ExternalSignature(".wav", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(sig);
        sig = new ExternalSignature(".bwf", SignatureType.EXTENSION, SignatureUseType.OPTIONAL, "For BWF profile");
        this._signature.add(sig);
        sig = new ExternalSignature(".rf64", SignatureType.EXTENSION, SignatureUseType.OPTIONAL, "For RF64 profile");
        this._signature.add(sig);
        sig = new InternalSignature(RIFF_SIGNATURE, SignatureType.MAGIC, SignatureUseType.MANDATORY_IF_APPLICABLE, 0);
        this._signature.add(sig);
        sig = new InternalSignature(RF64_SIGNATURE, SignatureType.MAGIC, SignatureUseType.MANDATORY_IF_APPLICABLE, 0);
        this._signature.add(sig);
        sig = new InternalSignature("WAVE", SignatureType.MAGIC, SignatureUseType.MANDATORY, 8);
        this._signature.add(sig);
        this._bigEndian = false;
    }

    public int parse(InputStream stream, RepInfo info, int parseIndex) {
        this.initParse();
        info.setModule((Module)this);
        this._aesMetadata.setPrimaryIdentifier(info.getUri());
        if (info.getURLFlag()) {
            this._aesMetadata.setOtherPrimaryIdentifierType("URI");
        } else {
            this._aesMetadata.setPrimaryIdentifierType("FILE_NAME");
        }
        this.setupDataStream(stream, info);
        try {
            String firstFourChars = this.read4Chars(this._dstream);
            if (firstFourChars.equals(RF64_SIGNATURE)) {
                info.setProfile(RF64_SIGNATURE);
                this.flagRF64 = true;
            } else if (!firstFourChars.equals(RIFF_SIGNATURE)) {
                info.setMessage((Message)new ErrorMessage(MessageConstants.WAVE_HUL_1, 0L));
                info.setWellFormed(false);
                return 0;
            }
            this.riffSize = this.readUnsignedInt(this._dstream);
            String formType = this.read4Chars(this._dstream);
            if (!"WAVE".equals(formType)) {
                info.setMessage((Message)new ErrorMessage(MessageConstants.WAVE_HUL_2, this._nByte - 4L));
                info.setWellFormed(false);
                return 0;
            }
            info.setSigMatch(this._name);
            info.setFormat(this._format[0]);
            info.setMimeType(this._mimeType[0]);
            if (this.flagRF64) {
                if (this.readChunk(info) && this.dataSize64ChunkSeen) {
                    if (this.riffSize == 0xFFFFFFFFL && Long.compareUnsigned(this.extendedRiffSize, Long.MAX_VALUE) > 0) {
                        info.setMessage((Message)new InfoMessage(MessageConstants.WAVE_HUL_22));
                        info.setWellFormed(-1);
                        return 0;
                    }
                } else {
                    info.setMessage((Message)new ErrorMessage(MessageConstants.WAVE_HUL_23, 12L));
                    info.setWellFormed(false);
                    return 0;
                }
            }
            while (this.getBytesRemaining() > 0L && this.readChunk(info)) {
            }
            if (this.getBytesRemaining() > 0L) {
                this.remainingDataInfo(this._dstream, info, this.getBytesRemaining(), firstFourChars);
            }
        }
        catch (EOFException eofe) {
            info.setWellFormed(false);
            String subMessage = String.format(MessageConstants.WAVE_HUL_3_SUB.getMessage(), this.getBytesRemaining());
            if (eofe.getMessage() != null) {
                subMessage = subMessage + "; " + eofe.getMessage();
            }
            info.setMessage((Message)new ErrorMessage(MessageConstants.WAVE_HUL_3, subMessage, this._nByte));
        }
        catch (Exception e) {
            e.printStackTrace();
            info.setWellFormed(false);
            JhoveMessage message = JhoveMessages.getMessageInstance((String)MessageConstants.WAVE_HUL_4.getId(), (String)String.format(MessageConstants.WAVE_HUL_4.getMessage(), e.getClass().getName() + ", " + e.getMessage()));
            info.setMessage((Message)new ErrorMessage(message, this._nByte));
            return 0;
        }
        if (this.sampleCount > 0L) {
            this._aesMetadata.setDuration(this.sampleCount);
        }
        if (!this._labels.isEmpty()) {
            this._propList.add(new Property("Labels", PropertyType.PROPERTY, PropertyArity.LIST, this._labels));
        }
        if (!this._labeledText.isEmpty()) {
            this._propList.add(new Property("LabeledText", PropertyType.PROPERTY, PropertyArity.LIST, this._labeledText));
        }
        if (!this._notes.isEmpty()) {
            this._propList.add(new Property("Notes", PropertyType.PROPERTY, PropertyArity.LIST, this._notes));
        }
        if (!this._samples.isEmpty()) {
            this._propList.add(new Property("Samples", PropertyType.PROPERTY, PropertyArity.LIST, this._samples));
        }
        if (this._exifInfo != null) {
            this._propList.add(this._exifInfo.buildProperty());
        }
        if (!this.formatChunkSeen) {
            info.setMessage((Message)new ErrorMessage(MessageConstants.WAVE_HUL_5));
            info.setWellFormed(false);
            return 0;
        }
        if (!this.dataChunkSeen) {
            info.setMessage((Message)new ErrorMessage(MessageConstants.WAVE_HUL_24));
            info.setWellFormed(false);
            return 0;
        }
        if (this._ckSummer != null) {
            this.skipDstreamToEnd(info);
            WaveModule.setChecksums((Checksummer)this._ckSummer, (RepInfo)info);
        }
        info.setProperty(this._metadata);
        if (this.flagPCMWaveFormat) {
            info.setProfile("PCMWAVEFORMAT");
        }
        if (this.flagWaveFormatEx) {
            info.setProfile("WAVEFORMATEX");
        }
        if (this.flagWaveFormatExtensible) {
            info.setProfile("WAVEFORMATEXTENSIBLE");
        }
        if (this.broadcastExtChunkSeen && (this.waveCodec == 80 && this.factChunkSeen || this.waveCodec == 1)) {
            info.setProfile("BWF");
        }
        return 0;
    }

    public void markFirstSampleOffset() {
        if (!this.firstSampleOffsetMarked) {
            this.firstSampleOffsetMarked = true;
            this._aesMetadata.setFirstSampleOffset(this._nByte);
        }
    }

    public void setExifInfo(ExifInfo exifInfo) {
        this._exifInfo = exifInfo;
    }

    public void setBlockAlign(int align) {
        this._blockAlign = align;
    }

    public ExifInfo getExifInfo() {
        return this._exifInfo;
    }

    public int getWaveCodec() {
        return this.waveCodec;
    }

    public int getBlockAlign() {
        return this._blockAlign;
    }

    public void addWaveProperty(Property prop) {
        this._propList.add(prop);
    }

    public void addLabel(Property p) {
        this._labels.add(p);
    }

    public void addLabeledText(Property p) {
        this._labeledText.add(p);
    }

    public void addSample(Property p) {
        this._samples.add(p);
    }

    public void addNote(Property p) {
        this._notes.add(p);
    }

    public void addListInfo(List l) {
        this._propList.add(new Property("ListInfo", PropertyType.PROPERTY, PropertyArity.LIST, (Object)l));
    }

    public long readSignedLong(DataInputStream stream) throws IOException {
        return WaveModule.readSignedLong((DataInputStream)stream, (boolean)false, (ModuleBase)this);
    }

    public long readUnsignedInt(DataInputStream stream) throws IOException {
        return WaveModule.readUnsignedInt((DataInputStream)stream, (boolean)false, (ModuleBase)this);
    }

    public int readSignedInt(DataInputStream stream) throws IOException {
        return WaveModule.readSignedInt((DataInputStream)stream, (boolean)false, (ModuleBase)this);
    }

    public int readUnsignedShort(DataInputStream stream) throws IOException {
        return WaveModule.readUnsignedShort((DataInputStream)stream, (boolean)false, (ModuleBase)this);
    }

    public int readSignedShort(DataInputStream stream) throws IOException {
        return WaveModule.readSignedShort((DataInputStream)stream, (boolean)false, (ModuleBase)this);
    }

    public String read4Chars(DataInputStream stream) throws IOException {
        StringBuilder sb = new StringBuilder(4);
        for (int i = 0; i < 4; ++i) {
            int ch = WaveModule.readUnsignedByte((DataInputStream)stream, (ModuleBase)this);
            if (ch == 0) continue;
            sb.append((char)ch);
        }
        return sb.toString();
    }

    public void setWaveCodec(int value) {
        this.waveCodec = value;
    }

    public void addSamples(long samples) {
        this.sampleCount += samples;
    }

    public void setSampleRate(long rate) {
        this.sampleRate = rate;
    }

    public void setPCMWaveFormat(boolean b) {
        this.flagPCMWaveFormat = b;
    }

    public void setWaveFormatEx(boolean b) {
        this.flagWaveFormatEx = b;
    }

    public void setWaveFormatExtensible(boolean b) {
        this.flagWaveFormatExtensible = b;
    }

    protected void initParse() {
        super.initParse();
        this._propList = new LinkedList<Property>();
        this._notes = new LinkedList<Property>();
        this._labels = new LinkedList<Property>();
        this._labeledText = new LinkedList<Property>();
        this._samples = new LinkedList<Property>();
        this.firstSampleOffsetMarked = false;
        this.waveCodec = -1;
        this.sampleCount = 0L;
        this.riffSize = 0L;
        this.extendedRiffSize = 0L;
        this.extendedSampleLength = 0L;
        this.extendedChunkSizes = new HashMap<String, Long>();
        this._metadata = new Property("WAVEMetadata", PropertyType.PROPERTY, PropertyArity.LIST, this._propList);
        this._aesMetadata = new AESAudioMetadata();
        this._aesMetadata.setByteOrder(1);
        this._aesMetadata.setAnalogDigitalFlag("FILE_DIGITAL");
        this._aesMetadata.setFormat("WAVE");
        this._aesMetadata.setUse("OTHER", "JHOVE_validation");
        this._aesMetadata.setDirection("NONE");
        this._propList.add(new Property("AESAudioMetadata", PropertyType.AESAUDIOMETADATA, (Object)this._aesMetadata));
        this.formatChunkSeen = false;
        this.dataChunkSeen = false;
        this.dataSize64ChunkSeen = false;
        this.instrumentChunkSeen = false;
        this.cartChunkSeen = false;
        this.mpegChunkSeen = false;
        this.broadcastExtChunkSeen = false;
        this.peakChunkSeen = false;
        this.linkChunkSeen = false;
        this.cueChunkSeen = false;
        this.flagPCMWaveFormat = false;
        this.flagWaveFormatEx = false;
        this.flagWaveFormatExtensible = false;
        this.flagRF64 = false;
    }

    protected boolean readChunk(RepInfo info) throws IOException {
        Long extendedSize;
        Object chunk = null;
        ChunkHeader chunkh = new ChunkHeader((ModuleBase)this, info);
        if (!chunkh.readHeader(this._dstream)) {
            return false;
        }
        String chunkId = chunkh.getID();
        long chunkSize = chunkh.getSize();
        if (this.hasExtendedDataSizes() && chunkSize == 0xFFFFFFFFL && (extendedSize = this.extendedChunkSizes.get(chunkId)) != null) {
            chunkh.setSize(extendedSize.longValue());
            chunkSize = extendedSize;
        }
        if (Long.compareUnsigned(this.getBytesRemaining(), chunkSize) < 0) {
            info.setMessage((Message)new ErrorMessage(MessageConstants.WAVE_HUL_6, this._nByte - 4L));
            info.setWellFormed(false);
            return false;
        }
        if ("fmt ".equals(chunkId)) {
            if (this.formatChunkSeen) {
                this.dupChunkError(info, "Format");
            }
            chunk = new FormatChunk(this, chunkh, this._dstream);
            this.formatChunkSeen = true;
        } else if ("data".equals(chunkId)) {
            if (!this.formatChunkSeen) {
                info.setMessage((Message)new ErrorMessage(MessageConstants.WAVE_HUL_25, chunkh.getOffset()));
                info.setValid(false);
            }
            if (this.dataChunkSeen) {
                this.dupChunkError(info, "Data");
            }
            chunk = new DataChunk(this, chunkh, this._dstream);
            this.dataChunkSeen = true;
        } else if ("ds64".equals(chunkId)) {
            chunk = new DataSize64Chunk(this, chunkh, this._dstream);
            this.dataSize64ChunkSeen = true;
        } else if ("fact".equals(chunkId)) {
            chunk = new FactChunk(this, chunkh, this._dstream);
            this.factChunkSeen = true;
        } else if ("note".equals(chunkId)) {
            chunk = new NoteChunk(this, chunkh, this._dstream);
        } else if ("labl".equals(chunkId)) {
            chunk = new LabelChunk(this, chunkh, this._dstream);
        } else if ("list".equals(chunkId)) {
            chunk = new AssocDataListChunk(this, chunkh, this._dstream, info);
        } else if ("LIST".equals(chunkId)) {
            chunk = new ListInfoChunk(this, chunkh, this._dstream, info);
        } else if ("smpl".equals(chunkId)) {
            chunk = new SampleChunk(this, chunkh, this._dstream);
        } else if ("inst".equals(chunkId)) {
            if (this.instrumentChunkSeen) {
                this.dupChunkError(info, "Instrument");
            }
            chunk = new InstrumentChunk(this, chunkh, this._dstream);
            this.instrumentChunkSeen = true;
        } else if ("mext".equals(chunkId)) {
            if (this.mpegChunkSeen) {
                this.dupChunkError(info, "MPEG Audio Extension");
            }
            chunk = new MpegChunk(this, chunkh, this._dstream);
            this.mpegChunkSeen = true;
        } else if ("cart".equals(chunkId)) {
            if (this.cartChunkSeen) {
                this.dupChunkError(info, "Cart");
            }
            chunk = new CartChunk(this, chunkh, this._dstream);
            this.cartChunkSeen = true;
        } else if ("bext".equals(chunkId)) {
            if (this.broadcastExtChunkSeen) {
                this.dupChunkError(info, "Broadcast Audio Extension");
            }
            chunk = new BroadcastExtChunk(this, chunkh, this._dstream);
            this.broadcastExtChunkSeen = true;
        } else if ("levl".equals(chunkId)) {
            if (this.peakChunkSeen) {
                this.dupChunkError(info, "Peak Envelope");
            }
            chunk = new PeakEnvelopeChunk(this, chunkh, this._dstream);
            this.peakChunkSeen = true;
        } else if ("link".equals(chunkId)) {
            if (this.linkChunkSeen) {
                this.dupChunkError(info, "Link");
            }
            chunk = new LinkChunk(this, chunkh, this._dstream);
            this.linkChunkSeen = true;
        } else if ("cue ".equals(chunkId)) {
            if (this.cueChunkSeen) {
                this.dupChunkError(info, "Cue Points");
            }
            chunk = new CueChunk(this, chunkh, this._dstream);
            this.cueChunkSeen = true;
        } else {
            JhoveMessage message = JhoveMessages.getMessageInstance((String)MessageConstants.WAVE_HUL_7.getId(), (String)String.format(MessageConstants.WAVE_HUL_7.getMessage(), chunkId));
            info.setMessage((Message)new InfoMessage(message, chunkh.getOffset()));
        }
        long dataRead = this._nByte;
        if (chunk != null) {
            if (!chunk.readChunk(info)) {
                return false;
            }
        } else {
            this.skipBytes(this._dstream, chunkSize, this);
        }
        if ((dataRead = this._nByte - dataRead) < chunkSize) {
            this.remainingDataInfo(this._dstream, info, chunkSize - dataRead, chunkId);
        }
        if ((chunkSize & 1L) != 0L) {
            this.skipBytes(this._dstream, 1L, this);
        }
        return true;
    }

    private void remainingDataInfo(DataInputStream stream, RepInfo info, long bytesToProcess, String chunkId) throws IOException {
        long bytesProcessed;
        boolean nullData;
        if (stream.available() > 0) {
            nullData = true;
            for (bytesProcessed = 0L; nullData && bytesProcessed < bytesToProcess; ++bytesProcessed) {
                int b = WaveModule.readUnsignedByte((DataInputStream)stream, (ModuleBase)this);
                if (b == 0) continue;
                nullData = false;
            }
            bytesProcessed += this.skipBytes(stream, bytesToProcess - bytesProcessed, this);
        } else {
            throw new EOFException(String.format(MessageConstants.WAVE_HUL_3_SUB_2.getMessage(), chunkId));
        }
        info.setMessage((Message)new InfoMessage(MessageConstants.WAVE_HUL_26, String.format(MessageConstants.WAVE_HUL_26_SUB.getMessage(), chunkId, bytesProcessed, nullData), this._nByte - bytesProcessed));
    }

    private long getBytesRemaining() {
        long totalBytes = 8L;
        totalBytes = this.hasExtendedDataSizes() ? (totalBytes += this.extendedRiffSize) : (totalBytes += this.riffSize);
        return totalBytes - this._nByte;
    }

    public AESAudioMetadata getAESMetadata() {
        return this._aesMetadata;
    }

    protected void dupChunkError(RepInfo info, String chunkName) {
        JhoveMessage message = JhoveMessages.getMessageInstance((String)MessageConstants.WAVE_HUL_8.getId(), (String)String.format(MessageConstants.WAVE_HUL_8.getMessage(), chunkName));
        info.setMessage((Message)new ErrorMessage(message, this._nByte - 8L));
        info.setValid(false);
    }

    public Property buildBitmaskProperty(int val, String name, String[] oneValueNames, String[] zeroValueNames) {
        if (this._je != null && this._je.getShowRawFlag()) {
            return new Property(name, PropertyType.INTEGER, (Object)val);
        }
        LinkedList<String> slist = new LinkedList<String>();
        try {
            for (int i = 0; i < oneValueNames.length; ++i) {
                String s = (val & 1 << i) != 0 ? oneValueNames[i] : zeroValueNames[i];
                if (s == null || s.length() <= 0) continue;
                slist.add(s);
            }
        }
        catch (Exception e) {
            return null;
        }
        return new Property(name, PropertyType.STRING, PropertyArity.LIST, slist);
    }

    public boolean hasExtendedDataSizes() {
        return this.flagRF64 && this.dataSize64ChunkSeen;
    }

    public void setExtendedRiffSize(long size) {
        this.extendedRiffSize = size;
    }

    public void setExtendedSampleLength(long length) {
        this.extendedSampleLength = length;
    }

    public long getExtendedSampleLength() {
        return this.extendedSampleLength;
    }

    public void addExtendedChunkSize(String chunkId, Long chunkSize) {
        this.extendedChunkSizes.put(chunkId, chunkSize);
    }
}

