/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.wave.ExifInfo;
import java.io.DataInputStream;
import java.io.IOException;

public class ExifStringChunk
extends Chunk {
    private String id;

    public ExifStringChunk(ModuleBase module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
        this.id = hdr.getID();
    }

    public boolean readChunk(RepInfo info) throws IOException {
        WaveModule module = (WaveModule)this._module;
        byte[] buf = new byte[(int)this.bytesLeft];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf, (ModuleBase)module);
        String txt = new String(buf).trim();
        ExifInfo exif = module.getExifInfo();
        if ("erel".equals(this.id)) {
            exif.setRelatedImageFile(txt);
        } else if ("etim".equals(this.id)) {
            exif.setTimeCreated(txt);
        } else if ("ecor".equals(this.id)) {
            exif.setManufacturer(txt);
        } else if ("emdl".equals(this.id)) {
            exif.setModel(txt);
        }
        module.getExifInfo().setRelatedImageFile(txt);
        return true;
    }
}

