/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.wave.MessageConstants;
import java.io.DataInputStream;
import java.io.IOException;

public class ExifUserCommentChunk
extends Chunk {
    private static final String asciiDes = "ASCII";
    private static final String jisDes = "JIS";
    private static final String unicodeDes = "UNICODE";

    public ExifUserCommentChunk(ModuleBase module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    public boolean readChunk(RepInfo info) throws IOException {
        WaveModule module = (WaveModule)this._module;
        if (this.bytesLeft < 8L) {
            info.setMessage((Message)new ErrorMessage(MessageConstants.WAVE_HUL_11));
            info.setWellFormed(false);
            return false;
        }
        byte[] buf = new byte[8];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf, (ModuleBase)module);
        String encoding = new String(buf).trim();
        this.bytesLeft -= 8L;
        String charset = null;
        if (asciiDes.equals(encoding)) {
            charset = "US-ASCII";
        } else if (jisDes.equals(encoding)) {
            charset = "EUC_JP";
        } else if (unicodeDes.equals(encoding)) {
            charset = "UTF-16";
        }
        buf = new byte[(int)this.bytesLeft];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf, (ModuleBase)module);
        String text = null;
        try {
            if (charset != null) {
                text = new String(buf, charset);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (text == null) {
            text = new String(buf);
        }
        module.getExifInfo().setUserComment(text);
        return true;
    }
}

