/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.wave.WaveStrings;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;

public class FormatChunk
extends Chunk {
    public static final int WAVE_FORMAT_PCM = 1;
    public static final int WAVE_FORMAT_MPEG = 80;
    public static final int WAVE_FORMAT_EXTENSIBLE = 65534;
    private static final int PCMWAVEFORMAT_LENGTH = 16;
    private static final int EXTRA_WAVEFORMATEXTENSIBLE_LENGTH = 22;
    private static final String FORMAT_TAG_GUID_SUFFIX = "-0000-0010-8000-00AA00389B71";
    private static final int[] losslessCodecs = new int[]{355, 6513, 61868};

    public FormatChunk(WaveModule module, ChunkHeader hdr, DataInputStream dstrm) {
        super((ModuleBase)module, hdr, dstrm);
    }

    public boolean readChunk(RepInfo info) throws IOException {
        WaveModule module = (WaveModule)this._module;
        int validBitsPerSample = -1;
        byte[] extraBytes = null;
        String subformat = null;
        long channelMask = -1L;
        int waveCodec = module.readUnsignedShort(this._dstream);
        module.setWaveCodec(waveCodec);
        int numChannels = module.readUnsignedShort(this._dstream);
        long sampleRate = module.readUnsignedInt(this._dstream);
        module.setSampleRate(sampleRate);
        long bytesPerSecond = module.readUnsignedInt(this._dstream);
        int blockAlign = module.readUnsignedShort(this._dstream);
        module.setBlockAlign(blockAlign);
        int bitsPerSample = module.readUnsignedShort(this._dstream);
        this.bytesLeft -= 16L;
        if (this.bytesLeft > 0L) {
            int extraFormatBytes = module.readUnsignedShort(this._dstream);
            extraBytes = new byte[extraFormatBytes];
            if (waveCodec == 65534 && extraFormatBytes >= 22) {
                boolean wfe = true;
                validBitsPerSample = module.readUnsignedShort(this._dstream);
                channelMask = module.readUnsignedInt(this._dstream);
                byte[] guidBytes = new byte[16];
                ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])guidBytes, (ModuleBase)module);
                subformat = FormatChunk.formatGUID(guidBytes);
                if (subformat.endsWith(FORMAT_TAG_GUID_SUFFIX)) {
                    waveCodec = Integer.parseInt(subformat.substring(4, 8), 16);
                    module.setWaveCodec(waveCodec);
                }
                if ((bitsPerSample + 7) / 8 * numChannels != blockAlign) {
                    wfe = false;
                }
                if (bitsPerSample % 8 != 0) {
                    wfe = false;
                }
                if (validBitsPerSample > bitsPerSample) {
                    wfe = false;
                }
                if (wfe) {
                    module.setWaveFormatExtensible(true);
                }
            } else {
                if (waveCodec != 1 || (bitsPerSample + 7) / 8 * numChannels == blockAlign) {
                    module.setWaveFormatEx(true);
                }
                ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])extraBytes, (ModuleBase)module);
            }
            if ((extraFormatBytes & 1) != 0) {
                this._module.skipBytes(this._dstream, 1L, (ModuleBase)module);
            }
        } else if (waveCodec == 1 && (bitsPerSample + 7) / 8 * numChannels == blockAlign) {
            module.setPCMWaveFormat(true);
        }
        if (waveCodec != 65534) {
            String codecID = Integer.toHexString(waveCodec).toUpperCase();
            String extendedMIMEType = this._module.getMimeType()[0] + "; codec=" + codecID;
            info.setMimeType(extendedMIMEType);
        }
        Property prop = module.addIntegerProperty("CompressionCode", waveCodec, WaveStrings.COMPRESSION_FORMAT, WaveStrings.COMPRESSION_INDEX);
        module.addWaveProperty(prop);
        String compName = (String)prop.getValue();
        AESAudioMetadata aes = module.getAESMetadata();
        aes.setAudioDataEncoding(compName);
        aes.setNumChannels(numChannels);
        FormatChunk.setChannelLocations(aes, numChannels);
        aes.setSampleRate((double)sampleRate);
        aes.setBitDepth(bitsPerSample);
        String qual = "LOSSY";
        for (int losslessCodec : losslessCodecs) {
            if (waveCodec != losslessCodec) continue;
            qual = "CODE_REGENERATING";
        }
        if (waveCodec == 1) {
            aes.clearBitrateReduction();
        } else {
            aes.setBitrateReduction(compName, "", "", "", qual, Long.toString(bytesPerSecond), "FIXED");
        }
        module.addWaveProperty(new Property("AverageBytesPerSecond", PropertyType.LONG, (Object)bytesPerSecond));
        module.addWaveProperty(new Property("BlockAlign", PropertyType.INTEGER, (Object)blockAlign));
        if (extraBytes != null) {
            module.addWaveProperty(new Property("ExtraFormatBytes", PropertyType.BYTE, PropertyArity.ARRAY, (Object)extraBytes));
        }
        if (validBitsPerSample != -1) {
            module.addWaveProperty(new Property("ValidBitsPerSample", PropertyType.INTEGER, (Object)validBitsPerSample));
        }
        if (channelMask != -1L) {
            module.addWaveProperty(new Property("ChannelMask", PropertyType.LONG, (Object)channelMask));
        }
        if (subformat != null) {
            module.addWaveProperty(new Property("Subformat", PropertyType.STRING, (Object)subformat));
        }
        return true;
    }

    private static void setChannelLocations(AESAudioMetadata aes, int numChannels) {
        String[] mapLoc = new String[numChannels];
        switch (numChannels) {
            case 2: {
                mapLoc[0] = "LEFT";
                mapLoc[1] = "RIGHT";
                break;
            }
            default: {
                for (int i = 0; i < numChannels; ++i) {
                    mapLoc[i] = "UNKNOWN";
                }
            }
        }
        aes.setMapLocations(mapLoc);
    }

    private static String formatGUID(byte[] guidBytes) {
        StringBuilder guid = new StringBuilder(36);
        byte[] doubleWord = FormatChunk.reverseBytes(Arrays.copyOf(guidBytes, 4));
        guid.append(DatatypeConverter.printHexBinary((byte[])doubleWord));
        guid.append("-");
        byte[] word = FormatChunk.reverseBytes(Arrays.copyOfRange(guidBytes, 4, 6));
        guid.append(DatatypeConverter.printHexBinary((byte[])word));
        guid.append("-");
        word = FormatChunk.reverseBytes(Arrays.copyOfRange(guidBytes, 6, 8));
        guid.append(DatatypeConverter.printHexBinary((byte[])word));
        guid.append("-");
        byte[] bytes = Arrays.copyOfRange(guidBytes, 8, 10);
        guid.append(DatatypeConverter.printHexBinary((byte[])bytes));
        guid.append("-");
        bytes = Arrays.copyOfRange(guidBytes, 10, 16);
        guid.append(DatatypeConverter.printHexBinary((byte[])bytes));
        return guid.toString();
    }

    private static byte[] reverseBytes(byte[] bytes) {
        for (int i = 0; i < bytes.length / 2; ++i) {
            byte valueToSwap = bytes[i];
            bytes[i] = bytes[bytes.length - 1 - i];
            bytes[bytes.length - 1 - i] = valueToSwap;
        }
        return bytes;
    }
}

