/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.implementation_checker;

import com.easyinnova.implementation_checker.ImplementationCheckerLoader;
import com.easyinnova.implementation_checker.TiffImplementationChecker;
import com.easyinnova.implementation_checker.ValidationResult;
import com.easyinnova.implementation_checker.Validator;
import com.easyinnova.implementation_checker.model.TiffValidationObject;
import com.easyinnova.tiff.model.TiffDocument;
import com.easyinnova.tiff.reader.TiffReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ImplementationCheckerValidator {
    public Map<String, ValidationResult> check(TiffReader tr, List<String> isos) throws ParserConfigurationException, IOException, SAXException, JAXBException {
        HashMap<String, ValidationResult> validations = new HashMap<String, ValidationResult>();
        String content = this.getValidationXmlString(tr);
        for (String iso : isos) {
            Validator validation = new Validator();
            ValidationResult result = validation.validate(content, iso, false);
            validations.put(ImplementationCheckerLoader.getFileName(iso), result);
        }
        return validations;
    }

    public String getValidationXmlString(TiffReader tr) throws ParserConfigurationException, IOException, SAXException, JAXBException {
        TiffDocument td = tr.getModel();
        return this.getValidationXmlString(td);
    }

    public String getValidationXmlString(TiffDocument td) throws ParserConfigurationException, IOException, SAXException, JAXBException {
        TiffImplementationChecker tic = new TiffImplementationChecker();
        tic.setITFields(true);
        TiffValidationObject tiffValidation = tic.CreateValidationObject(td);
        return tiffValidation.getXml();
    }
}

