/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.implementation_checker.rules;

import com.easyinnova.implementation_checker.model.TiffNode;
import com.easyinnova.implementation_checker.rules.model.RuleType;
import java.io.Serializable;

public class RuleResult
implements Serializable {
    String message;
    String location = null;
    boolean ok;
    TiffNode node;
    RuleType rule;
    boolean warning = false;
    boolean info = false;
    String ruleDescription;
    boolean relaxed = false;

    public RuleResult() {
    }

    public String getRuleDescription() {
        return this.ruleDescription;
    }

    public void setRuleDescription(String ruleDescription) {
        this.ruleDescription = ruleDescription;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setWarning(boolean warning) {
        this.warning = warning;
    }

    public boolean getInfo() {
        return this.info;
    }

    public void setInfo(boolean info) {
        this.info = info;
    }

    public boolean getWarning() {
        return this.warning;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public RuleResult(boolean ok, TiffNode node, RuleType rule) {
        this.message = rule.getAssert().getValue();
        this.node = node;
        this.ok = ok;
        this.rule = rule;
    }

    public RuleResult(String message) {
        this.message = message;
        this.node = null;
        this.ok = false;
        this.rule = null;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean ok() {
        return this.ok;
    }

    public String toString() {
        return this.ok ? "OK" : "KO: " + this.message;
    }

    public void setNode(TiffNode node) {
        this.node = node;
    }

    public TiffNode getNode() {
        return this.node;
    }

    public String getContext() {
        if (this.node == null) {
            return "";
        }
        return this.node.getContext();
    }

    public String getReference() {
        if (this.rule != null && this.rule.getReferenceText() != null && this.rule.getReferenceText().length() > 0) {
            return this.rule.getReferenceText();
        }
        return null;
    }

    public String getLocation() {
        if (this.location != null) {
            return this.location;
        }
        if (this.node != null) {
            return this.node.toString();
        }
        return this.getContext();
    }

    public String getDescription() {
        return this.message;
    }

    public RuleType getRule() {
        return this.rule;
    }

    public void setRelaxed(boolean relaxed) {
        this.relaxed = relaxed;
    }

    public boolean isRelaxed() {
        return this.relaxed;
    }
}

