/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class MappedByteInputStream
extends InputStream {
    private MappedByteBuffer mb;
    private long mbsize;
    private FileChannel ch;
    private FileInputStream f;
    private String path;

    public MappedByteInputStream(File file) throws FileNotFoundException {
        this.path = file.getPath();
        this.f = new FileInputStream(file);
        this.ch = this.f.getChannel();
        try {
            this.mbsize = this.ch.size();
            this.mb = this.ch.map(FileChannel.MapMode.READ_ONLY, 0L, this.mbsize);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public MappedByteInputStream(RandomAccessFile raf) throws FileNotFoundException {
        this.path = "";
        this.ch = raf.getChannel();
        try {
            this.mbsize = this.ch.size();
            this.mb = this.ch.map(FileChannel.MapMode.READ_ONLY, 0L, this.mbsize);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public int read() throws IOException {
        int val2;
        try {
            val2 = this.mb.get();
            if (val2 < 0) {
                val2 = 256 + val2;
            }
        }
        catch (BufferUnderflowException ex) {
            val2 = -1;
        }
        return val2;
    }

    @Override
    public void close() throws IOException {
        try {
            this.ch.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.f.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closeDirectBuffer(this.mb);
    }

    private void closeDirectBuffer(MappedByteBuffer cb) {
        if (cb == null || !cb.isDirect()) {
            return;
        }
        try {
            Method cleaner = cb.getClass().getMethod("cleaner", new Class[0]);
            cleaner.setAccessible(true);
            Method clean = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
            clean.setAccessible(true);
            clean.invoke(cleaner.invoke((Object)cb, new Object[0]), new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        cb = null;
    }

    public void seek(long pos) throws IOException {
        this.mb.position((int)pos);
    }

    public long size() {
        return this.mbsize;
    }
}

