/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.io;

import com.easyinnova.tiff.model.ByteOrder;
import java.io.IOException;
import java.io.RandomAccessFile;

public class OutputBuffer {
    private int[] buffer;
    private boolean[] isByte;
    private int maxBufferSize = 1000;
    private int currentBufferSize;
    private long bufferOffset;
    ByteOrder byteOrder;
    RandomAccessFile aFile;
    int position;

    public OutputBuffer(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        this.bufferOffset = 0L;
        this.currentBufferSize = 0;
        if (this.maxBufferSize >= 0) {
            this.newBuffer(0);
        }
    }

    public RandomAccessFile getStream() {
        return this.aFile;
    }

    public void Create(String filename) throws IOException {
        this.aFile = new RandomAccessFile(filename, "rw");
    }

    public void close() {
        try {
            this.writeBuffer();
            this.aFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void seek(int offset) throws IOException {
        if ((long)offset < this.bufferOffset || (long)offset >= this.bufferOffset + (long)this.maxBufferSize) {
            this.writeBuffer();
            this.newBuffer(offset);
            this.aFile.seek(offset);
        }
        this.position = offset;
    }

    private void newBuffer(int offset) {
        if (this.maxBufferSize >= 0) {
            this.buffer = new int[this.maxBufferSize];
            this.isByte = new boolean[this.maxBufferSize];
            this.bufferOffset = offset;
            this.currentBufferSize = 0;
        }
    }

    public void writeByteCurrentPosition(byte v) throws IOException {
        int index = (int)((long)this.position - this.bufferOffset);
        if (index < this.maxBufferSize) {
            this.buffer[index] = v;
            this.isByte[index] = true;
            if (index + 1 > this.currentBufferSize) {
                this.currentBufferSize = index + 1;
            }
            if (index + 1 >= this.maxBufferSize) {
                this.writeBuffer();
                this.newBuffer(this.position + 1);
            }
        } else {
            this.aFile.write(v);
        }
        ++this.position;
    }

    public void writeIntCurrentPosition(int v) throws IOException {
        int index = (int)((long)this.position - this.bufferOffset);
        if (index < this.maxBufferSize) {
            this.buffer[index] = v;
            this.isByte[index] = false;
            if (index + 1 > this.currentBufferSize) {
                this.currentBufferSize = index + 1;
            }
            if (index + 1 >= this.maxBufferSize) {
                this.writeBuffer();
                this.newBuffer(this.position + 1);
            }
        } else {
            this.aFile.write(v);
        }
        ++this.position;
    }

    private void writeBuffer() throws IOException {
        for (int pos = 0; pos < this.currentBufferSize; ++pos) {
            if (this.isByte[pos]) {
                this.aFile.write((byte)this.buffer[pos]);
                continue;
            }
            this.aFile.write(this.buffer[pos]);
        }
    }

    public long position() throws IOException {
        return this.position;
    }
}

