/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.io;

import com.easyinnova.tiff.io.InputBuffer;
import com.easyinnova.tiff.io.TiffInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PagedInputBuffer {
    private List<InputBuffer> pages = new ArrayList<InputBuffer>();
    private int MaxPages = 5;
    private InputBuffer currentBuffer = null;
    private TiffInputStream input;

    public PagedInputBuffer(TiffInputStream input) {
        this.input = input;
    }

    private void selectPage(long offset) {
        if (this.currentBuffer == null || this.currentBuffer.seekSuccessful(offset)) {
            this.currentBuffer = null;
            for (int i = 0; i < this.pages.size() && this.currentBuffer == null; ++i) {
                if (!this.pages.get(i).seekSuccessful(offset)) continue;
                this.currentBuffer = this.pages.get(i);
            }
            if (this.currentBuffer == null) {
                if (this.pages.size() >= this.MaxPages) {
                    this.pages.remove(0);
                }
                this.pages.add(new InputBuffer(this.input));
                this.currentBuffer = this.pages.get(this.pages.size() - 1);
            }
        }
    }

    public void seek(long offset) throws IOException {
        this.selectPage(offset);
        this.currentBuffer.seek(offset);
    }

    public int read(long offset) throws IOException {
        this.selectPage(offset);
        return this.currentBuffer.read(offset);
    }

    public byte readByte(long offset) throws IOException {
        this.selectPage(offset);
        return this.currentBuffer.readByte(offset);
    }
}

