/*
 * Decompiled with CFR 0.152.
 */
package com.easyinnova.tiff.io;

import com.easyinnova.tiff.io.MappedByteInputStream;
import com.easyinnova.tiff.io.PagedInputBuffer;
import com.easyinnova.tiff.io.RandomAccessFileInputStream;
import com.easyinnova.tiff.io.TiffDataIntput;
import com.easyinnova.tiff.model.ByteOrder;
import com.easyinnova.tiff.model.types.Ascii;
import com.easyinnova.tiff.model.types.Byte;
import com.easyinnova.tiff.model.types.Double;
import com.easyinnova.tiff.model.types.Long;
import com.easyinnova.tiff.model.types.Rational;
import com.easyinnova.tiff.model.types.SByte;
import com.easyinnova.tiff.model.types.SLong;
import com.easyinnova.tiff.model.types.SRational;
import com.easyinnova.tiff.model.types.SShort;
import com.easyinnova.tiff.model.types.Short;
import com.easyinnova.tiff.model.types.Undefined;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class TiffInputStream
implements TiffDataIntput {
    private ByteOrder byteOrder;
    private long fileOffset;
    private PagedInputBuffer buffer;
    private MappedByteInputStream internalFile;
    private RandomAccessFileInputStream internalFileBig;

    public TiffInputStream(File file) throws FileNotFoundException {
        FileInputStream f = new FileInputStream(file);
        long mbsize = 0L;
        try {
            mbsize = f.getChannel().size();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.internalFile = null;
        this.internalFileBig = null;
        if (mbsize > Integer.MAX_VALUE) {
            this.internalFileBig = new RandomAccessFileInputStream(file);
        } else {
            this.internalFile = new MappedByteInputStream(file);
        }
        this.byteOrder = ByteOrder.BIG_ENDIAN;
        this.fileOffset = 0L;
        this.buffer = new PagedInputBuffer(this);
    }

    public TiffInputStream(RandomAccessFile raf) throws FileNotFoundException {
        long mbsize = 0L;
        try {
            mbsize = raf.getChannel().size();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.internalFile = null;
        this.internalFileBig = null;
        if (mbsize > Integer.MAX_VALUE) {
            this.internalFileBig = new RandomAccessFileInputStream(raf);
        } else {
            this.internalFile = new MappedByteInputStream(raf);
        }
        this.byteOrder = ByteOrder.BIG_ENDIAN;
        this.fileOffset = 0L;
        this.buffer = new PagedInputBuffer(this);
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public String getFilePath() {
        if (this.internalFile != null) {
            return this.internalFile.getPath();
        }
        return this.internalFileBig.getPath();
    }

    public int read() throws IOException {
        if (this.internalFile != null) {
            return this.internalFile.read();
        }
        return this.internalFileBig.read();
    }

    public void seek(long pos) throws IOException {
        if (this.internalFile != null) {
            this.internalFile.seek(pos);
        } else {
            this.internalFileBig.seek(pos);
        }
    }

    public void close() throws IOException {
        if (this.internalFile != null) {
            this.internalFile.close();
        } else {
            this.internalFileBig.close();
        }
    }

    public PagedInputBuffer getStream() {
        return this.buffer;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void seekOffset(long offset) throws IOException {
        this.buffer.seek(offset);
        this.fileOffset = offset;
    }

    private int readCurrentByte() throws IOException {
        int b = this.buffer.read(this.fileOffset);
        ++this.fileOffset;
        return b;
    }

    private byte readCurrentDirectByte() throws IOException {
        byte b = this.buffer.readByte(this.fileOffset);
        ++this.fileOffset;
        return b;
    }

    public Byte readByte(long position) throws IOException {
        this.seekOffset(position);
        return this.readByte();
    }

    @Override
    public Byte readByte() throws IOException {
        int ch = this.readCurrentByte();
        if (ch < 0) {
            throw new EOFException();
        }
        return new Byte(ch);
    }

    public byte readDirectByte() throws IOException {
        byte ch = this.readCurrentDirectByte();
        return ch;
    }

    public Ascii readAscii(long position) throws IOException {
        this.seekOffset(position);
        return this.readAscii();
    }

    @Override
    public Ascii readAscii() throws IOException {
        int ch = this.readCurrentByte();
        if (ch < 0) {
            throw new EOFException();
        }
        return new Ascii(ch);
    }

    public SByte readSByte(long position) throws IOException {
        this.seekOffset(position);
        return this.readSByte();
    }

    @Override
    public SByte readSByte() throws IOException {
        int ch = this.readCurrentByte();
        if (ch < 0) {
            throw new EOFException();
        }
        return new SByte(ch);
    }

    public Short readShort(long position) throws IOException {
        this.seekOffset(position);
        return this.readShort();
    }

    @Override
    public Short readShort() throws IOException {
        int ch2;
        int ch1 = this.readCurrentByte();
        if ((ch1 | (ch2 = this.readCurrentByte())) < 0) {
            throw new EOFException();
        }
        short val = this.byteOrder == ByteOrder.BIG_ENDIAN ? (short)((ch1 << 8) + ch2) : (short)((ch2 << 8) + ch1);
        return new Short(val);
    }

    public SShort readSShort(long position) throws IOException {
        this.seekOffset(position);
        return this.readSShort();
    }

    @Override
    public SShort readSShort() throws IOException {
        int ch2;
        int ch1 = this.readCurrentByte();
        if ((ch1 | (ch2 = this.readCurrentByte())) < 0) {
            throw new EOFException();
        }
        short val = this.byteOrder == ByteOrder.BIG_ENDIAN ? (short)((ch1 << 8) + ch2) : (short)((ch2 << 8) + ch1);
        return new SShort(val);
    }

    public Long readLong(long position) throws IOException {
        this.seekOffset(position);
        return this.readLong();
    }

    @Override
    public Long readLong() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.readCurrentByte();
        if ((ch1 | (ch2 = this.readCurrentByte()) | (ch3 = this.readCurrentByte()) | (ch4 = this.readCurrentByte())) < 0) {
            throw new EOFException();
        }
        int val = this.byteOrder == ByteOrder.BIG_ENDIAN ? (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4 : (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
        return new Long(val);
    }

    public SLong readSLong(long position) throws IOException {
        this.seekOffset(position);
        return this.readSLong();
    }

    @Override
    public SLong readSLong() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.readCurrentByte();
        if ((ch1 | (ch2 = this.readCurrentByte()) | (ch3 = this.readCurrentByte()) | (ch4 = this.readCurrentByte())) < 0) {
            throw new EOFException();
        }
        int val = this.byteOrder == ByteOrder.BIG_ENDIAN ? (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4 : (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
        return new SLong(val);
    }

    public Undefined readUndefined(long position) throws IOException {
        this.seekOffset(position);
        return this.readUndefined();
    }

    @Override
    public Undefined readUndefined() throws IOException {
        int ch = this.readCurrentByte();
        if (ch < 0) {
            throw new EOFException();
        }
        return new Undefined(ch);
    }

    public Rational readRational(long position) throws IOException {
        this.seekOffset(position);
        return this.readRational();
    }

    @Override
    public Rational readRational() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.readCurrentByte();
        if ((ch1 | (ch2 = this.readCurrentByte()) | (ch3 = this.readCurrentByte()) | (ch4 = this.readCurrentByte())) < 0) {
            throw new EOFException();
        }
        int val = this.byteOrder == ByteOrder.BIG_ENDIAN ? (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4 : (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
        ch1 = this.readCurrentByte();
        if ((ch1 | (ch2 = this.readCurrentByte()) | (ch3 = this.readCurrentByte()) | (ch4 = this.readCurrentByte())) < 0) {
            throw new EOFException();
        }
        int val2 = this.byteOrder == ByteOrder.BIG_ENDIAN ? (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4 : (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
        return new Rational(val, val2);
    }

    public SRational readSRational(long position) throws IOException {
        this.seekOffset(position);
        return this.readSRational();
    }

    @Override
    public SRational readSRational() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.readCurrentByte();
        if ((ch1 | (ch2 = this.readCurrentByte()) | (ch3 = this.readCurrentByte()) | (ch4 = this.readCurrentByte())) < 0) {
            throw new EOFException();
        }
        int val = this.byteOrder == ByteOrder.BIG_ENDIAN ? (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4 : (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
        ch1 = this.readCurrentByte();
        if ((ch1 | (ch2 = this.readCurrentByte()) | (ch3 = this.readCurrentByte()) | (ch4 = this.readCurrentByte())) < 0) {
            throw new EOFException();
        }
        int val2 = this.byteOrder == ByteOrder.BIG_ENDIAN ? (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4 : (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
        return new SRational(val, val2);
    }

    public com.easyinnova.tiff.model.types.Float readFloat(long position) throws IOException {
        this.seekOffset(position);
        return this.readFloat();
    }

    @Override
    public com.easyinnova.tiff.model.types.Float readFloat() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.readCurrentByte();
        if ((ch1 | (ch2 = this.readCurrentByte()) | (ch3 = this.readCurrentByte()) | (ch4 = this.readCurrentByte())) < 0) {
            throw new EOFException();
        }
        int val = this.byteOrder == ByteOrder.BIG_ENDIAN ? (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4 : (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
        return new com.easyinnova.tiff.model.types.Float(Float.intBitsToFloat(val));
    }

    public Double readDouble(long position) throws IOException {
        this.seekOffset(position);
        return this.readDouble();
    }

    @Override
    public Double readDouble() throws IOException {
        int ch8;
        int ch7;
        int ch6;
        int ch5;
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.readCurrentByte();
        if ((ch1 | (ch2 = this.readCurrentByte()) | (ch3 = this.readCurrentByte()) | (ch4 = this.readCurrentByte()) | (ch5 = this.readCurrentByte()) | (ch6 = this.readCurrentByte()) | (ch7 = this.readCurrentByte()) | (ch8 = this.readCurrentByte())) < 0) {
            throw new EOFException();
        }
        long val = this.byteOrder == ByteOrder.BIG_ENDIAN ? ((long)ch1 << 56) + ((long)(ch2 & 0xFF) << 48) + ((long)(ch3 & 0xFF) << 40) + ((long)(ch4 & 0xFF) << 32) + ((long)(ch5 & 0xFF) << 24) + ((long)(ch6 & 0xFF) << 16) + ((long)(ch7 & 0xFF) << 8) + (long)(ch8 & 0xFF) : ((long)ch8 << 56) + ((long)(ch7 & 0xFF) << 48) + ((long)(ch6 & 0xFF) << 40) + ((long)(ch5 & 0xFF) << 32) + ((long)(ch4 & 0xFF) << 24) + ((long)(ch3 & 0xFF) << 16) + ((long)(ch2 & 0xFF) << 8) + (long)(ch1 & 0xFF);
        return new Double(java.lang.Double.longBitsToDouble(val));
    }

    public long size() {
        if (this.internalFile != null) {
            return this.internalFile.size();
        }
        return this.internalFileBig.size();
    }
}

